/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.data.file.FileDataProvider;
import java.io.File;

public class CPPDataProvider
extends FileDataProvider {
    public CPPDataProvider() {
        super(Language.LANGUAGE.C_PLUS_PLUS);
    }

    @Override
    public Vdb getNonClassFuncsVdb(VDBEnums.BUCKET bucket) throws VDBGeneralException {
        Vdb ret = new Vdb(this.getLanguage());
        File dir = new File(this.getBaseDir(bucket));
        try {
            this.processDirectory(ret, dir);
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
        return ret;
    }

    private void processDirectory(Vdb v, File dir) throws BadMarkupException {
        block3: {
            block2: {
                if (!dir.isDirectory()) break block2;
                for (File f : dir.listFiles()) {
                    this.processDirectory(v, f);
                }
                break block3;
            }
            if (!dir.getPath().endsWith("vdb")) break block3;
            Vdb c = VdbProvider.getVdb(dir);
            for (Method m : c.getMethods()) {
                v.addMethod(m);
            }
        }
    }
}

