/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.misc.VDBConstants;
import com.ibm.appscan.vdb.provider.data.AuditListProvider;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

public class FileAuditListProvider
extends AuditListProvider {
    public FileAuditListProvider(Language.LANGUAGE lang) {
        super(lang);
    }

    @Override
    public ArrayList<Date> getDateAvailableAuditDates(Date fromDate, Date toDate) throws VDBGeneralException {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (String date : this.getStringAvailableAuditDates(fromDate, toDate)) {
            Date d;
            try {
                d = VDBConstants.AUDIT_DATE_FORMAT.parse(date);
            }
            catch (ParseException e) {
                throw new VDBGeneralException(e);
            }
            dates.add(d);
        }
        return dates;
    }

    @Override
    public ArrayList<String> getStringAvailableAuditDates(Date fromDate, Date toDate) throws VDBGeneralException {
        ArrayList<String> dates = new ArrayList<String>();
        File f = new File(CommonCore.getDirectoryLocator().getVdb() + "audit" + File.separator + this.getLanguage().toVdbString());
        if (f.exists()) {
            for (File dir : f.listFiles()) {
                if (!dir.isDirectory() || FileUtil.isHidden((File)dir)) continue;
                String dirName = dir.getName();
                try {
                    boolean inRange;
                    Date date = VDBConstants.AUDIT_DATE_FORMAT.parse(dirName);
                    boolean bl = inRange = !(fromDate != null && !date.equals(fromDate) && !date.after(fromDate) || toDate != null && !date.equals(toDate) && !date.before(toDate));
                    if (!inRange) continue;
                    dates.add(dirName);
                }
                catch (ParseException e) {
                    throw new VDBGeneralException(e);
                }
            }
        }
        return dates;
    }
}

