/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file.load;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.EnumProvider;
import com.ibm.appscan.vdb.provider.data.file.load.BaseXmlRuleReader;
import com.ibm.appscan.vdb.provider.data.file.load.GateHandler;
import com.ibm.appscan.vdb.rule.SearchRule;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class RuleHandler
extends BaseXmlRuleReader {
    protected RuleHandler(XMLEventReader reader) {
        super(reader);
    }

    @Override
    protected boolean process(StartElement element) {
        if (element.getName().toString().equals("signature")) {
            this.setOperator(this.getRule().getMethodRule().getSignatureRule(), element);
            this.setValue(this.getRule().getMethodRule().getSignatureRule(), element);
        } else if (element.getName().toString().equals("arg_count")) {
            this.setOperator(this.getRule().getMethodRule().getArgCountRule(), element);
            this.setValue(this.getRule().getMethodRule().getArgCountRule(), element);
        } else if (element.getName().toString().equals("argument")) {
            this.setOperator(this.getRule().getMethodRule().getArgumentRule(), element);
            this.setValue(this.getRule().getMethodRule().getArgumentRule(), element);
            this.getRule().getMethodRule().getArgumentRule().setArgPos(Integer.parseInt(this.getAttribute(element, "position")));
        } else if (element.getName().toString().equals("class")) {
            this.setOperator(this.getRule().getMethodRule().getClassRule(), element);
            this.setValue(this.getRule().getMethodRule().getClassRule(), element);
        } else if (element.getName().toString().equals("package")) {
            this.setOperator(this.getRule().getMethodRule().getPackageRule(), element);
            this.setValue(this.getRule().getMethodRule().getPackageRule(), element);
        } else if (element.getName().toString().equals("return")) {
            this.setOperator(this.getRule().getMethodRule().getReturnRule(), element);
            this.setValue(this.getRule().getMethodRule().getReturnRule(), element);
        } else if (element.getName().toString().equals("OptionBasedTester")) {
            try {
                this.setOperator(this.getRule().getOptionRule(), element);
                if (this.getAttribute(element, "min_confidence") != null) {
                    this.getRule().getOptionRule().setMinConfidence(EnumProvider.getOptionCon(this.getAttribute(element, "min_confidence")));
                }
                if (this.getAttribute(element, "max_confidence") != null) {
                    this.getRule().getOptionRule().setMaxConfidence(EnumProvider.getOptionCon(this.getAttribute(element, "max_confidence")));
                }
                if (this.getAttribute(element, "option_name") != null) {
                    this.getRule().getOptionRule().setOptionName(EnumProvider.getOptionName(this.getAttribute(element, "option_name")));
                }
                if (this.getAttribute(element, "option_operator") != null) {
                    this.getRule().getOptionRule().setOptionOperator(EnumProvider.getOptionOperator(this.getAttribute(element, "option_operator")));
                }
                if (this.getAttribute(element, "option_parameter") != null) {
                    this.getRule().getOptionRule().setOptionParameter(this.getAttribute(element, "option_parameter"));
                }
                if (this.getAttribute(element, "option_value") != null) {
                    this.getRule().getOptionRule().setOptionValue(this.getAttribute(element, "option_value"));
                }
                if (this.getAttribute(element, "severity") != null) {
                    this.getRule().getOptionRule().setSeverity(EnumProvider.getSeverity(this.getAttribute(element, "severity")));
                }
                if (this.getAttribute(element, "vulnerability") != null) {
                    this.getRule().getOptionRule().setVulnerability(this.getAttribute(element, "vulnerability"));
                }
            }
            catch (BadRuleException e) {
                CommonCore.getLogManager().log(new Message((Throwable)e));
            }
        } else if (element.getName().toString().equals("ActionObject")) {
            try {
                this.setOperator(this.getRule().getActionObjectRule(), element);
                if (this.getAttribute(element, "ao_type") != null) {
                    this.getRule().getActionObjectRule().setAoType(EnumProvider.getAoType(this.getAttribute(element, "ao_type")));
                }
                if (this.getAttribute(element, "severity") != null) {
                    this.getRule().getActionObjectRule().setSeverity(EnumProvider.getSeverity(this.getAttribute(element, "severity")));
                }
                if (this.getAttribute(element, "parameter") != null) {
                    this.getRule().getActionObjectRule().setParameter(this.getAttribute(element, "parameter"));
                }
                if (this.getAttribute(element, "return") != null) {
                    this.getRule().getActionObjectRule().setReturn(Boolean.parseBoolean(this.getAttribute(element, "return")));
                }
                if (this.getAttribute(element, "vulnerability") != null) {
                    this.getRule().getActionObjectRule().setVulnerability(this.getAttribute(element, "vulnerability"));
                }
            }
            catch (BadRuleException e) {
                CommonCore.getLogManager().log(new Message((Throwable)e));
            }
        } else if (element.getName().toString().equals("Taint")) {
            try {
                this.setOperator(this.getRule().getTaintRule(), element);
                if (this.getAttribute(element, "dst_parameter") != null) {
                    this.getRule().getTaintRule().setDestinationParameter(this.getAttribute(element, "dst_parameter"));
                }
                if (this.getAttribute(element, "source_parameter") != null) {
                    this.getRule().getTaintRule().setSourceParameter(this.getAttribute(element, "source_parameter"));
                }
                if (this.getAttribute(element, "return") != null) {
                    this.getRule().getTaintRule().setReturn(Boolean.parseBoolean(this.getAttribute(element, "return")));
                }
            }
            catch (BadRuleException bre) {
                CommonCore.getLogManager().log(new Message((Throwable)bre));
            }
        } else if (element.getName().toString().equals("Property")) {
            this.setOperator(this.getRule().getPropertyRule(), element);
            this.setValue(this.getRule().getPropertyRule(), element);
        } else if (element.getName().toString().equals("LogicGate")) {
            VDBEnums.RULE_GATE_TYPE type = EnumProvider.getRuleGateType(this.getAttribute(element, "type"));
            try {
                GateHandler handler = new GateHandler(this.getXmlEventReader(), this.getRule().createLogicGate(this.getAttribute(element, "name"), type));
                handler.parse();
            }
            catch (BadRuleException e) {
                CommonCore.getLogManager().log(new Message((Throwable)e));
            }
        } else if (element.getName().toString().equals("special_cases")) {
            for (VDBEnums.SPECIAL_CASES sc : VDBEnums.SPECIAL_CASES.values()) {
                if (this.getAttribute(element, sc.toString()) == null) continue;
                try {
                    this.getRule().getSpecialCaseRule().setSpecialCase(sc);
                }
                catch (BadRuleException e) {
                    CommonCore.getLogManager().log(new Message((Throwable)e));
                }
            }
        }
        return true;
    }

    @Override
    protected boolean process(EndElement element) {
        if (element.getName().toString().equals("Rule")) {
            return false;
        }
        return super.process(element);
    }

    private void setOperator(SearchRule rule, StartElement element) {
        try {
            if (this.getAttribute(element, "operator") != null) {
                rule.setRuleOperator(EnumProvider.getRuleOperator(this.getAttribute(element, "operator")));
            }
        }
        catch (BadRuleException e) {
            CommonCore.getLogManager().log(new Message((Throwable)e));
        }
    }

    private void setValue(SearchRule rule, StartElement element) {
        try {
            rule.setRuleValue(this.getAttribute(element, "value"));
        }
        catch (BadRuleException e) {
            CommonCore.getLogManager().log(new Message((Throwable)e));
        }
    }
}

