/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file.save;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.markup.Property;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class PropertyWriter {
    private DOMWriter m_writer;
    private DocumentBuilder m_builder;
    private Transformer m_transformer;
    private File m_file = new File(CommonCore.getDirectoryLocator().getConfig());

    public PropertyWriter() throws VDBGeneralException {
        this.init();
    }

    public PropertyWriter(File f) throws VDBGeneralException {
        this.m_file = f;
        this.init();
    }

    private void init() throws VDBGeneralException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.m_builder = factory.newDocumentBuilder();
            TransformerFactory transform_factory = TransformerFactory.newInstance();
            this.m_transformer = transform_factory.newTransformer();
            this.m_transformer.setOutputProperty("indent", "yes");
            this.m_transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            this.m_transformer.setOutputProperty("standalone", "yes");
        }
        catch (ParserConfigurationException e) {
            throw new VDBGeneralException("Issue initializing document writer {0}", e.getLocalizedMessage());
        }
        catch (TransformerConfigurationException tce) {
            throw new VDBGeneralException("Issue configuring the transformer: {0}", tce.getLocalizedMessage());
        }
    }

    public void write() throws BadMarkupException, VDBGeneralException {
        try {
            Property p;
            this.m_writer = new DOMWriter(this.m_file, "vdb_properties.xml", this.m_builder);
            this.m_writer.beginElement("Properties");
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (String prop : VdbProvider.getPropertyProvider().getProperties()) {
                p = new Property(prop);
                ids.add(p.getPropertyId());
            }
            for (String prop : VdbProvider.getPropertyProvider().getVulnerabilities()) {
                p = new Property(prop);
                ids.add(p.getPropertyId());
            }
            for (String prop : VdbProvider.getPropertyProvider().getTechnologies()) {
                p = new Property(prop);
                ids.add(p.getPropertyId());
            }
            for (String prop : VdbProvider.getPropertyProvider().getMechanisms()) {
                p = new Property(prop);
                ids.add(p.getPropertyId());
            }
            Collections.sort(ids);
            Iterator<String> iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)((Object)iterator.next());
                p = new Property(id);
                this.writeProperty(p);
            }
            this.m_writer.endElement();
            this.m_writer.write(this.m_transformer);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        catch (TransformerException e) {
            throw new VDBGeneralException(e);
        }
    }

    private void writeProperty(Property p) throws VDBGeneralException {
        this.m_writer.beginElement("property");
        this.m_writer.setAttribute("id", Integer.toString(p.getPropertyId()));
        this.m_writer.setAttribute("fqn", p.getProperty());
        this.m_writer.endElement();
    }
}

