/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file.save;

import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.BaseLogicGate;
import com.ibm.appscan.vdb.rule.Rule;

public class RuleWriter {
    private DOMWriter m_writer;

    protected RuleWriter(DOMWriter writer) {
        this.m_writer = writer;
    }

    public void writeRule(Rule r) throws BadRuleException, VDBGeneralException {
        this.m_writer.beginElement("Rule");
        this.m_writer.setAttribute("delete", r.isDelete() ? "true" : "false");
        this.m_writer.setAttribute("name", r.getRuleName());
        this.m_writer.setAttribute("type", r.getType().toString());
        if (r.getMethodRule().isSearchValid()) {
            this.writeMethodRulePart(r);
        }
        if (r.getOptionRule().isSearchValid() || r.getOptionRule().isRuleValid()) {
            this.writeObtRule(r);
        }
        if (r.getActionObjectRule().isSearchValid() || r.getActionObjectRule().isRuleValid()) {
            this.writeActionObject(r);
        }
        if (r.getTaintRule().isSearchValid() || r.getTaintRule().isRuleValid()) {
            this.writeTaint(r);
        }
        if (r.getPropertyRule().isSearchValid() || r.getPropertyRule().isRuleValid()) {
            this.writeProperty(r);
        }
        this.writeGates(r);
        if (r.getSpecialCaseRule().isRuleValid()) {
            this.m_writer.beginElement("special_cases");
            for (VDBEnums.SPECIAL_CASES sc : VDBEnums.SPECIAL_CASES.values()) {
                if (!r.getSpecialCaseRule().isSpecialCase(sc)) continue;
                this.m_writer.setAttribute(sc.toString(), "true");
            }
            this.m_writer.endElement();
        }
        this.m_writer.endElement();
    }

    private void writeMethodRulePart(Rule r) throws BadRuleException, VDBGeneralException {
        this.m_writer.beginElement("MethodRules");
        if (r.getMethodRule().getSignatureRule().isSearchValid()) {
            this.m_writer.beginElement("signature");
            this.m_writer.setAttribute("operator", r.getMethodRule().getSignatureRule().getRuleOperator().toString());
            this.m_writer.setAttribute("value", r.getMethodRule().getSignatureRule().getRuleValue());
            this.m_writer.endElement();
        }
        if (r.getMethodRule().getArgCountRule().isSearchValid()) {
            this.m_writer.beginElement("arg_count");
            this.m_writer.setAttribute("operator", r.getMethodRule().getArgCountRule().getRuleOperator().toString());
            this.m_writer.setAttribute("value", r.getMethodRule().getArgCountRule().getRuleValue());
            this.m_writer.endElement();
        }
        if (r.getMethodRule().getArgumentRule().isRuleValid()) {
            this.m_writer.beginElement("argument");
            this.m_writer.setAttribute("operator", r.getMethodRule().getArgumentRule().getRuleOperator().toString());
            this.m_writer.setAttribute("value", r.getMethodRule().getArgumentRule().getRuleValue());
            this.m_writer.setAttribute("position", Integer.toString(r.getMethodRule().getArgumentRule().getArgPos()));
            this.m_writer.endElement();
        }
        if (r.getMethodRule().getClassRule().isSearchValid()) {
            this.m_writer.beginElement("class");
            this.m_writer.setAttribute("operator", r.getMethodRule().getClassRule().getRuleOperator().toString());
            this.m_writer.setAttribute("value", r.getMethodRule().getClassRule().getRuleValue());
            this.m_writer.endElement();
        }
        if (r.getMethodRule().getPackageRule().isSearchValid()) {
            this.m_writer.beginElement("package");
            this.m_writer.setAttribute("operator", r.getMethodRule().getPackageRule().getRuleOperator().toString());
            this.m_writer.setAttribute("value", r.getMethodRule().getPackageRule().getRuleValue());
            this.m_writer.endElement();
        }
        if (r.getMethodRule().getReturnRule().isSearchValid()) {
            this.m_writer.beginElement("return");
            this.m_writer.setAttribute("operator", r.getMethodRule().getReturnRule().getRuleOperator().toString());
            this.m_writer.setAttribute("value", r.getMethodRule().getReturnRule().getRuleValue());
            this.m_writer.endElement();
        }
        this.m_writer.endElement();
    }

    private void writeObtRule(Rule r) throws BadRuleException, VDBGeneralException {
        this.m_writer.beginElement("OptionBasedTester");
        if (r.getOptionRule().isSearchValid()) {
            this.m_writer.setAttribute("operator", r.getOptionRule().getRuleOperator().toString());
        }
        if (r.getOptionRule().getSeverity() != VDBEnums.SEVERITY.DEFAULT) {
            this.m_writer.setAttribute("severity", r.getOptionRule().getSeverity().toString());
        }
        if (r.getOptionRule().getVulnerability() != null) {
            this.m_writer.setAttribute("vulnerability", r.getOptionRule().getVulnerability());
        }
        if (r.getOptionRule().getOptionName() != null) {
            this.m_writer.setAttribute("option_name", r.getOptionRule().getOptionName().toString());
        }
        if (r.getOptionRule().getOptionOperator() != null) {
            this.m_writer.setAttribute("option_operator", r.getOptionRule().getOptionOperator().toString());
        }
        if (r.getOptionRule().getOptionParameter() != null) {
            this.m_writer.setAttribute("option_parameter", r.getOptionRule().getOptionParameter());
        }
        if (r.getOptionRule().getOptionValue() != null) {
            this.m_writer.setAttribute("option_value", r.getOptionRule().getOptionValue());
        }
        if (r.getOptionRule().getMaxConfidence() != VDBEnums.OPTION_CONFIDENCE.NULL) {
            this.m_writer.setAttribute("max_confidence", r.getOptionRule().getMaxConfidence().toString());
        }
        if (r.getOptionRule().getMinConfidence() != VDBEnums.OPTION_CONFIDENCE.NULL) {
            this.m_writer.setAttribute("min_confidence", r.getOptionRule().getMinConfidence().toString());
        }
        this.m_writer.endElement();
    }

    private void writeActionObject(Rule r) throws BadRuleException, VDBGeneralException {
        this.m_writer.beginElement("ActionObject");
        if (r.getActionObjectRule().isSearchValid()) {
            this.m_writer.setAttribute("operator", r.getActionObjectRule().getRuleOperator().toString());
        }
        if (r.getActionObjectRule().getAoType() != VDBEnums.AO_TYPE.DEFAULT) {
            this.m_writer.setAttribute("ao_type", r.getActionObjectRule().getAoType().toString());
        }
        if (r.getActionObjectRule().getParameter() != null) {
            this.m_writer.setAttribute("parameter", r.getActionObjectRule().getParameter());
        }
        if (r.getActionObjectRule().getSeverity() != VDBEnums.SEVERITY.DEFAULT) {
            this.m_writer.setAttribute("severity", r.getActionObjectRule().getSeverity().toString());
        }
        if (r.getActionObjectRule().getVulnerability() != null) {
            this.m_writer.setAttribute("vulnerability", r.getActionObjectRule().getVulnerability());
        }
        if (r.getActionObjectRule().getReturnRule().isRuleValid()) {
            this.m_writer.setAttribute("return", r.getActionObjectRule().getReturnRule().getRuleValue());
        }
        this.m_writer.endElement();
    }

    private void writeTaint(Rule r) throws BadRuleException, VDBGeneralException {
        this.m_writer.beginElement("Taint");
        if (r.getTaintRule().isSearchValid()) {
            this.m_writer.setAttribute("operator", r.getTaintRule().getRuleOperator().toString());
        }
        if (r.getTaintRule().getSourceParameter() != null) {
            this.m_writer.setAttribute("source_parameter", r.getTaintRule().getSourceParameter());
        }
        if (r.getTaintRule().getDestinationParameter() != null) {
            this.m_writer.setAttribute("dst_parameter", r.getTaintRule().getDestinationParameter());
        }
        if (r.getTaintRule().getReturnRule().isRuleValid()) {
            this.m_writer.setAttribute("return", r.getTaintRule().getReturnRule().getRuleValue());
        }
        this.m_writer.endElement();
    }

    private void writeProperty(Rule r) throws BadRuleException, VDBGeneralException {
        this.m_writer.beginElement("Property");
        if (r.getPropertyRule().isSearchValid()) {
            this.m_writer.setAttribute("operator", r.getPropertyRule().getRuleOperator().toString());
        }
        this.m_writer.setAttribute("value", r.getPropertyRule().getRuleValue());
        this.m_writer.endElement();
    }

    private void writeGates(Rule r) throws BadRuleException, VDBGeneralException {
        for (BaseLogicGate gate : r.getGates()) {
            this.m_writer.beginElement("LogicGate");
            this.m_writer.setAttribute("type", gate.getType().toString());
            this.m_writer.setAttribute("name", gate.getRuleName());
            for (Rule gate_r : gate.getRules()) {
                this.writeRule(gate_r);
            }
            this.m_writer.endElement();
        }
    }
}

