/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.property;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.vdb.Messages;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Property;
import com.ibm.appscan.vdb.provider.data.file.load.ScanConfigLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public class PropertyFilterProvider {
    private ArrayList<String> m_rule_properties = new ArrayList();

    public PropertyFilterProvider(File file) throws VDBGeneralException {
        ScanConfigLoader loader = new ScanConfigLoader(file);
        try {
            loader.read();
            this.m_rule_properties = loader.getRuleProperties();
        }
        catch (FileNotFoundException e) {
            throw new VDBGeneralException("File not found: " + e.getLocalizedMessage(), new Object[0]);
        }
        catch (XMLStreamException xmle) {
            throw new VDBGeneralException("Xml parse exception: " + xmle.getLocalizedMessage(), new Object[0]);
        }
    }

    public ArrayList<String> getRuleProperties() throws VDBGeneralException {
        return this.m_rule_properties;
    }

    public Vdb apply(Vdb v) throws AppScanException {
        for (Method m : v.getMethods()) {
            if (this.isAllowed(m)) continue;
            v.deleteMethod(m);
        }
        return v;
    }

    private boolean isAllowed(Method m) {
        if (m.getSources().size() == 0) {
            return true;
        }
        if (this.m_rule_properties.isEmpty()) {
            return true;
        }
        if (m.getSignature().contains("automatic_callback_source")) {
            return true;
        }
        for (String ruleName : this.m_rule_properties) {
            try {
                Property ruleProperty = new Property(ruleName);
                if (!m.getAllProperties().contains(ruleProperty)) continue;
                return true;
            }
            catch (BadMarkupException e) {
                CommonCore.getLogManager().log(new Message(1, Messages.getMessage("unknown.scan.rule", ruleName)));
            }
        }
        return false;
    }
}

