/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.rest;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.provider.data.file.load.RuleReader;
import com.ibm.appscan.vdb.provider.data.file.save.RuleStreamWriter;
import com.ibm.appscan.vdb.provider.rest.BaseRestClient;
import com.ibm.appscan.vdb.rule.Rule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.Set;

public abstract class BaseRuleRestClient
extends BaseRestClient {
    private Language.LANGUAGE m_lang;

    protected BaseRuleRestClient(Language.LANGUAGE lang, String host, String port, boolean secure) {
        super(host, port, secure);
        this.m_lang = lang;
    }

    @Override
    protected String getApplicationBase() {
        return "sast/rules";
    }

    protected abstract String getType();

    public Set<String> getRules() throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getType() + "/" + this.m_lang.toString() + "/list", "GET");
            if (conn.getResponseCode() == 200) {
                return this.splitResponse(conn, "#");
            }
            throw new VDBGeneralException("Server error during rule retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Collection<Rule> getRulesXml() throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getType() + "/" + this.m_lang.toString() + "/rules", "GET");
            if (conn.getResponseCode() == 200) {
                return this.getRules(conn.getInputStream());
            }
            throw new VDBGeneralException("Server error during rule retrieval: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public Rule getRuleXml(String rule_name) throws VDBGeneralException {
        block4: {
            try {
                HttpURLConnection conn = this.getConnection(this.getType() + "/" + this.m_lang.toString() + "/rule", "GET");
                conn.addRequestProperty("Cookie", rule_name);
                if (conn.getResponseCode() == 200) {
                    Collection<Rule> rules = this.getRules(conn.getInputStream());
                    if (rules != null && rules.size() == 1) {
                        return rules.iterator().next();
                    }
                    break block4;
                }
                throw new VDBGeneralException("Server error during rule retrieval: " + conn.getResponseCode(), new Object[0]);
            }
            catch (IOException e) {
                throw new VDBGeneralException(e);
            }
        }
        return null;
    }

    public boolean addRule(Rule r) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getType() + "/" + this.m_lang.toString() + "/rule/add", "PUT");
            this.addRulePart(conn.getOutputStream(), r);
            if (conn.getResponseCode() == 200) {
                return true;
            }
            if (conn.getResponseCode() == 204) {
                throw new VDBGeneralException("Invalid Vdb structure", new Object[0]);
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        catch (BadRuleException e) {
            throw new VDBGeneralException(e);
        }
    }

    public boolean deleteRule(Rule r) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.getType() + "/" + this.m_lang.toString() + "/rule/delete", "PUT");
            this.addRulePart(conn.getOutputStream(), r);
            if (conn.getResponseCode() == 200) {
                return true;
            }
            if (conn.getResponseCode() == 204) {
                throw new VDBGeneralException("Invalid Vdb structure", new Object[0]);
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        catch (BadRuleException e) {
            throw new VDBGeneralException(e);
        }
    }

    protected void addRulePart(OutputStream output, Rule r) throws VDBGeneralException, BadRuleException {
        try {
            output.write("Content-Disposition: form-data; name=\"vdb\"".getBytes());
            output.write(System.getProperty("line.separator").getBytes());
            output.write("Content-Type: multipart/form-data".getBytes());
            output.write(System.getProperty("line.separator").getBytes());
            output.write("Content-Transfer-Encoding: binary".getBytes());
            output.write(System.getProperty("line.separator").getBytes());
            RuleStreamWriter writer = new RuleStreamWriter(output);
            writer.writeRules(r);
            output.flush();
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    protected Collection<Rule> getRules(InputStream stream) throws VDBGeneralException {
        RuleReader handler = new RuleReader(stream);
        handler.parse();
        return handler.getRules();
    }
}

