/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule.method;

import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.SearchRule;

public class MethodArgumentRule
extends SearchRule {
    private int m_arg_pos = -1;

    public void setArgPos(int pos) {
        this.m_arg_pos = pos;
    }

    public int getArgPos() {
        return this.m_arg_pos;
    }

    @Override
    public boolean allowsContains() {
        return true;
    }

    @Override
    protected void validateOperator(VDBEnums.RULE_OPERATOR operator) throws BadRuleException {
        if (operator == VDBEnums.RULE_OPERATOR.NULL) {
            throw new BadRuleException("Cannot use NULL for a rule RULE_OPERATOR.");
        }
        if (operator == VDBEnums.RULE_OPERATOR.INTEGER_EQUALS || operator == VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN || operator == VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN_EQUALS || operator == VDBEnums.RULE_OPERATOR.INTEGER_LESS_THAN || operator == VDBEnums.RULE_OPERATOR.INTEGER_LESS_THAN_EQUALS || operator == VDBEnums.RULE_OPERATOR.INTEGER_NOT_EQUALS) {
            throw new BadRuleException("Cannot use an integer operator with a string rule:{0}", operator.toString());
        }
    }

    @Override
    public boolean searchRule(Method m) {
        if (this.getRuleOperator() == VDBEnums.RULE_OPERATOR.EQUALS) {
            if (this.getArgPos() != -1) {
                if (m.getArgs().size() > this.getArgPos()) {
                    if (this.getRuleValue().toLowerCase().equals(m.getArgs().get(this.getArgPos()).toLowerCase())) {
                        return true;
                    }
                    try {
                        if (this.getRuleValue().toLowerCase().equals(m.getSimpleArgString(this.getArgPos()).toLowerCase())) {
                            return true;
                        }
                    }
                    catch (VDBException e) {
                        return false;
                    }
                }
            } else if (m.getArgs().size() > 0) {
                for (int i = 0; i < m.getArgs().size(); ++i) {
                    try {
                        if (this.getRuleValue().toLowerCase().equals(m.getArgs().get(i).toLowerCase()) || this.getRuleValue().toLowerCase().equals(m.getSimpleArgString(i).toLowerCase())) continue;
                        return false;
                    }
                    catch (VDBException e) {
                        return false;
                    }
                }
                return true;
            }
        }
        if (this.getRuleOperator() == VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL) {
            if (this.getArgPos() != -1) {
                if (m.getArgs().size() > this.getArgPos()) {
                    try {
                        if (!this.getRuleValue().toLowerCase().equals(m.getArgs().get(this.getArgPos()).toLowerCase()) && !this.getRuleValue().toLowerCase().equals(m.getSimpleArgString(this.getArgPos()).toLowerCase())) {
                            return true;
                        }
                    }
                    catch (VDBException e) {
                        return false;
                    }
                }
            } else if (m.getArgs().size() > 0) {
                for (int i = 0; i < m.getArgs().size(); ++i) {
                    try {
                        if (!this.getRuleValue().toLowerCase().equals(m.getArgs().get(i).toLowerCase()) && !this.getRuleValue().toLowerCase().equals(m.getSimpleArgString(i).toLowerCase())) continue;
                        return false;
                    }
                    catch (VDBException e) {
                        return false;
                    }
                }
                return true;
            }
        }
        if (this.getRuleOperator() == VDBEnums.RULE_OPERATOR.CONTAINS) {
            for (int i = 0; i < m.getArgs().size(); ++i) {
                try {
                    if (this.getRuleValue().toLowerCase().equals(m.getArgs().get(i).toLowerCase()) || this.getRuleValue().toLowerCase().equals(m.getSimpleArgString(i).toLowerCase())) {
                        return true;
                    }
                    if (m.getArgs().get(i).toLowerCase().contains(this.getRuleValue().toLowerCase())) {
                        return true;
                    }
                    if (!m.getSimpleArgString(i).toLowerCase().contains(this.getRuleValue().toLowerCase())) continue;
                    return true;
                }
                catch (VDBException e) {
                    return false;
                }
            }
        }
        if (this.getRuleOperator() == VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN) {
            boolean found = false;
            for (int i = 0; i < m.getArgs().size(); ++i) {
                if (this.getRuleValue().toLowerCase().equals(m.getArgs().get(i).toLowerCase())) {
                    found = true;
                }
                try {
                    if (this.getRuleValue().toLowerCase().equals(m.getSimpleArgString(i).toLowerCase())) {
                        found = true;
                    }
                    if (m.getArgs().get(i).toLowerCase().contains(this.getRuleValue().toLowerCase())) {
                        found = true;
                    }
                    if (!m.getSimpleArgString(i).toLowerCase().contains(this.getRuleValue().toLowerCase())) continue;
                    found = true;
                    continue;
                }
                catch (VDBException e) {
                    return false;
                }
            }
            if (!found) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDetailName() {
        return "Method Arguments";
    }
}

