/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule.method.properties;

import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Property;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.rule.ApplyRule;
import java.util.ArrayList;

public class PropertyRule
extends ApplyRule {
    @Override
    public String getDetailName() {
        return "Property";
    }

    @Override
    public boolean applyRule(Method m) throws BadRuleException {
        try {
            return m.addProperty(new Property(this.getId()));
        }
        catch (BadMarkupException e) {
            return false;
        }
    }

    @Override
    public void setRuleValue(String value) throws BadRuleException {
        super.setRuleValue(value);
        this.getId();
    }

    @Override
    protected boolean searchRule(Method m) {
        for (Property p : m.getAllProperties()) {
            try {
                if (!this.compareValues(this.getRuleOperator(), this.getId(), p.getPropertyId())) continue;
                return true;
            }
            catch (BadRuleException e) {
                return false;
            }
        }
        return false;
    }

    protected ArrayList<Property> getPropertiesForCompare(Method m) {
        return m.getAllProperties();
    }

    @Override
    public boolean allowsContains() {
        return false;
    }

    protected int getId() throws BadRuleException {
        int id = 0;
        try {
            id = VdbProvider.getPropertyProvider().getPropertyId("Mechanism." + this.getRuleValue());
            if (id == 0) {
                id = VdbProvider.getPropertyProvider().getPropertyId("Technology." + this.getRuleValue());
            }
            if (id == 0) {
                id = VdbProvider.getPropertyProvider().getPropertyId(this.getRuleValue());
            }
        }
        catch (VDBGeneralException e) {
            throw new BadRuleException(e);
        }
        if (id == 0) {
            throw new BadRuleException("Invalid property:" + this.getRuleValue());
        }
        return id;
    }
}

