/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetWalaUtil;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.dotnet.loader.CLRClass;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.loader.CLRMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class F4FApp {
    private final IClassHierarchy cha;

    public F4FApp(IClassHierarchy cha) {
        this.cha = cha;
    }

    @Deprecated
    public IClass getAppClass(String vdbClassName) {
        return this.getIClass(vdbClassName);
    }

    public IClass getIClass(String vdbClassName) {
        Language l = this.cha.getRootClass().getClassLoader().getLanguage();
        if (l.equals(Language.JAVA)) {
            IClass klass = this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)VDBJavaUtil.vdbToJVMType((String)vdbClassName)));
            return klass;
        }
        return DotNetWalaUtil.getIClass((String)vdbClassName, (IClassHierarchy)this.cha);
    }

    public Collection<Annotation> getClassAnnotations(IClass klass) {
        Language l = klass.getClassLoader().getLanguage();
        if (l.equals(Language.JAVA)) {
            if (klass instanceof ShrikeClass) {
                ShrikeClass shrikeClass = (ShrikeClass)klass;
                ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                try {
                    annotations.addAll(shrikeClass.getAnnotations(true));
                    annotations.addAll(shrikeClass.getAnnotations(false));
                }
                catch (Exception e) {
                    TaintLogger.i().getLogger().info((Object)("error reading annotations for class " + klass));
                    return Collections.emptySet();
                }
                return annotations;
            }
        } else if (l.equals(CLRLanguage.lang) && klass instanceof CLRClass) {
            CLRClass clrClass = (CLRClass)klass;
            List<Annotation> annotations = Arrays.asList(clrClass.getAttributes());
            return annotations;
        }
        return Collections.emptySet();
    }

    public Collection<Annotation> getMethodAnnotations(IMethod method) {
        Language l = method.getDeclaringClass().getClassLoader().getLanguage();
        if (l.equals(Language.JAVA)) {
            if (method instanceof ShrikeCTMethod) {
                ShrikeCTMethod shrikeMethod = (ShrikeCTMethod)method;
                ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                try {
                    annotations.addAll(shrikeMethod.getAnnotations(true));
                    annotations.addAll(shrikeMethod.getAnnotations(false));
                }
                catch (Exception e) {
                    TaintLogger.i().getLogger().info((Object)("error reading annotations for method " + method));
                    return Collections.emptySet();
                }
                return annotations;
            }
        } else if (l.equals(CLRLanguage.lang) && method instanceof CLRMethod) {
            return method.getAnnotations();
        }
        return Collections.emptySet();
    }

    public Collection<Annotation> getFieldAnnotations(IField field) {
        return field.getAnnotations();
    }

    public Collection<Annotation>[] getMethodParametersAnnotations(IMethod method) {
        if (method instanceof IBytecodeMethod) {
            IBytecodeMethod bytecodeMethod = (IBytecodeMethod)method;
            try {
                return bytecodeMethod.getParameterAnnotations();
            }
            catch (Exception e) {
                TaintLogger.i().getLogger().info((Object)("error reading annotations for method " + method));
            }
        }
        int numAnnotatedParams = method.isStatic() ? method.getNumberOfParameters() : method.getNumberOfParameters() - 1;
        Collection[] parametersAnnotations = new Collection[numAnnotatedParams];
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            parametersAnnotations[i] = HashSetFactory.make();
        }
        return parametersAnnotations;
    }

    private void addTypeNamesOfAnnotations(Collection<Annotation> annotations, Collection<String> result, Language l) {
        for (Annotation annot : annotations) {
            TypeReference type = annot.getType();
            String typename = type.getName().toString();
            result.add(l.equals(Language.JAVA) ? VDBJavaUtil.jvmToVDBType((String)typename) : DotNetVDBUtil.walaDotNet2FullyQualifiedVDBType((String)typename));
        }
    }

    public Collection<IClass> getAllApplicationClasses() {
        ArrayList<IClass> result = new ArrayList<IClass>();
        for (IClassLoader loader : this.cha.getLoaders()) {
            if (!this.cha.getScope().isApplicationLoader(loader)) continue;
            result.addAll((Collection<IClass>)Iterator2Collection.toList((Iterator)loader.iterateAllClasses()));
        }
        return result;
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public Collection<IMethod> getMethodsDeclaredInClass(IClass klass) {
        return klass.getDeclaredMethods();
    }

    public Collection<IMethod> getClassMethods(String className, String methodName) {
        IClass appClass = this.getIClass(className);
        if (appClass == null) {
            return Collections.emptySet();
        }
        return this.getClassMethods(appClass, methodName);
    }

    public Collection<IMethod> getClassMethods(IClass appClass, String methodName) {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        for (IMethod m : appClass.getDeclaredMethods()) {
            if (!m.getName().toString().equals(methodName)) continue;
            result.add(m);
        }
        return result;
    }

    public Collection<String> getStringConstantsReturnedByMethod(IMethod method) {
        IClass returnKlass = this.cha.lookupClass(method.getReturnType());
        if (returnKlass == null || !returnKlass.getReference().equals((Object)TypeReference.JavaLangString)) {
            throw new IllegalArgumentException("method " + method + " has invalid return type " + method.getReturnType().getName());
        }
        AnalysisCache cache = new AnalysisCache();
        IR ir = LangIndependentWalaUtil.getIR((IMethod)method, (AnalysisCache)cache);
        StringConstantFlow constantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)cache));
        ArrayList<String> result = new ArrayList<String>();
        for (SSAInstruction instr : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
            if (!(instr instanceof SSAReturnInstruction)) continue;
            result.addAll(constantFlow.findIntraprocStringsFlowingToVar(instr.getUse(0)));
        }
        return result;
    }
}

