/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.processing;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.Global;
import com.ibm.appscan.frameworks.highlevelapi.TaintedParam;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.EnclosingFormal;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Taint;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.FrameworkInfoImpl;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.LocalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.ReturnExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticMethodImpl;
import com.ibm.appscan.frameworks.specinfo.TaintExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.CLRClass;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.StringStuff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class F4FActionProcessor {
    private static Map<String, Set<CallSiteReplacement>> callReplacements = HashMapFactory.make();
    private static Map<String, Set<String>> entrypointUrls = HashMapFactory.make();
    private static final Logger taintLogger = TaintLogger.i().getLogger();

    public static void addCallReplacements(Map<String, Set<CallSiteReplacement>> callReplacementMap) {
        callReplacements.putAll(callReplacementMap);
    }

    public static void addUrls(Map<String, Set<String>> urls) {
        entrypointUrls.putAll(urls);
    }

    public static IFrameworkInfo generateFrameworkInfo(F4FApp app, F4FActions actions) {
        HashSet syntheticMethods = HashSetFactory.make();
        HashSet globalBeanDeclarations = HashSetFactory.make();
        HashMap entrypointSignatureToURL = HashMapFactory.make();
        F4FActionProcessor.handleGlobals(app, actions, globalBeanDeclarations);
        F4FActionProcessor.handleTaintedCallbacks(app, actions, syntheticMethods, entrypointSignatureToURL);
        F4FActionProcessor.handleHighLevelSynthMethods(app, actions, syntheticMethods, entrypointSignatureToURL);
        entrypointSignatureToURL.putAll(entrypointUrls);
        Map<String, Set<CallSiteReplacement>> methodToReplacements = F4FActionProcessor.generateCallReplacements(app, actions);
        FrameworkInfoImpl result = new FrameworkInfoImpl((Set)syntheticMethods, (Set)globalBeanDeclarations, (Map)entrypointSignatureToURL, methodToReplacements);
        Collection<IFrameworkInfo> additionalInfo = actions.getAdditionalFrameworkInfo();
        if (additionalInfo != null) {
            IFrameworkInfo[] f = new IFrameworkInfo[additionalInfo.size() + 1];
            int i = 0;
            Iterator<IFrameworkInfo> iterator = additionalInfo.iterator();
            while (iterator.hasNext()) {
                IFrameworkInfo info;
                f[i] = info = iterator.next();
                ++i;
            }
            f[i] = result;
            result = F4FActionProcessor.mergeFrameworkInfo(f);
        }
        return result;
    }

    private static void handleGlobals(F4FApp app, F4FActions actions, Set<BeanDecl> globalBeanDeclarations) {
        for (Global g : actions.getGlobals()) {
            BeanDecl beanDecl = BeanDecl.makeWithConcreteType((String)g.getName(), (String)g.getDeclaredVDBType(), (BeanDecl.BeanLifespan)(g.isEntrypointScoped() ? BeanDecl.BeanLifespan.ENTRYPOINT : BeanDecl.BeanLifespan.GLOBAL));
            globalBeanDeclarations.add(beanDecl);
        }
    }

    private static void handleHighLevelSynthMethods(F4FApp app, F4FActions actions, Set<ISyntheticMethod> syntheticMethods, Map<String, Set<String>> entrypointSignatureToURL) {
        for (Pair<HighLevelSyntheticMethod, Boolean> p : actions.getHighLevelSyntheticMethods()) {
            HighLevelSyntheticMethod m = (HighLevelSyntheticMethod)p.fst;
            Boolean isEntrypoint = (Boolean)p.snd;
            ISyntheticMethod waflSynthMethod = F4FActionProcessor.genWAFLSyntheticMethod(m, app);
            syntheticMethods.add(waflSynthMethod);
            if (!isEntrypoint.booleanValue()) continue;
            entrypointSignatureToURL.put(waflSynthMethod.getSignature(), Collections.emptySet());
        }
    }

    private static ISyntheticMethod genWAFLSyntheticMethod(HighLevelSyntheticMethod m, F4FApp app) {
        ArrayList<BeanDecl> localBeanDeclarations = new ArrayList<BeanDecl>();
        for (Local local : m.getDeclaredLocals()) {
            localBeanDeclarations.add(BeanDecl.makeWithConcreteType((String)local.getName(), (String)local.getDeclaredVDBType(), (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.LOCAL));
        }
        ArrayList<Object> statements = new ArrayList<Object>();
        for (HighLevelSyntheticMethod.Statement stmt : m.getStatements()) {
            if (stmt instanceof HighLevelSyntheticMethod.Call) {
                HighLevelSyntheticMethod.Call call = (HighLevelSyntheticMethod.Call)stmt;
                HashMap actualParameterPos2Value = HashMapFactory.make();
                Param[] params = call.getParams();
                for (int i = 0; i < params.length; ++i) {
                    Param p = params[i];
                    if (p == null) continue;
                    NonVoidSyntheticExpr argVal = F4FActionProcessor.getNonVoidSynthExprForParam(p);
                    actualParameterPos2Value.put(i, argVal);
                }
                InvokeExpr invoke = InvokeExpr.createInvokeExpr((FilePositionInfo)call.getFilePositionInfo(), (String)call.getCalleeVdbSig(), (Map)actualParameterPos2Value);
                Local returnLocal = call.getReturnLocal();
                if (returnLocal == null) {
                    statements.add(invoke);
                    continue;
                }
                statements.add(AssignmentExpr.make((FilePositionInfo)call.getFilePositionInfo(), (AssignableSyntheticExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)returnLocal.getName()), (String)""), (NonVoidSyntheticExpr)invoke));
                continue;
            }
            if (stmt instanceof HighLevelSyntheticMethod.GlobalWrite) {
                HighLevelSyntheticMethod.GlobalWrite write = (HighLevelSyntheticMethod.GlobalWrite)stmt;
                statements.add(AssignmentExpr.make((FilePositionInfo)write.getFilePositionInfo(), (AssignableSyntheticExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)write.getGlobal().getName()), (String)""), (NonVoidSyntheticExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)write.getValue().getName()), (String)"")));
                continue;
            }
            if (stmt instanceof HighLevelSyntheticMethod.InstanceFieldStatement) {
                HighLevelSyntheticMethod.InstanceFieldStatement instanceFieldStm = (HighLevelSyntheticMethod.InstanceFieldStatement)stmt;
                statements.add(instanceFieldStm.getExpr());
                continue;
            }
            assert (false) : "need to handle Statement type " + stmt.getClass();
        }
        Param param = m.getReturnedValue();
        if (param != null) {
            statements.add(ReturnExpr.make(null, (ObjectRefExpr)((ObjectRefExpr)F4FActionProcessor.getNonVoidSynthExprForParam(param))));
        }
        return new SyntheticMethodImpl(m.getVdbSignature(), localBeanDeclarations, statements);
    }

    public static NonVoidSyntheticExpr getNonVoidSynthExprForParam(Param p) {
        ObjectRefExpr argVal;
        if (p instanceof Local) {
            argVal = ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)((Local)p).getName()), (String)"");
        } else if (p instanceof Taint) {
            argVal = TaintExpr.makeForParameter((String)((Taint)p).getParameterName());
        } else if (p instanceof Global) {
            argVal = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)((Global)p).getName()), (String)"");
        } else if (p instanceof EnclosingFormal) {
            argVal = ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)((EnclosingFormal)p).getIndex()), (String)"");
        } else {
            assert (false) : "need to handle param type " + p.getClass();
            argVal = null;
        }
        return argVal;
    }

    private static void handleTaintedCallbacks(F4FApp app, F4FActions actions, Set<ISyntheticMethod> syntheticMethods, Map<String, Set<String>> entrypointSignatureToURL) {
        Map<String, Collection<TaintedParam>> callbackInfo = actions.getCallback2TaintedParams();
        IClassHierarchy cha = app.getClassHierarchy();
        int callbackCounter = 0;
        for (String callbackSig : callbackInfo.keySet()) {
            ++callbackCounter;
            IMethod m = F4FActionProcessor.resolveMethod(callbackSig, cha);
            if (m == null) {
                taintLogger.warn((Object)("can't find tainted callback method " + callbackSig + "; skipping"));
                continue;
            }
            ArrayList<BeanDecl> locals = new ArrayList<BeanDecl>();
            ArrayList<Object> statements = new ArrayList<Object>();
            HashMap actualParameterPos2Value = HashMapFactory.make();
            for (TaintedParam tp : callbackInfo.get(callbackSig)) {
                int pos = tp.getParamPos();
                String accessPath = tp.getAccessPath();
                String localName = "arg" + pos;
                TypeReference parameterType = m.getParameterType(pos);
                locals.add(BeanDecl.makeWithConcreteType((String)localName, (String)VDBJavaUtil.jvmToVDBType((String)parameterType.getName().toString()), (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.LOCAL));
                statements.add(AssignmentExpr.make(null, (AssignableSyntheticExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)localName), (String)accessPath), (NonVoidSyntheticExpr)TaintExpr.makeForParameter((String)"dummy")));
                actualParameterPos2Value.put(pos, ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)localName), (String)""));
            }
            statements.add(InvokeExpr.createInvokeExpr(null, (String)callbackSig, (Map)actualParameterPos2Value));
            String signature = "AppScan.Synthetic.__callback__" + callbackCounter + "():void";
            syntheticMethods.add((ISyntheticMethod)new SyntheticMethodImpl(signature, locals, statements));
            entrypointSignatureToURL.put(signature, Collections.emptySet());
        }
    }

    private static IMethod resolveMethod(String vdbSig, IClassHierarchy cha) {
        if (cha.getScope() instanceof CLRAnalysisScope) {
            String methodSig = DotNetVDBUtil.vdb2WalaDotNetSignature((String)vdbSig);
            String type = methodSig.substring(0, methodSig.lastIndexOf(46));
            type = StringStuff.deployment2CanonicalTypeString((String)type);
            String methodName = methodSig.substring(methodSig.lastIndexOf(46) + 1, methodSig.indexOf(40));
            String desc = methodSig.substring(methodSig.indexOf(40));
            for (IClassLoader loader : cha.getLoaders()) {
                MethodReference ref;
                IMethod resolved;
                if (!cha.getScope().isApplicationLoader(loader) || (resolved = cha.resolveMethod(ref = MethodReference.findOrCreate((Language)CLRLanguage.lang, (TypeReference)TypeReference.findOrCreate((ClassLoaderReference)loader.getReference(), (String)type), (String)methodName, (String)desc))) == null) continue;
                return resolved;
            }
            return null;
        }
        String jvmSignature = VDBJavaUtil.vdb2JVMSignature((String)vdbSig);
        MethodReference methodReference = StringStuff.makeMethodReference((String)jvmSignature);
        return cha.resolveMethod(methodReference);
    }

    private static Map<String, Set<CallSiteReplacement>> generateCallReplacements(F4FApp app, F4FActions actions) {
        AnalysisCache cache = new AnalysisCache();
        HashMap result = HashMapFactory.make();
        result.putAll(callReplacements);
        IClassHierarchy cha = app.getClassHierarchy();
        Map<String, Map<String, Map<Integer, Pattern>>> callRepl2SigInfo = actions.getCallReplacement2SigsInfo();
        Map<String, SyntheticExpr> callRepl2ExprInfo = actions.getCallReplacement2ExprInfo();
        if (callRepl2SigInfo.isEmpty() && callRepl2ExprInfo.isEmpty()) {
            return result;
        }
        for (IClass klass : cha) {
            if (klass.isInterface()) continue;
            Language l = klass.getClassLoader().getLanguage();
            if (!cha.getScope().isApplicationLoader(klass.getClassLoader())) continue;
            for (IMethod m : klass.getDeclaredMethods()) {
                if (m.isAbstract()) continue;
                try {
                    for (CallSiteReference callSite : CodeScanner.getCallSites((IMethod)m)) {
                        MethodReference invokedRef = callSite.getDeclaredTarget();
                        String vdbTargetName = F4FActionProcessor.getVDBSig(invokedRef, l, cha);
                        if (vdbTargetName == null) {
                            taintLogger.debug((Object)("could not create VDB signature for invoked method " + invokedRef + " in " + m));
                            continue;
                        }
                        if (callRepl2SigInfo.containsKey(vdbTargetName)) {
                            CallSiteReplacement replacement = F4FActionProcessor.getCallSiteReplacementForSig(vdbTargetName, callSite, m, callRepl2SigInfo.get(vdbTargetName), cache);
                            if (replacement == null) continue;
                            MapUtil.findOrCreateSet((Map)result, (Object)F4FActionProcessor.getVDBSig(m.getReference(), l, cha)).add(replacement);
                            continue;
                        }
                        if (!callRepl2ExprInfo.containsKey(vdbTargetName)) continue;
                        int bcIndex = callSite.getProgramCounter();
                        CallSiteReplacement replacement = CallSiteReplacement.make((String)vdbTargetName, (int)bcIndex, (int)m.getLineNumber(bcIndex), (SyntheticExpr)callRepl2ExprInfo.get(vdbTargetName));
                        MapUtil.findOrCreateSet((Map)result, (Object)F4FActionProcessor.getVDBSig(m.getReference(), l, cha)).add(replacement);
                    }
                }
                catch (InvalidClassFileException e) {
                    taintLogger.info((Object)("error reading class " + klass), (Throwable)e);
                }
            }
        }
        return result;
    }

    private static CallSiteReplacement getCallSiteReplacementForSig(String vdbTargetName, CallSiteReference callSite, IMethod caller, Map<String, Map<Integer, Pattern>> newSig2Pattern, AnalysisCache cache) {
        String matchingSig = null;
        for (String newSig : newSig2Pattern.keySet()) {
            Map<Integer, Pattern> patternMap = newSig2Pattern.get(newSig);
            if (patternMap == null) {
                matchingSig = newSig;
                break;
            }
            boolean patternsMatch = true;
            MethodReference declaredTarget = callSite.getDeclaredTarget();
            Language lang = caller.getDeclaringClass().getClassLoader().getLanguage();
            IR ir = LangIndependentWalaUtil.getIR((IMethod)caller, (AnalysisCache)cache);
            DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)cache);
            for (Integer paramPos : patternMap.keySet()) {
                int desiredParamPos = callSite.isStatic() ? paramPos : paramPos - 1;
                TypeReference parameterType = declaredTarget.getParameterType(desiredParamPos);
                if (parameterType.isPrimitiveType()) {
                    throw new IllegalStateException("param position " + paramPos + " for " + declaredTarget + " is not of string type, but instead " + parameterType);
                }
                IClass paramKlass = caller.getClassHierarchy().lookupClass(parameterType);
                if (paramKlass == null || !lang.isStringType(paramKlass.getReference())) {
                    throw new IllegalStateException("param position " + paramPos + " for " + declaredTarget + " is not of string type, but instead " + parameterType);
                }
                SSAAbstractInvokeInstruction callInstr = ir.getCalls(callSite)[0];
                int vn = callInstr.getUse(paramPos.intValue());
                StringConstantFlow constantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
                Collection stringsFlowingToVar = constantFlow.findIntraprocStringsFlowingToVar(vn);
                if (stringsFlowingToVar.size() == 1) {
                    String s = (String)stringsFlowingToVar.iterator().next();
                    Pattern p = patternMap.get(paramPos);
                    Matcher matcher = p.matcher(s);
                    if (matcher.find()) continue;
                    patternsMatch = false;
                    break;
                }
                patternsMatch = false;
                break;
            }
            if (!patternsMatch) continue;
            matchingSig = newSig;
            break;
        }
        if (matchingSig != null) {
            int bytecodeIndex = callSite.getProgramCounter();
            int numParams = callSite.getDeclaredTarget().getNumberOfParameters();
            if (!callSite.isStatic()) {
                ++numParams;
            }
            InvokeExpr replacementCall = InvokeExpr.createInvokeExprWithOrigArgs(null, (String)matchingSig, (int)numParams);
            return CallSiteReplacement.make((String)vdbTargetName, (int)bytecodeIndex, (int)caller.getLineNumber(bytecodeIndex), (SyntheticExpr)replacementCall);
        }
        return null;
    }

    public static String getVDBSig(MethodReference ref, Language language, IClassHierarchy cha) {
        String walaSig = ref.getSignature();
        if (language.equals(Language.JAVA)) {
            return VDBJavaUtil.jvmToVDBSignature((String)walaSig);
        }
        if (language.equals(CLRLanguage.lang)) {
            if (F4FActionProcessor.containGenericType(ref)) {
                return F4FActionProcessor.convertWalaDotNetGenericSig2VDB(ref, cha);
            }
            return DotNetVDBUtil.walaDotNet2FullyQualifiedVDBSignature((String)walaSig);
        }
        throw new IllegalArgumentException("unknown language " + language);
    }

    private static boolean containGenericType(MethodReference ref) {
        if (F4FActionProcessor.instantiatedGenericType(ref.getDeclaringClass())) {
            return true;
        }
        String sig = ref.getSignature();
        if (sig == null) {
            return false;
        }
        return sig.contains("Lwith/");
    }

    private static String convertWalaDotNetGenericSig2VDB(MethodReference ref, IClassHierarchy cha) {
        IMethod m = cha.resolveMethod(ref);
        if (m == null) {
            return null;
        }
        IClass klass = m.getDeclaringClass();
        StringBuilder vdbSig = new StringBuilder();
        try {
            String methodName = F4FActionProcessor.possiblyGenericDotNetType2VDB(klass.getReference(), cha) + "." + m.getName().toString();
            methodName = DotNetVDBUtil.walaToVDBMethodName((String)methodName);
            vdbSig.append(methodName);
            vdbSig.append('(');
            for (int i = 0; i < ref.getNumberOfParameters(); ++i) {
                TypeReference parameterType = ref.getParameterType(i);
                vdbSig.append(F4FActionProcessor.possiblyGenericDotNetType2VDB(parameterType, cha));
                if (i >= ref.getNumberOfParameters() - 1) continue;
                vdbSig.append(";");
            }
            vdbSig.append("):");
            TypeReference returnType = ref.getReturnType();
            vdbSig.append(F4FActionProcessor.possiblyGenericDotNetType2VDB(returnType, cha));
            String vdbSigStr = vdbSig.toString();
            if (vdbSigStr.contains("<")) {
                vdbSigStr = vdbSigStr.replaceAll("<", "&lt;");
            }
            return vdbSigStr;
        }
        catch (UnresolvedGenericTypeException e) {
            return null;
        }
    }

    private static String possiblyGenericDotNetType2VDB(TypeReference ref, IClassHierarchy cha) throws UnresolvedGenericTypeException {
        if (F4FActionProcessor.instantiatedGenericType(ref)) {
            CLRClass clrKlass = (CLRClass)cha.lookupClass(ref = ref.getInnermostElementType());
            if (clrKlass == null) {
                taintLogger.debug((Object)("could not resolve generic type " + ref));
                throw new UnresolvedGenericTypeException();
            }
            assert (clrKlass.isWith());
            IClass baseKlass = clrKlass.withGetBase();
            if (baseKlass == null) {
                taintLogger.debug((Object)("could not resolve base class of generic type " + clrKlass));
                throw new UnresolvedGenericTypeException();
            }
            String walaDeclaringType = baseKlass.getName().toString();
            walaDeclaringType = walaDeclaringType.substring(0, walaDeclaringType.indexOf("`"));
            StringBuilder vdbType = new StringBuilder(DotNetVDBUtil.walaDotNet2FullyQualifiedVDBType((String)walaDeclaringType));
            vdbType.append("<");
            for (int i = 0; i < clrKlass.withGetNumParams(); ++i) {
                IClass typeParam = clrKlass.withGetParam(i);
                if (typeParam == null) {
                    taintLogger.debug((Object)("could not resolve type parameter " + i + " of generic type " + clrKlass + ", base type " + baseKlass));
                    throw new UnresolvedGenericTypeException();
                }
                vdbType.append(F4FActionProcessor.possiblyGenericDotNetType2VDB(typeParam.getReference(), cha));
                if (i >= clrKlass.withGetNumParams() - 1) continue;
                vdbType.append(",");
            }
            vdbType.append(">");
            return vdbType.toString();
        }
        return DotNetVDBUtil.walaDotNet2FullyQualifiedVDBType((String)ref.getName().toUnicodeString());
    }

    private static boolean instantiatedGenericType(TypeReference t) {
        Atom packageName = t.getName().getPackage();
        return packageName != null && packageName.toString().equals("with");
    }

    public static String getVDBSig(IMethod method) {
        return F4FActionProcessor.getVDBSig(method.getReference(), method.getDeclaringClass().getClassLoader().getLanguage(), method.getClassHierarchy());
    }

    public static String getVDBTypeName(String walaType, Language language) {
        if (language.equals(Language.JAVA)) {
            return VDBJavaUtil.jvmToVDBType((String)walaType);
        }
        if (language.equals(CLRLanguage.lang)) {
            return DotNetVDBUtil.walaDotNet2FullyQualifiedVDBType((String)walaType);
        }
        throw new IllegalArgumentException("unknown language " + language);
    }

    public static String getVDBTypeName(IClass klass) {
        return F4FActionProcessor.getVDBTypeName(klass.getName().toString(), klass.getClassLoader().getLanguage());
    }

    public static IFrameworkInfo mergeFrameworkInfo(IFrameworkInfo ... infos) {
        HashSet mergedMethods = HashSetFactory.make();
        HashSet syntheticMethodNames = HashSetFactory.make();
        HashSet mergedBeanDecls = HashSetFactory.make();
        HashSet globalBeanNames = HashSetFactory.make();
        HashMap mergedEntrypointMapping = HashMapFactory.make();
        HashMap mergedCallReplacements = HashMapFactory.make();
        for (IFrameworkInfo info : infos) {
            Object beanDecl2;
            for (ISyntheticMethod synthMethod : info.getSyntheticMethods()) {
                String synthMethodName = synthMethod.getSignature().substring(0, synthMethod.getSignature().indexOf(40));
                if (syntheticMethodNames.add(synthMethodName)) {
                    mergedMethods.add(synthMethod);
                    continue;
                }
                taintLogger.warn((Object)("duplicate synthetic method name " + synthMethodName));
            }
            for (Object beanDecl2 : info.getGlobalBeanDeclarations()) {
                String id = beanDecl2.getId();
                if (globalBeanNames.add(id)) {
                    mergedBeanDecls.add(beanDecl2);
                    continue;
                }
                taintLogger.warn((Object)("duplicate bean  name " + id));
            }
            Map entrypointSignatureToURLMappings = info.getEntrypointSignatureToURLMappings();
            beanDecl2 = entrypointSignatureToURLMappings.keySet().iterator();
            while (beanDecl2.hasNext()) {
                String entrypointSig = (String)beanDecl2.next();
                Set urls = MapUtil.findOrCreateSet((Map)mergedEntrypointMapping, (Object)entrypointSig);
                urls.addAll((Collection)entrypointSignatureToURLMappings.get(entrypointSig));
            }
            Map callReplacementsMap = info.getMethodToReplacementsMapping();
            for (String callerMethodSig : callReplacementsMap.keySet()) {
                Set replacements = MapUtil.findOrCreateSet((Map)mergedCallReplacements, (Object)callerMethodSig);
                for (CallSiteReplacement newReplacement : (Set)callReplacementsMap.get(callerMethodSig)) {
                    boolean duplicate = false;
                    int bytecodeIndex = newReplacement.getBytecodeIndex();
                    String sig = newReplacement.getVdbMethodSig();
                    int srcLine = newReplacement.getSrcLine();
                    for (CallSiteReplacement oldReplacement : replacements) {
                        if (!sig.equals(oldReplacement.getVdbMethodSig())) continue;
                        if (bytecodeIndex == -1) {
                            duplicate = oldReplacement.getBytecodeIndex() == -1 && srcLine == oldReplacement.getSrcLine();
                        } else {
                            boolean bl = duplicate = bytecodeIndex == oldReplacement.getBytecodeIndex();
                        }
                        if (!duplicate) continue;
                        taintLogger.warn((Object)("duplicate call replacements " + oldReplacement + " and " + newReplacement));
                        break;
                    }
                    if (duplicate) continue;
                    replacements.add(newReplacement);
                }
            }
        }
        return new FrameworkInfoImpl((Set)mergedMethods, (Set)mergedBeanDecls, (Map)mergedEntrypointMapping, (Map)mergedCallReplacements);
    }

    private static class UnresolvedGenericTypeException
    extends Exception {
        private UnresolvedGenericTypeException() {
        }
    }
}

