/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.cg;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.SetType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.andromeda.cg.util.SALogger;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.SetOfClasses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CgTargetsCache {
    private final IClassHierarchy cha;
    private final Logger logger = SALogger.logger;
    private static final Iterator<IMethod> emptyIterator = Collections.emptySet().iterator();

    public CgTargetsCache(IClassHierarchy cha) {
        this.cha = cha;
    }

    public Iterator<IMethod> getTargets(TypeAbstraction receiverType, CallSiteReference csr) {
        MethodReference declaredTarget = csr.getDeclaredTarget();
        Selector selector = declaredTarget.getSelector();
        if (csr.isFixed()) {
            IMethod resolvedTarget = this.cha.resolveMethod(declaredTarget);
            if (null == resolvedTarget) {
                return emptyIterator;
            }
            return Collections.singleton(resolvedTarget).iterator();
        }
        if (receiverType instanceof PointType || receiverType instanceof PrimitiveType) {
            IMethod resolvedTarget = this.getTargetForReceiverType(csr, selector, receiverType.getTypeReference());
            if (null == resolvedTarget) {
                return emptyIterator;
            }
            return Collections.singleton(resolvedTarget).iterator();
        }
        if (receiverType instanceof SetType) {
            ArrayList<IMethod> ret = new ArrayList<IMethod>();
            Iterator receiverTypeIter = ((SetType)receiverType).iteratePoints();
            while (receiverTypeIter.hasNext()) {
                IMethod resolvedTarget = this.getTargetForReceiverType(csr, selector, (TypeReference)receiverTypeIter.next());
                if (null == receiverType) continue;
                ret.add(resolvedTarget);
            }
            if (ret.isEmpty()) {
                return emptyIterator;
            }
            return ret.iterator();
        }
        IClass receiverClass = this.getMinimalReceiverClass(receiverType, declaredTarget.getDeclaringClass());
        if (null == receiverClass) {
            return emptyIterator;
        }
        return new CgTargetsIterator(receiverClass, selector);
    }

    private IClass getMinimalReceiverClass(TypeAbstraction receiverType, TypeReference declaringType) {
        IClass declaringClass = this.cha.lookupClass(declaringType);
        if (null == declaringClass) {
            this.warnAboutUnresolvedClass(declaringType);
            return null;
        }
        if (receiverType == null || receiverType == TypeAbstraction.TOP) {
            return declaringClass;
        }
        IClass receiverClass = this.cha.lookupClass(receiverType.getTypeReference());
        if (receiverClass == null) {
            this.warnAboutUnresolvedClass(receiverType.getTypeReference());
            return declaringClass;
        }
        if (declaringClass == receiverClass || this.cha.isAssignableFrom(declaringClass, receiverClass)) {
            return receiverClass;
        }
        return declaringClass;
    }

    private void warnAboutUnresolvedClass(TypeReference typeRef) {
        SetOfClasses exclusions = this.cha.getScope().getExclusions();
        if (exclusions != null && exclusions.contains(typeRef.getName().toString())) {
            this.logger.log(Priority.WARN, (Object)String.format("Class for type %s is excluded", typeRef.toString()));
        } else {
            this.logger.log(Priority.WARN, (Object)String.format("Cannot find class for type %s", typeRef.toString()));
        }
    }

    private final IMethod getTargetForReceiverType(CallSiteReference csr, Selector selector, TypeReference receiverTypeRef) {
        IClass receiverClass = this.cha.lookupClass(receiverTypeRef);
        if (null == receiverClass) {
            this.logger.log(Priority.WARN, (Object)String.format("Cannot find receiver class %s in CHA while solving call %s", receiverTypeRef.toString(), csr.toString()));
            return null;
        }
        IMethod targetMethod = receiverClass.getMethod(selector);
        if (targetMethod == null) {
            this.logger.log(Priority.WARN, (Object)String.format("Cannot find method for selector %s in class %s while solving call %s", selector.toString(), receiverTypeRef.toString(), csr.toString()));
            return null;
        }
        if (targetMethod.isAbstract() || targetMethod.isNative()) {
            this.logger.log(Priority.WARN, (Object)String.format("Abstract / native method for selector %s in class %s while solving call %s", selector.toString(), receiverTypeRef.toString(), csr.toString()));
            return null;
        }
        return targetMethod;
    }

    private class CgTargetsIterator
    implements Iterator<IMethod> {
        private final Selector selector;
        private final Set<TypeReference> visitedTypes = HashSetFactory.make();
        private final Set<IMethod> discoveredImplementations = HashSetFactory.make();
        private final Queue<Object> classesToProcess = new LinkedList<Object>();
        private IMethod next;
        private final IClass originalReceiverClass;

        public CgTargetsIterator(IClass receiverClass, Selector selector) {
            this.selector = selector;
            this.visitedTypes.add(receiverClass.getReference());
            this.classesToProcess.add(receiverClass);
            this.originalReceiverClass = receiverClass;
            this.computeNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public IMethod next() {
            IMethod ret = this.next;
            this.computeNext();
            return ret;
        }

        private void computeNext() {
            Object n;
            this.next = null;
            while ((n = this.classesToProcess.peek()) != null) {
                IMethod m;
                IClass nextClass;
                block6: {
                    if (n instanceof IClass) {
                        this.classesToProcess.poll();
                        nextClass = (IClass)n;
                    } else {
                        Iterator iter = (Iterator)n;
                        while (iter.hasNext()) {
                            nextClass = (IClass)iter.next();
                            if (this.visitedTypes.contains(nextClass.getReference())) continue;
                            this.visitedTypes.add(nextClass.getReference());
                            break block6;
                        }
                        this.classesToProcess.poll();
                        continue;
                    }
                }
                if (nextClass.isInterface()) {
                    this.classesToProcess.add(CgTargetsCache.this.cha.getImplementors(nextClass.getReference()).iterator());
                } else {
                    this.classesToProcess.add(CgTargetsCache.this.cha.getImmediateSubclasses(nextClass).iterator());
                }
                if ((m = nextClass.getMethod(this.selector)) == null || m.isAbstract() || m.isNative() || this.discoveredImplementations.contains(m)) continue;
                this.discoveredImplementations.add(m);
                this.next = m;
                break;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

