/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.cg.util.TaintConstants;
import com.ibm.wala.andromeda.core.IEntrypointsCollector;
import com.ibm.wala.andromeda.harness.TaintRunner;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CustomEntrypointsCollector
implements IEntrypointsCollector,
TaintConstants {
    private static final boolean DUMP_ENTRYPOINTS = true;
    private final Predicate<IClass> interestingClassesFilter;
    private final Predicate<IMethod> interestingMethodsFilter;

    public CustomEntrypointsCollector(Predicate<IClass> interestingClassesFilter, Predicate<IMethod> interestingMethodsFilter) {
        this.interestingClassesFilter = interestingClassesFilter;
        this.interestingMethodsFilter = interestingMethodsFilter;
    }

    public Set<IMethod> collectEntrypoints(IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        if (TaintRunner.USE_FRAMEWORKS) {
            try {
                BufferedReader fr = new BufferedReader(new FileReader(TaintRunner.FRAMEWORKS_ENTRYPOINTS_FILEPATH));
                String sig = fr.readLine();
                while (sig != null) {
                    IClass declaringClass = SignatureUtil.getDeclaringClass((String)sig, (IClassHierarchy)cha);
                    if (declaringClass == null) {
                        System.err.println("Could not find class for " + sig);
                    } else {
                        Selector sel = SignatureUtil.getSelector((String)sig);
                        Collection allMethods = declaringClass.getAllMethods();
                        boolean found = false;
                        for (IMethod m : allMethods) {
                            if (!m.getSelector().equals((Object)sel)) continue;
                            found = true;
                            result.add(m);
                            break;
                        }
                        if (!found) {
                            throw new RuntimeException("Found class but not method for " + sig);
                        }
                    }
                    sig = fr.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        if (!TaintRunner.USE_FRAMEWORKS || TaintRunner.USE_COMBINED_ENTRYPOINTS) {
            for (Object c : cha) {
                if (!this.interestingClassesFilter.test(c)) continue;
                for (IMethod m : c.getDeclaredMethods()) {
                    if (!this.interestingMethodsFilter.test((Object)m)) continue;
                    result.add(m);
                }
            }
        }
        try {
            FileWriter fw = new FileWriter("collected_entrypoints.txt", true);
            fw.write("Entrypoint IMethods\n");
            for (IMethod m : result) {
                fw.write(m.toString());
                fw.write("\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interestingClassesFilter == null ? 0 : this.interestingClassesFilter.hashCode());
        result = 31 * result + (this.interestingMethodsFilter == null ? 0 : this.interestingMethodsFilter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomEntrypointsCollector other = (CustomEntrypointsCollector)obj;
        if (this.interestingClassesFilter == null ? other.interestingClassesFilter != null : !this.interestingClassesFilter.equals(other.interestingClassesFilter)) {
            return false;
        }
        return !(this.interestingMethodsFilter == null ? other.interestingMethodsFilter != null : !this.interestingMethodsFilter.equals(other.interestingMethodsFilter));
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

