/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.frameworks;

import com.ibm.wala.andromeda.util.frameworks.FrameworkSignatureUtil;
import com.ibm.wala.andromeda.util.frameworks.MethodSignature;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;

public class FrameworkSupport {
    private static Map<Pair<MethodReference, CallSiteReference>, IMethod> actualToSynthetic = HashMapFactory.make();
    private static boolean initialized = false;

    public static IMethod getSyntheticTarget(MethodReference mr, CallSiteReference site) {
        if (!initialized) {
            System.err.println("FrameworkSupport: cannot invoke getSyntheticTarget without calling deserialize first");
            return null;
        }
        Pair key = Pair.make((Object)mr, (Object)site);
        return actualToSynthetic.get(key);
    }

    private static MethodReference findMethodReference(IClassHierarchy cha, String className, String methodName, String selector) {
        IClassLoader[] loaders = cha.getLoaders();
        for (int i = loaders.length - 2; i >= 0; --i) {
            ClassLoaderReference loaderRef = loaders[i].getReference();
            MethodReference mr = MethodReference.findOrCreate((ClassLoaderReference)loaderRef, (String)className, (String)methodName, (String)selector);
            IMethod m = cha.resolveMethod(mr);
            if (m == null) continue;
            return mr;
        }
        System.err.println("Couldn't find method reference for: " + className + " : " + methodName + " : " + selector);
        return null;
    }

    public static void deserialize(String filePath, IClassHierarchy cha) {
        try {
            String line;
            BufferedReader fr = new BufferedReader(new FileReader(filePath));
            while ((line = fr.readLine()) != null && !line.equals("")) {
                String callerSig = line;
                MethodSignature callerMethodSignature = FrameworkSignatureUtil.frameworksSigToMethodSignature((String)FrameworkSignatureUtil.dotsToSlashes((String)callerSig));
                MethodReference callerMR = FrameworkSupport.findMethodReference(cha, callerMethodSignature.getFullyQualifiedClassJVM(), callerMethodSignature.getMethodName(), callerSig.substring(callerSig.indexOf(40)));
                int pc = new Integer(fr.readLine());
                String targetSig = fr.readLine();
                MethodSignature targetMethodSignature = FrameworkSignatureUtil.frameworksSigToMethodSignature((String)FrameworkSignatureUtil.dotsToSlashes((String)targetSig));
                MethodReference targetMR = FrameworkSupport.findMethodReference(cha, targetMethodSignature.getFullyQualifiedClassJVM(), targetMethodSignature.getMethodName(), targetSig.substring(targetSig.indexOf(40)));
                IMethod targetIMethod = cha.resolveMethod(targetMR);
                CallSiteReference csr = targetIMethod.isStatic() ? CallSiteReference.make((int)pc, (MethodReference)targetMR, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC) : (targetIMethod.isAbstract() ? CallSiteReference.make((int)pc, (MethodReference)targetMR, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.INTERFACE) : CallSiteReference.make((int)pc, (MethodReference)targetMR, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.VIRTUAL));
                Pair key = Pair.make((Object)callerMR, (Object)csr);
                assert (actualToSynthetic.get(key) == null);
                String syntheticSig = fr.readLine();
                MethodSignature syntheticMethodSignature = MethodSignature.deserializeFromString((String)syntheticSig);
                MethodReference mr = syntheticMethodSignature.getMethodReference(ClassLoaderReference.Application);
                IMethod m = cha.resolveMethod(mr);
                actualToSynthetic.put((Pair<MethodReference, CallSiteReference>)key, m);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        initialized = true;
    }
}

