/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.incremental;

import com.ibm.wala.andromeda.cg.AccuracyLevel;
import com.ibm.wala.andromeda.cg.IEntrypointLocator;
import com.ibm.wala.andromeda.cg.TICallGraph;
import com.ibm.wala.andromeda.core.BasicPropagationWitness;
import com.ibm.wala.andromeda.core.IEntrypointsCollector;
import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.RawAnalysisResult;
import com.ibm.wala.andromeda.core.TaintAnalysis;
import com.ibm.wala.andromeda.core.TaintAnalyzer;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.core.ViolationVariable;
import com.ibm.wala.andromeda.harness.JspServices;
import com.ibm.wala.andromeda.harness.TaintRule;
import com.ibm.wala.andromeda.incremental.ChangeSet;
import com.ibm.wala.andromeda.incremental.IIncrementalAnalysis;
import com.ibm.wala.andromeda.incremental.IncrementalSCG;
import com.ibm.wala.andromeda.incremental.SinkOnlyTaintResult;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.models.OfflineSpecification;
import com.ibm.wala.andromeda.rules.ITaintResult;
import com.ibm.wala.andromeda.util.TaintRunnerStats;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.CollectionFilter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IncrementalTaintAnalysis
extends TaintAnalysis
implements IIncrementalAnalysis {
    private final IncrementalSCG callGraph;
    private final Map<TaintRule, TaintAnalyzer> rule2analyzer = HashMapFactory.make();
    private final OfflineSpecification spec;

    public IncrementalTaintAnalysis(IClassHierarchy cha, Set<TaintRule> analysisRules, IEntrypointsCollector entrypointsCollector, ILanguageSpecificServicesForFastanalysis langServices) throws ClassHierarchyException, InvalidClassFileException, IllegalArgumentException, CallGraphBuilderCancelException {
        this(cha, analysisRules, entrypointsCollector, langServices, Collections.emptySet());
    }

    public IncrementalTaintAnalysis(IClassHierarchy cha, Set<TaintRule> analysisRules, IEntrypointsCollector entrypointsCollector, ILanguageSpecificServicesForFastanalysis langServices, Collection<IMethod> terminatingMethods) throws ClassHierarchyException, InvalidClassFileException, IllegalArgumentException, CallGraphBuilderCancelException {
        super(cha, analysisRules, entrypointsCollector, langServices);
        this.callGraph = this.buildCallGraph(terminatingMethods, cha);
        this.spec = IncrementalTaintAnalysis.loadOfflineSpecification(cha, langServices, langServices);
    }

    private IncrementalSCG buildCallGraph(Collection<IMethod> terminatingMethods, IClassHierarchy cha) {
        OfflineSpecification spec = OfflineSpecification.loadDefaultSpec(cha, this.langServices, this.langServices);
        spec.addTerminatingMethods(terminatingMethods);
        return this.buildCallGraph(spec, this.entrypointsCollector);
    }

    @Override
    public Pair<Set<ITaintResult>, TaintRunnerStats> run() throws InvalidClassFileException, ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException {
        return Pair.make(this.analyzeCG(this.callGraph, this.spec), null);
    }

    protected IncrementalSCG buildCallGraph(OfflineSpecification spec, final IEntrypointsCollector collector) {
        IEntrypointLocator locator = new IEntrypointLocator(){

            @Override
            public Set<IMethod> locateEntrypoints(IClassHierarchy cha) {
                return HashSetFactory.make(collector.collectEntrypoints(cha));
            }
        };
        return new IncrementalSCG(this.cha, locator, spec, this.langServices, this.analysisCache, AccuracyLevel.getDefaultLevel(), new TICallGraph.VirtualResolutionOptions(5, 1, true, true, false));
    }

    @Override
    protected Set<ITaintResult> analyzeCG(TICallGraph cg, OfflineSpecification spec) throws ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException, InvalidClassFileException {
        HashSet result = HashSetFactory.make();
        for (TaintRule r : this.analysisRules) {
            TaintAnalyzer analyzer = this.createAnalyzerForRule(cg, r, spec);
            this.rule2analyzer.put(r, analyzer);
            RawAnalysisResult rawResult = analyzer.run();
            result.addAll(this.processRawResults(rawResult));
        }
        return result;
    }

    private TaintAnalyzer createAnalyzerForRule(TICallGraph cg, TaintRule r, OfflineSpecification spec) throws ClassHierarchyException, InvalidClassFileException, CallGraphBuilderCancelException {
        TaintAnalyzer analyzer = new TaintAnalyzer(this.cha, r.getSourceRefs(), r.getSanitizerRefs(), r.getSinkRefs(), this.langServices, spec, cg);
        return analyzer;
    }

    private Set<ITaintResult> processRawResults(RawAnalysisResult analysisResult) {
        AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propagationGraph = analysisResult.getPropagationGraph();
        HashSet result = HashSetFactory.make();
        Map<TaintRule, Set<ViolationVariable>> rule2sinks = this.classifySinksIntoRules(analysisResult);
        for (TaintRule r : rule2sinks.keySet()) {
            for (ViolationVariable sink : rule2sinks.get(r)) {
                Iterator it = propagationGraph.getPredNodes((Object)sink);
                while (it.hasNext()) {
                    Variable pred = (Variable)it.next();
                    Set witnesses = propagationGraph.getEdgeLabels((Object)pred, (Object)sink);
                    for (IPropagationWitness witness : witnesses) {
                        if (!(witness instanceof BasicPropagationWitness)) continue;
                        result.add(new SinkOnlyTaintResult(analysisResult, (Predicate<Variable>)new CollectionFilter(analysisResult.getPropagationSeeds()), sink, witness, r, JspServices.findOrCreate(this.cha.getScope())));
                    }
                }
            }
        }
        return result;
    }

    private Map<TaintRule, Set<ViolationVariable>> classifySinksIntoRules(RawAnalysisResult analysisResult) {
        HashMap result = HashMapFactory.make();
        AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propagationGraph = analysisResult.getPropagationGraph();
        for (Variable v : propagationGraph) {
            if (!(v instanceof ViolationVariable)) continue;
            for (TaintRule analysisRule : this.analysisRules) {
                if (!analysisRule.acceptsSink(v.getMethodRef())) continue;
                Set S = MapUtil.findOrCreateSet((Map)result, (Object)analysisRule);
                S.add((ViolationVariable)v);
            }
        }
        return result;
    }

    @Override
    public Pair<Set<ITaintResult>, TaintRunnerStats> analyze() {
        try {
            Pair<Set<ITaintResult>, TaintRunnerStats> run = this.run();
            return run;
        }
        catch (ClassHierarchyException run) {
        }
        catch (IllegalArgumentException run) {
        }
        catch (CallGraphBuilderCancelException run) {
        }
        catch (InvalidClassFileException run) {
            // empty catch block
        }
        Set emptySet = Collections.emptySet();
        return Pair.make(emptySet, null);
    }

    @Override
    public Set<ITaintResult> analyze(ChangeSet C) throws InvalidClassFileException {
        HashSet result = HashSetFactory.make();
        this.callGraph.adapt(C);
        for (TaintRule r : this.analysisRules) {
            RawAnalysisResult rawResult = this.rule2analyzer.get(r).analyze(C);
            result.addAll(this.processRawResults(rawResult));
        }
        return result;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

