/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.lang;

import com.ibm.appscan.sa.prefix.main.ISPALangServices;
import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.appscan.sa.prefix.main.StringPrefixAnalysis;
import com.ibm.wala.andromeda.cg.TICallGraph;
import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.AliasPropagationWitness;
import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.InvocationKey;
import com.ibm.wala.andromeda.core.RawAnalysisResult;
import com.ibm.wala.andromeda.core.TaintAnalyzer;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.lang.IAction;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.JavaServices;
import com.ibm.wala.andromeda.lang.ObjectProperties;
import com.ibm.wala.andromeda.lang.OverwriteInfo;
import com.ibm.wala.andromeda.lang.SPAServices;
import com.ibm.wala.andromeda.models.IOfflineSpecification;
import com.ibm.wala.andromeda.rules.management.Field;
import com.ibm.wala.andromeda.rules.management.FullPathFieldsInformation;
import com.ibm.wala.andromeda.rules.management.MemberReferenceInfo;
import com.ibm.wala.andromeda.rules.management.Method;
import com.ibm.wala.andromeda.util.TaintFilter;
import com.ibm.wala.andromeda.util.Triple;
import com.ibm.wala.andromeda.util.logging.DebugOutput;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ReflectiveMemberAccess;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractUnaryInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BytecodeServicesForFastanalysis
extends JavaServices
implements ILanguageSpecificServicesForFastanalysis {
    protected boolean DEBUG = false;
    private boolean DEBUG_BACKWARDS_IR_CONSTRUCTION = false;
    private Map<Pair<Variable, ? extends SSAInstruction>, Set<Triple<IMethod, Context, SSAAbstractInvokeInstruction>>> backwardsPropCallingContext = HashMapFactory.make();
    private Set<Pair<Variable, ? extends SSAInstruction>> backwardsInstrs = HashSetFactory.make();
    private Set<Variable> explored = HashSetFactory.make();
    private static final int INVOKE_OFFSET_USE = 1;

    @Override
    public int getInvokeUseOffset() {
        return 1;
    }

    @Override
    public void enableDebugging(boolean enable_debugging) {
        this.DEBUG = enable_debugging;
    }

    @Override
    public boolean areFieldReferencesCompatible(FieldReference fr1, FieldReference fr2, IClassHierarchy cha) {
        return Variable.areFieldReferencesCompatible(fr1, fr2, cha);
    }

    @Override
    public boolean areMethodsCompatible(IClassHierarchy cha, IMethod method1, IMethod method2) {
        if (method1.getSelector().equals((Object)method2.getSelector())) {
            IClass c2;
            IClass c1 = method1.getDeclaringClass();
            if (cha.isAssignableFrom(c1, c2 = method2.getDeclaringClass())) {
                return true;
            }
            if (cha.isAssignableFrom(c2, c1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Variable> findAncestors(TICallGraph cg, Variable variable) {
        HashSet result = HashSetFactory.make();
        if (this.isParameter(variable)) {
            result.add(variable);
        } else {
            HashSet worklist = HashSetFactory.make();
            HashSet handled = HashSetFactory.make();
            HashSet visitedMethods = HashSetFactory.make();
            worklist.add(variable);
            IMethod varMethod = variable.getMethod();
            visitedMethods.add(varMethod);
            while (!worklist.isEmpty()) {
                Iterator iter = worklist.iterator();
                worklist = HashSetFactory.make();
                while (iter.hasNext()) {
                    Variable newVar;
                    Variable current = (Variable)iter.next();
                    handled.add(current);
                    IMethod curMethod = current.getMethod();
                    Context curContext = current.getContext();
                    DefUse du = TaintAnalysisCache.soleInstance().getDefUse(curMethod, curContext);
                    if (du == null) continue;
                    SymbolTable sb = TaintAnalysisCache.soleInstance().getIR(curMethod, curContext).getSymbolTable();
                    SSAInstruction defInstr = du.getDef(current.getVarID());
                    if (defInstr == null) {
                        if (!this.isParameter(current)) continue;
                        if (curMethod.equals(varMethod)) {
                            result.add(current);
                            continue;
                        }
                        Set<Triple<IMethod, Context, SSAAbstractInvokeInstruction>> calls = this.getCalls(cg, curMethod);
                        for (Triple<IMethod, Context, SSAAbstractInvokeInstruction> call : calls) {
                            if (!visitedMethods.contains(call.first) || (newVar = Variable.failOrCreate((IMethod)call.first, ((SSAAbstractInvokeInstruction)call.third).getUse(current.getVarID() - 1), current.getAccessPath(), this)) == null || handled.contains(newVar)) continue;
                            worklist.add(newVar);
                        }
                        continue;
                    }
                    if (defInstr instanceof SSACheckCastInstruction) {
                        Variable newVar2 = Variable.failOrCreate(curMethod, defInstr.getUse(0), current.getAccessPath(), this);
                        if (newVar2 == null || handled.contains(newVar2)) continue;
                        worklist.add(newVar2);
                        continue;
                    }
                    if (defInstr instanceof SSAArrayLengthInstruction) {
                        result.add(current);
                        continue;
                    }
                    if (defInstr instanceof SSAPhiInstruction) {
                        for (int index = 0; index < defInstr.getNumberOfUses(); ++index) {
                            Variable newVar3 = Variable.failOrCreate(curMethod, defInstr.getUse(index), current.getAccessPath(), this);
                            if (newVar3 == null || handled.contains(newVar3)) continue;
                            worklist.add(newVar3);
                        }
                        continue;
                    }
                    if (defInstr instanceof SSAGetInstruction) {
                        Variable newVar4;
                        SSAGetInstruction getInstr = (SSAGetInstruction)defInstr;
                        if (getInstr.isStatic()) {
                            result.add(current);
                            continue;
                        }
                        FieldReference fr = getInstr.getDeclaredField();
                        List<FieldReference> currentAccessPath = current.getAccessPath();
                        ArrayList<FieldReference> newAccessPath = new ArrayList<FieldReference>(currentAccessPath == null ? 1 : currentAccessPath.size() + 1);
                        newAccessPath.add(fr);
                        if (currentAccessPath != null) {
                            newAccessPath.addAll(currentAccessPath);
                        }
                        if ((newVar4 = Variable.failOrCreate(curMethod, defInstr.getUse(0), newAccessPath, this)) == null || handled.contains(newVar4)) continue;
                        worklist.add(newVar4);
                        continue;
                    }
                    if (defInstr instanceof SSAAbstractUnaryInstruction) {
                        Variable newVar5 = Variable.failOrCreate(curMethod, defInstr.getUse(0), current.getAccessPath(), this);
                        if (newVar5 == null || handled.contains(newVar5)) continue;
                        worklist.add(newVar5);
                        continue;
                    }
                    if (defInstr instanceof SSAArrayLoadInstruction) {
                        FieldReference arrayAccessQualifier;
                        if (sb.isConstant(defInstr.getUse(1))) {
                            int constantIndex = sb.getIntValue(defInstr.getUse(1));
                            arrayAccessQualifier = Variable.getArrayAccessQualifier(constantIndex);
                        } else {
                            arrayAccessQualifier = Variable.ANONYMOUS;
                        }
                        List<FieldReference> currentAccessPath = current.getAccessPath();
                        ArrayList<FieldReference> newAccessPath = new ArrayList<FieldReference>(currentAccessPath == null ? 1 : currentAccessPath.size() + 1);
                        newAccessPath.add(arrayAccessQualifier);
                        if (currentAccessPath != null) {
                            newAccessPath.addAll(currentAccessPath);
                        }
                        if ((newVar = Variable.failOrCreate(curMethod, defInstr.getUse(0), newAccessPath, this)) == null || handled.contains(newVar)) continue;
                        worklist.add(newVar);
                        continue;
                    }
                    if (defInstr instanceof SSABinaryOpInstruction) {
                        Variable newVar2;
                        Variable newVar1 = Variable.failOrCreate(curMethod, defInstr.getUse(0), current.getAccessPath(), this);
                        if (newVar1 != null && !handled.contains(newVar1)) {
                            worklist.add(newVar1);
                        }
                        if ((newVar2 = Variable.failOrCreate(curMethod, defInstr.getUse(1), current.getAccessPath(), this)) == null || handled.contains(newVar2)) continue;
                        worklist.add(newVar2);
                        continue;
                    }
                    if (defInstr instanceof SSAConversionInstruction) {
                        Variable newVar6 = Variable.failOrCreate(curMethod, defInstr.getUse(0), current.getAccessPath(), this);
                        if (newVar6 == null || handled.contains(newVar6)) continue;
                        worklist.add(newVar6);
                        continue;
                    }
                    if (defInstr instanceof SSAGetCaughtExceptionInstruction) {
                        result.add(current);
                        continue;
                    }
                    if (defInstr instanceof SSALoadMetadataInstruction) {
                        result.add(current);
                        continue;
                    }
                    if (defInstr instanceof SSANewInstruction) {
                        result.add(current);
                        continue;
                    }
                    if (defInstr instanceof SSAAbstractInvokeInstruction) {
                        SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)defInstr;
                        MethodReference declaredTarget = invoke.getDeclaredTarget();
                        if (declaredTarget.equals((Object)TaintAnalyzer.CTOR_NEW_INSTANCE)) {
                            result.add(current);
                            continue;
                        }
                        Set<Variable> targetReturnVars = this.computeTargetReturnVars(cg, curMethod, invoke.getCallSite(), current.getAccessPath());
                        for (Variable returnVar : targetReturnVars) {
                            if (returnVar == null || handled.contains(returnVar)) continue;
                            visitedMethods.add(returnVar.getMethod());
                            worklist.add(returnVar);
                        }
                        continue;
                    }
                    Assertions.UNREACHABLE((String)("ERROR: did not expect def instruction to be " + defInstr));
                }
            }
        }
        return result;
    }

    private Set<Variable> computeTargetReturnVars(CallGraph cg, IMethod caller, CallSiteReference site, List<FieldReference> accessPath) {
        HashSet result = HashSetFactory.make();
        Collection<Pair<IMethod, Context>> targets = this.getTargetsFromCallGraph(cg, caller, (Context)Everywhere.EVERYWHERE, site);
        for (Pair<IMethod, Context> target : targets) {
            SSAInstruction[] targetInstructions;
            IR targetIR;
            IMethod targetIMethod = (IMethod)target.fst;
            if (targetIMethod == null || (targetIR = TaintAnalysisCache.soleInstance().getIR(targetIMethod, (Context)target.snd)) == null) continue;
            for (SSAInstruction targetInstr : targetInstructions = targetIR.getInstructions()) {
                if (!(targetInstr instanceof SSAReturnInstruction)) continue;
                Variable returnVar = Variable.failOrCreate(targetIMethod, targetInstr.getUse(0), accessPath, this);
                result.add(returnVar);
            }
        }
        return result;
    }

    @Override
    public Collection<Pair<IMethod, Context>> getTargetsFromCallGraph(CallGraph cg, IMethod caller, Context context, CallSiteReference site) {
        HashSet result = HashSetFactory.make();
        CGNode n = cg.getNode(caller, (Context)Everywhere.EVERYWHERE);
        if (n != null) {
            Set possibleTargets = cg.getPossibleTargets(n, site);
            for (CGNode possibleTarget : possibleTargets) {
                result.add(Pair.make((Object)possibleTarget.getMethod(), (Object)possibleTarget.getContext()));
            }
        }
        return result;
    }

    public Set<Triple<IMethod, Context, SSAAbstractInvokeInstruction>> getCalls(TICallGraph cg, CGNode n) {
        HashSet ret = HashSetFactory.make();
        Iterator<CGNode> nodes = cg.getPredNodes(n);
        while (nodes.hasNext()) {
            CGNode node = nodes.next();
            IR callerIR = TaintAnalysisCache.soleInstance().getIR(node);
            for (SSAInstruction instruction : callerIR.getInstructions()) {
                SSAAbstractInvokeInstruction invokeInstr;
                Set<CGNode> callees;
                if (!(instruction instanceof SSAAbstractInvokeInstruction) || !(callees = cg.getPossibleTargets(node, (invokeInstr = (SSAAbstractInvokeInstruction)instruction).getCallSite())).contains(n)) continue;
                ret.add(Triple.make((Object)node.getMethod(), (Object)node.getContext(), (Object)invokeInstr));
            }
        }
        return ret;
    }

    public Set<Triple<IMethod, Context, SSAAbstractInvokeInstruction>> getCalls(TICallGraph cg, IMethod m, Context c) {
        return this.getCalls(cg, m);
    }

    protected Set<Triple<IMethod, Context, SSAAbstractInvokeInstruction>> getCalls(TICallGraph cg, IMethod m) {
        HashSet result = HashSetFactory.make();
        Set<CallSite> callSites = cg.scanForCalls((Collection<IMethod>)Collections.singleton(m));
        for (CallSite site : callSites) {
            SSAAbstractInvokeInstruction[] invocations;
            CGNode caller = site.getNode();
            IMethod callingMethod = caller.getMethod();
            IR callerIR = TaintAnalysisCache.soleInstance().getIR(caller);
            if (callerIR == null) continue;
            try {
                invocations = callerIR.getCalls(site.getSite());
            }
            catch (IllegalArgumentException e) {
                invocations = null;
            }
            if (invocations == null) continue;
            for (SSAAbstractInvokeInstruction invoke : invocations) {
                result.add(Triple.make((Object)callingMethod, (Object)caller.getContext(), (Object)invoke));
            }
        }
        return result;
    }

    public Set<CGNode> getCGNodes(CallGraph cg, IMethod m) {
        Set nodes = cg.getNodes(m.getReference());
        assert (nodes.size() <= 1) : "ERROR: assuming a context-insensitive callgraph, but found " + nodes.size() + " nodes for method " + m.getSignature() + "!";
        Iterator nodesIter = nodes.iterator();
        HashSet ret = HashSetFactory.make();
        if (nodesIter.hasNext()) {
            ret.add(nodesIter.next());
        }
        return ret;
    }

    @Override
    public CGNode getCGNode(CallGraph cg, IMethod m, Context c) {
        return cg.getNode(m, c);
    }

    @Override
    public boolean isSanitizer(CallGraph cg, IMethod m, Collection<CGNode> sanitizerNodes, MethodReference mr, TaintFilter sanitizersFilter) {
        return sanitizersFilter.accepts(mr);
    }

    @Override
    public boolean isSource(CallGraph cg, IMethod m, SSAAbstractInvokeInstruction invoke, MethodReference declaredTarget, TaintFilter sourcesFilter, Map<InvocationKey, Set<MemberReferenceInfo>> srcMethodRefs) {
        return sourcesFilter.accepts(declaredTarget);
    }

    @Override
    public boolean isSink(MethodReference mr, TaintFilter sinksFilter, InvocationKey ik, Map<InvocationKey, Set<MemberReferenceInfo>> sinkMethodRefs) {
        return sinksFilter.accepts(mr);
    }

    @Override
    public Collection<IMethod> getSinks(CallSiteReference callSiteRef, TaintFilter sinksFilter, IClassHierarchy cha, TICallGraph cg, CGNode caller, Map<InvocationKey, Set<MemberReferenceInfo>> sinkMethodRefs) {
        MethodReference targetMR = callSiteRef.getDeclaredTarget();
        if (this.DEBUG) assert (this.isSink(targetMR, sinksFilter, null, null));
        HashSet ret = HashSetFactory.make();
        if (this.isSink(targetMR, sinksFilter, null, null)) {
            ret.add(cha.resolveMethod(targetMR));
            return ret;
        }
        Assertions.UNREACHABLE((String)"We should always find the sink for bytecode languages");
        return ret;
    }

    @Override
    public Collection<MemberReferenceInfo> getMemberReferenceInfos(Map<InvocationKey, Set<MemberReferenceInfo>> methodRefsMap, InvocationKey ik) {
        return Collections.emptySet();
    }

    @Override
    public Collection<CGNode> getCGNodes(CallGraph cg, Collection<Method> methods) {
        HashSet ret = HashSetFactory.make();
        for (Method m : methods) {
            String accessPath = m.getSignature();
            Collection<CGNode> nodes = this.getCGNodes(cg, accessPath);
            ret.addAll(nodes);
        }
        return ret;
    }

    @Override
    public Collection<CGNode> getCGNodes(CallGraph cg, String accessPath) {
        return Collections.emptySet();
    }

    @Override
    public Pair<FullPathFieldsInformation, FullPathFieldsInformation> getFieldRefsFromSigs(Collection<Field> fields, TICallGraph cg) {
        return Pair.make((Object)new FullPathFieldsInformation(), (Object)new FullPathFieldsInformation());
    }

    @Override
    public Map<InvocationKey, Set<MemberReferenceInfo>> getMethodRefsFromMethods(Collection<Method> methods, TICallGraph cg) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public void findInvokesFromSig(String methodSig, TICallGraph cg, ILanguageSpecificServicesForFastanalysis.IFindMethodRefsHandler handler) {
        Assertions.UNREACHABLE((String)"this should only be used for JavaScript for now");
    }

    @Override
    public Map<FieldReference, Set<IMethod>> accountForStaticGetFields(CGNode n) {
        HashMap ret = HashMapFactory.make();
        Collection<FieldReference> fieldReferences = this.getFieldsRead(n);
        IClassHierarchy cha = n.getClassHierarchy();
        if (fieldReferences != null) {
            IMethod m = n.getMethod();
            for (FieldReference fr : fieldReferences) {
                IField f = cha.resolveField(fr);
                if (f == null || !f.isStatic()) continue;
                Set range = MapUtil.findOrCreateSet((Map)ret, (Object)fr);
                range.add(m);
            }
        }
        return ret;
    }

    @Override
    public ObjectProperties getProperties(ReflectiveMemberAccess rma, TICallGraph cg, IMethod m, Context c) {
        return new ObjectProperties(HashSetFactory.make(), false, false);
    }

    @Override
    public boolean isAWriteToAGlobal(CallGraph cg, CGNode n, SSAInstruction def) {
        DebugOutput.println((boolean)this.DEBUG, (String)"There should be no AST Global Writes in Bytecode analysis so this will always return false");
        return false;
    }

    public Set<Variable> getVariableAliasesForField(CallGraph cg, CGNode node, SSAFieldAccessInstruction fieldAccess, List<FieldReference> accessPath) {
        Assertions.UNREACHABLE((String)"Not implemented yet");
        return HashSetFactory.make();
    }

    public Set<Variable> getGlobalAliasesWithAccessPath(CallGraph cg, SSAInstruction instr, List<FieldReference> accessPath) {
        Assertions.UNREACHABLE((String)"Bytecode analysis shouldn't need to find global aliases since it doesn't have true globals");
        return HashSetFactory.make();
    }

    public Set<Variable> getStaticGetFieldVars(CallGraph cg, SSAInstruction fieldAccessInstr, List<FieldReference> accessPath, Map<FieldReference, Set<IMethod>> allStaticGetFields) {
        HashSet result = HashSetFactory.make();
        FieldReference declaredField = null;
        if (fieldAccessInstr instanceof SSAFieldAccessInstruction) {
            SSAFieldAccessInstruction fai = (SSAFieldAccessInstruction)fieldAccessInstr;
            declaredField = fai.getDeclaredField();
        } else {
            Assertions.UNREACHABLE((String)"Why wasn't the instruction a SSAFieldAccessInstruction?");
        }
        Set<IMethod> range = allStaticGetFields.get(declaredField);
        if (range != null) {
            for (IMethod m : range) {
                IR ir = TaintAnalysisCache.soleInstance().getIR(m);
                for (SSAInstruction instr : ir.getInstructions()) {
                    SSAGetInstruction get;
                    if (!(instr instanceof SSAGetInstruction) || !(get = (SSAGetInstruction)instr).getDeclaredField().equals((Object)declaredField)) continue;
                    result.add(Variable.failOrCreate(m, instr.getDef(), accessPath, this));
                }
            }
        }
        return result;
    }

    @Override
    public boolean isParameter(Variable var) {
        IMethod varMethod = var.getMethod();
        IR ir = TaintAnalysisCache.soleInstance().getIR(varMethod, var.getContext());
        if (ir == null) {
            assert (var.getVarID() <= varMethod.getNumberOfParameters());
            return true;
        }
        return ir.getSymbolTable().isParameter(var.getVarID());
    }

    @Override
    public boolean isParameter(int varID, int numParams) {
        return varID <= numParams;
    }

    @Override
    public Pair<Collection<Method>, Collection<OverwriteInfo>> detectMethodOverwrites(Collection<Method> methods, TICallGraph cg) {
        HashSet e1 = HashSetFactory.make();
        HashSet e2 = HashSetFactory.make();
        return Pair.make((Object)e1, (Object)e2);
    }

    @Override
    public boolean isInstructionInSystemFiles(SSAInstruction instr, IMethod m, Context c) {
        return false;
    }

    @Override
    public String getStringForPropertyDouble(Double d) {
        return d.toString();
    }

    @Override
    public <T> void handleObjectProperties(ObjectProperties possibleProperties, T data, IAction<T> a) {
    }

    @Override
    public boolean excludeSourcesAndSinksFromCG() {
        return true;
    }

    @Override
    public boolean allowGenerateCandidatesFile() {
        return true;
    }

    public void findFieldRefsFromPath(Set<InstanceKey> pointedInstances, String accessPath, TICallGraph cg, ILanguageSpecificServicesForFastanalysis.IFindFieldRefsHandler handler) {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean fieldOnlyPointsToOneIK(TICallGraph cg, LocalPointerKey lhsObject, String lhsField) {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public boolean isLexicalAccess(Variable v) {
        return this.isLexicalAccess(v.getVarID(), v.getMethod(), v.getContext());
    }

    @Override
    public boolean isLexicalAccess(int valueNumber, IMethod method, Context c) {
        return false;
    }

    private void assertDefIsNull(IMethod m, Context c, Variable v, SSAInstruction orgInstr) {
        DefUse du = TaintAnalysisCache.soleInstance().getDefUse(m, c);
        if (du != null) {
            SSAInstruction instr = du.getDef(v.getVarID());
            if (instr != null && !orgInstr.equals((Object)instr)) {
                DebugOutput.println((boolean)this.DEBUG, (String)("the def should be null :: " + orgInstr.toString() + " :: " + instr.toString() + " :: " + m.toString() + " :: " + c.toString() + " :: " + v.toString()));
            }
        } else {
            DebugOutput.println((boolean)this.DEBUG, (String)("the du should not be null :: " + orgInstr.toString() + " :: " + m.toString() + " :: " + c.toString() + " :: " + v.toString()));
        }
    }

    private void addDefToBackwardsWorkList(IMethod m, Context c, Variable v, List<Pair<Variable, ? extends SSAInstruction>> workList) {
        SSAInstruction instr;
        Pair pair;
        DefUse du = TaintAnalysisCache.soleInstance().getDefUse(m, c);
        if (du != null && this.backwardsInstrs.add((Pair<Variable, ? extends SSAInstruction>)(pair = Pair.make((Object)v, (Object)(instr = du.getDef(v.getVarID())))))) {
            workList.add((Pair<Variable, ? extends SSAInstruction>)pair);
        }
    }

    private Variable createVariableForAnalyzeBackwards(IMethod m, Context c, int varID, List<FieldReference> accessPath, Set<Variable> newVars) {
        Variable v = Variable.failOrCreate(m, c, varID, accessPath, this);
        newVars.add(v);
        return v;
    }

    @Override
    public void removeFromBackwardsAliasExplored(Set<Variable> vars) {
        this.explored.removeAll(vars);
    }

    @Override
    public void resetBackwardsAliasExplored() {
        this.explored = HashSetFactory.make();
    }

    @Override
    public void handleBackwardsPropagation(IClassHierarchy cha, DefUse du, Variable variable, TICallGraph cg, Map<FieldReference, Set<IMethod>> allStaticGetFields, TaintAnalyzer ta, TaintFilter sanitizersFilter, IOfflineSpecification spec, int bounds) {
        int varID = variable.getVarID();
        IMethod m = variable.getMethod();
        Context c = variable.getContext();
        SSAInstruction i = du.getDef(varID);
        if (i instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction defInstr = (SSAAbstractInvokeInstruction)i;
            Set<Variable> backwardsDiscoveredVars = this.getBackwardsRootAliases(variable, defInstr, cg, allStaticGetFields, ta);
            Set emptySet = Collections.emptySet();
            TaintFilter emptyFilter = TaintFilter.createFilter((IClassHierarchy)cha, emptySet);
            TaintAnalyzer taintAnalyzer = new TaintAnalyzer(cha, emptyFilter, sanitizersFilter, emptyFilter, this, cg, spec, backwardsDiscoveredVars, allStaticGetFields, bounds);
            RawAnalysisResult rawResult = taintAnalyzer.run();
            AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propGraph = rawResult.getPropagationGraph();
            HashSet variablesOfInterest = HashSetFactory.make();
            variablesOfInterest.add(defInstr.getDef());
            int numberOfUses = defInstr.getNumberOfUses();
            for (int useIndex = 0; useIndex < numberOfUses; ++useIndex) {
                variablesOfInterest.add(defInstr.getUse(useIndex));
            }
            for (Variable v : propGraph) {
                if (!v.getMethod().equals(variable.getMethod()) || !variablesOfInterest.contains(v.getVarID())) continue;
                ta.recordFlow(variable, v, new AliasPropagationWitness(m, c, (SSAInstruction)defInstr, rawResult));
            }
        }
    }

    private Set<Variable> getBackwardsRootAliases(Variable startVariable, SSAAbstractInvokeInstruction startInvoke, TICallGraph cg, Map<FieldReference, Set<IMethod>> allStaticGetFields, TaintAnalyzer ta) {
        HashSet visitedMethods = HashSetFactory.make();
        IMethod startMethod = startVariable.getMethod();
        Context startContext = startVariable.getContext();
        visitedMethods.add(startMethod);
        HashSet newVariables = HashSetFactory.make();
        LinkedList<Pair<Variable, ? extends SSAInstruction>> workList = new LinkedList<Pair<Variable, ? extends SSAInstruction>>();
        this.addDefToBackwardsWorkList(startMethod, startContext, startVariable, workList);
        while (!workList.isEmpty()) {
            Variable newVar;
            ArrayList<FieldReference> newAccessPath;
            SSAAbstractInvokeInstruction invokeInstr;
            Pair item = (Pair)workList.remove(0);
            Variable v = (Variable)item.fst;
            SSAInstruction i = (SSAInstruction)item.snd;
            IMethod m = v.getMethod();
            Context c = v.getContext();
            List<FieldReference> accessPath = v.getAccessPath();
            if (!this.explored.add(v) && this.DEBUG) {
                System.err.println("Exploring the same variable in the backward direction a second time: " + v.toString());
            }
            if (i == null && this.isParameter(v)) {
                Collection callers = this.getCalls(cg, m, c);
                for (Triple caller : callers) {
                    IMethod callerMethod = (IMethod)caller.first;
                    if (!visitedMethods.contains(callerMethod)) continue;
                    invokeInstr = (SSAAbstractInvokeInstruction)caller.third;
                    int actualUse = invokeInstr.getUse(v.getVarID() - this.getInvokeUseOffset());
                    Context callerContext = (Context)caller.second;
                    this.createVariableForAnalyzeBackwards(callerMethod, callerContext, actualUse, accessPath, newVariables);
                }
                continue;
            }
            if (i == null) continue;
            if (i instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)i;
                Triple callerOfMethodThatReturns = Triple.make((Object)m, (Object)c, (Object)invoke);
                CallSiteReference callSite = invoke.getCallSite();
                Collection<Pair<IMethod, Context>> possibleTargets = ta.getPossibleTargets(m, c, callSite, true);
                invokeInstr = possibleTargets.iterator();
                while (invokeInstr.hasNext()) {
                    SSAInstruction[] irInstrs;
                    Pair<IMethod, Context> p = invokeInstr.next();
                    IMethod possibleTargetMethod = (IMethod)p.fst;
                    visitedMethods.add(possibleTargetMethod);
                    Context possibleTargetContext = (Context)p.snd;
                    IR ir = TaintAnalysisCache.soleInstance().getIR(possibleTargetMethod, possibleTargetContext);
                    if (ir == null && !possibleTargetMethod.isAbstract() && !possibleTargetMethod.isNative()) {
                        if (this.DEBUG_BACKWARDS_IR_CONSTRUCTION) {
                            System.err.println("USE A CACHE AND SUMMARIZE THIS METHOD IN THE FUTURE");
                        }
                        ir = TaintAnalysisCache.soleInstance().getBackwardsIR(possibleTargetMethod, possibleTargetContext);
                    } else if (this.DEBUG_BACKWARDS_IR_CONSTRUCTION) {
                        System.err.println("found a native or abstract method while doing backwards prop: " + possibleTargetMethod.toString());
                    }
                    if (ir == null) continue;
                    for (SSAInstruction irInstr : irInstrs = ir.getInstructions()) {
                        if (!(irInstr instanceof SSAReturnInstruction)) continue;
                        SSAReturnInstruction retInstr = (SSAReturnInstruction)irInstr;
                        int retVarNum = retInstr.getResult();
                        Variable effect = this.createVariableForAnalyzeBackwards(possibleTargetMethod, possibleTargetContext, retVarNum, accessPath, newVariables);
                        Pair retPairKey = Pair.make((Object)effect, (Object)retInstr);
                        MapUtil.findOrCreateSet(this.backwardsPropCallingContext, (Object)retPairKey).add(callerOfMethodThatReturns);
                        if (!this.backwardsInstrs.add((Pair<Variable, ? extends SSAInstruction>)retPairKey)) continue;
                        workList.add((Pair<Variable, ? extends SSAInstruction>)retPairKey);
                    }
                }
                continue;
            }
            if (i instanceof SSAReturnInstruction) {
                this.addDefToBackwardsWorkList(m, c, v, workList);
                continue;
            }
            if (i instanceof SSACheckCastInstruction) {
                Variable newVar2 = this.createVariableForAnalyzeBackwards(m, c, i.getUse(0), accessPath, newVariables);
                this.addDefToBackwardsWorkList(m, c, newVar2, workList);
                continue;
            }
            if (i instanceof SSAArrayLengthInstruction) continue;
            if (i instanceof SSAPhiInstruction) {
                for (int index = 0; index < i.getNumberOfUses(); ++index) {
                    Variable newVar3 = this.createVariableForAnalyzeBackwards(m, c, i.getUse(index), accessPath, newVariables);
                    this.addDefToBackwardsWorkList(m, c, newVar3, workList);
                }
                continue;
            }
            if (i instanceof SSAGetInstruction) {
                SSAGetInstruction getInstr = (SSAGetInstruction)i;
                FieldReference fr = getInstr.getDeclaredField();
                if (getInstr.isStatic()) {
                    Collection getVars = this.getStaticGetFieldVars((CallGraph)null, (SSAInstruction)getInstr, (List)accessPath, (Map)allStaticGetFields);
                    for (Variable getVar : getVars) {
                        newVariables.add(getVar);
                        this.assertDefIsNull(m, c, getVar, i);
                    }
                    continue;
                }
                newAccessPath = new ArrayList<FieldReference>(accessPath == null ? 1 : accessPath.size() + 1);
                newAccessPath.add(fr);
                if (accessPath != null) {
                    newAccessPath.addAll(accessPath);
                }
                newVar = this.createVariableForAnalyzeBackwards(m, c, i.getUse(0), newAccessPath, newVariables);
                this.addDefToBackwardsWorkList(m, c, newVar, workList);
                continue;
            }
            if (i instanceof SSAAbstractUnaryInstruction) {
                Variable newVar4 = this.createVariableForAnalyzeBackwards(m, c, i.getUse(0), accessPath, newVariables);
                this.addDefToBackwardsWorkList(m, c, newVar4, workList);
                continue;
            }
            if (i instanceof SSAArrayLoadInstruction) {
                FieldReference arrayAccessQualifier;
                SymbolTable sb = TaintAnalysisCache.soleInstance().getIR(m).getSymbolTable();
                if (sb.isConstant(i.getUse(1))) {
                    int constantIndex = sb.getIntValue(i.getUse(1));
                    arrayAccessQualifier = Variable.getArrayAccessQualifier(constantIndex);
                } else {
                    arrayAccessQualifier = Variable.ANONYMOUS;
                }
                newAccessPath = new ArrayList(accessPath == null ? 1 : accessPath.size() + 1);
                newAccessPath.add(arrayAccessQualifier);
                if (accessPath != null) {
                    newAccessPath.addAll(accessPath);
                }
                newVar = this.createVariableForAnalyzeBackwards(m, c, i.getUse(0), newAccessPath, newVariables);
                this.addDefToBackwardsWorkList(m, c, newVar, workList);
                continue;
            }
            if (i instanceof SSABinaryOpInstruction) {
                Variable newVar1 = this.createVariableForAnalyzeBackwards(m, c, i.getUse(0), accessPath, newVariables);
                this.addDefToBackwardsWorkList(m, c, newVar1, workList);
                Variable newVar2 = this.createVariableForAnalyzeBackwards(m, c, i.getUse(1), accessPath, newVariables);
                this.addDefToBackwardsWorkList(m, c, newVar2, workList);
                continue;
            }
            if (i instanceof SSAConversionInstruction) {
                Variable newVar5 = this.createVariableForAnalyzeBackwards(m, c, i.getUse(0), accessPath, newVariables);
                this.addDefToBackwardsWorkList(m, c, newVar5, workList);
                continue;
            }
            if (i instanceof SSAGetCaughtExceptionInstruction || i instanceof SSALoadMetadataInstruction || i instanceof SSANewInstruction) continue;
            Assertions.UNREACHABLE((String)("ERROR: did not expect def instruction to be " + i));
        }
        return newVariables;
    }

    @Override
    public StringPrefixAnalysis runStringPrefixAnalysis(CallGraph jsticg, ISPALangServices langServices, String url) {
        Assertions.UNREACHABLE((String)"This should only be used in JavaScript for now");
        return null;
    }

    @Override
    public SPAServices.Result taintInURLParams(IntSet results, TabulationDomain<StringPrefix, BasicBlockInContext<IExplodedBasicBlock>> domain) {
        Assertions.UNREACHABLE((String)"This should only be used in JavaScript for now");
        return SPAServices.Result.NO;
    }

    @Override
    public Collection<Variable> handleASTLexicalWrite(CallGraph cg, AstLexicalWrite write, int varID, IMethod m, Context c, Variable v) {
        return Collections.emptyList();
    }
}

