/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.clazz.info.ClassFieldTrackerProvider;
import com.hcl.clazz.info.ClassInfo;
import com.hcl.clazz.info.ClassNameVisitor;
import com.hcl.clazz.info.MethodInfo;
import com.hcl.clazz.info.SlicerClassInfo;
import com.hcl.irx.slice.AppScan;
import com.hcl.irx.slice.Bucket;
import com.hcl.irx.slice.IrxMinorCacheManagement;
import com.hcl.irx.slice.Messages;
import com.hcl.irx.slice.wafl.JavaWaflGen;
import com.hcl.irx.slice.wafl.WaflReader;
import com.hcl.irx.slice.xml.TargetInfoSliceXml;
import com.hcl.irx.stage.Stager;
import com.hcl.irx.stage.java.JavaStager;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.NullProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.logging.stats.PrepareStatsWriter;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.internal.common.model.ThreadPoolExecutorWithLimit;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.xml.sax.SAXException;

public class Slicer {
    private static String SLICES = "slices";
    private static final String[] IGNORED_STATS = new String[]{"IRGenClient", "IRGenClientVersion", "IRGenClientPluginVersion", "SourceCodeOnly"};
    private File m_destination_dir;
    private Stager m_stager;
    private IScanTargetMinProxy m_proxy;
    private WaflReader m_wafl_reader;
    private JSONObject m_stats = new JSONObject();
    private IProgress m_progress;
    private JavaWaflGen m_wafl_gen;
    private int m_bucket_size = 2;
    private Set<String> m_completed_slices = Collections.newSetFromMap(new ConcurrentHashMap());
    private HashMap<String, File> m_friend_map;
    private ClassFieldTrackerProvider m_class_field_tracker = new ClassFieldTrackerProvider();
    private AtomicInteger m_bucket_cache_hits = new AtomicInteger();
    private AtomicInteger m_bucket_cache_miss = new AtomicInteger();
    private AtomicInteger m_bucket_count = new AtomicInteger();
    private List<List<File>> m_buckets;

    public Slicer(Stager stager, IScanTargetMinProxy proxy, IProgress progress) throws IOException {
        int class_file_count;
        this.m_stager = stager;
        this.m_proxy = proxy;
        this.m_progress = progress;
        if (this.m_progress == null) {
            this.m_progress = new NullProgress();
        }
        this.m_bucket_size = (class_file_count = this.m_stager.getUserCodeFiles().size()) < 1000 ? 1 : (class_file_count < 2000 ? 2 : (class_file_count < 5000 ? 3 : 5));
    }

    protected synchronized File getDestinationDir() {
        if (this.m_destination_dir == null) {
            this.m_destination_dir = Paths.get(this.m_stager.getOutputBasePath().getAbsolutePath(), SLICES, this.getLanguage().toString()).toFile();
            if (this.getProxy() != null) {
                this.m_destination_dir = Paths.get(this.m_proxy.getScanHome().getAbsolutePath(), SLICES, this.getLanguage().toString()).toFile();
            }
            this.m_destination_dir.mkdirs();
        }
        return this.m_destination_dir;
    }

    public String getSlicerDetails() throws IOException, JSONException, NoSuchAlgorithmException, AppScanException, VDBException {
        StringBuilder ret = new StringBuilder();
        ret.append(System.lineSeparator());
        ret.append(Messages.getMessage("slice.settings", this.getLanguage().toString()));
        ret.append(System.lineSeparator());
        ret.append(Messages.getMessage("slice.class.file.count", this.m_stager.getUserCodeFiles().size()));
        ret.append(System.lineSeparator());
        ret.append(Messages.getMessage("slice.buckets", this.getBuckets().size(), this.m_bucket_size));
        ret.append(System.lineSeparator());
        if (SystemUtil.useCacheForSlicer()) {
            ret.append(Messages.getMessage("slice.cache.status", this.m_bucket_cache_hits.get(), this.m_bucket_cache_miss.get(), this.m_bucket_cache_miss.get() == 0 ? 100.0 : (this.m_bucket_cache_hits.get() == 0 ? 0.0 : (double)this.m_bucket_cache_miss.get() / (double)this.m_bucket_cache_hits.get() * 100.0)));
            ret.append(System.lineSeparator());
            ret.append(IrxMinorCacheManagement.getCurrentUsage());
            ret.append(System.lineSeparator());
        } else {
            ret.append(System.lineSeparator());
            ret.append(Messages.getMessage("cache.disable", new Object[0]));
            ret.append(System.lineSeparator());
        }
        return ret.toString();
    }

    protected IScanTargetMinProxy getProxy() {
        return this.m_proxy;
    }

    protected Language.LANGUAGE getLanguage() {
        return Language.LANGUAGE.JAVA;
    }

    protected IProgress getProgress() {
        return this.m_progress;
    }

    public void runPostSliceProcesses() throws IOException, JSONException, VDBException {
        this.m_class_field_tracker.saveClassFieldTrackerJson(new File(this.m_destination_dir, "vars.json"));
        if (this.getDestinationDir() != null) {
            PrepareStatsWriter stats = new PrepareStatsWriter(this.getDestinationDir(), this.getDestinationDir());
            try {
                for (String ignoredStat : IGNORED_STATS) {
                    stats.removeMetric(ignoredStat);
                }
                stats.getMetric("NumberOfSlices").addMetricValue(this.m_bucket_count.toString());
                stats.saveXml();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private List<List<File>> getBuckets() throws JSONException, IOException, VDBException {
        if (this.m_buckets == null) {
            HashMap<Object, Object> previous_bucket;
            ArrayList<File> current_bucket;
            ArrayList<List<File>> ret;
            HashSet<String> already_processed;
            block23: {
                already_processed = new HashSet<String>();
                ret = new ArrayList<List<File>>();
                current_bucket = new ArrayList<File>();
                previous_bucket = new HashMap();
                try {
                    previous_bucket = IrxMinorCacheManagement.getPreviousBuckets();
                }
                catch (Exception e) {
                    if (this.getProxy() == null) break block23;
                    this.getProxy().getErrorManager().reportError(e.getMessage(), (Throwable)e);
                }
            }
            HashMap<String, HashSet<String>> wafl_friends = this.getWaflReader(this.m_proxy).getDependencies();
            HashMap merged_peers_raw = new HashMap();
            if (this.m_bucket_size > 1) {
                for (String string : previous_bucket.keySet()) {
                    if (!merged_peers_raw.containsKey(string)) {
                        merged_peers_raw.put(string, new HashSet());
                    }
                    for (Object peer : (HashSet)previous_bucket.get(string)) {
                        if (!this.getFriendClassMap().containsKey(peer)) continue;
                        ((HashSet)merged_peers_raw.get(string)).add(peer);
                    }
                }
            }
            if (wafl_friends != null && wafl_friends.keySet().size() > 0) {
                for (String string : wafl_friends.keySet()) {
                    if (!this.getFriendClassMap().containsKey(string)) continue;
                    HashSet<String> friends_to_log = new HashSet<String>();
                    friends_to_log.add(string);
                    if (!merged_peers_raw.containsKey(string)) {
                        merged_peers_raw.put(string, new HashSet());
                    }
                    for (String string2 : wafl_friends.get(string)) {
                        if (!this.getFriendClassMap().containsKey(string2)) continue;
                        friends_to_log.add(string2);
                        ((HashSet)merged_peers_raw.get(string)).add(string2);
                    }
                    if (friends_to_log.size() <= 1) continue;
                    JSONObject friends_json = new JSONObject();
                    friends_json.put("friends", friends_to_log);
                    this.getSlicerStats().append("wafl.friends.class.info", (Object)friends_json);
                }
            }
            HashSet<String> trim = new HashSet<String>();
            for (String key : merged_peers_raw.keySet()) {
                if (((HashSet)merged_peers_raw.get(key)).size() != 0) continue;
                trim.add(key);
            }
            for (String key : trim) {
                merged_peers_raw.remove(key);
            }
            HashMap hashMap = new HashMap();
            for (String key : merged_peers_raw.keySet()) {
                if (!hashMap.containsKey(key)) {
                    hashMap.put(key, new HashSet());
                }
                ((HashSet)hashMap.get(key)).add(key);
                for (String peer : (HashSet)merged_peers_raw.get(key)) {
                    ((HashSet)hashMap.get(key)).add(peer);
                    if (!merged_peers_raw.containsKey(peer)) continue;
                    for (String peer_of_peer : (HashSet)merged_peers_raw.get(peer)) {
                        ((HashSet)hashMap.get(key)).add(peer_of_peer);
                    }
                }
            }
            for (String clazz : this.getFriendClassMap().keySet()) {
                if (already_processed.contains(clazz)) continue;
                if (hashMap.containsKey(clazz)) {
                    ArrayList<File> arrayList = new ArrayList<File>();
                    arrayList.add(this.getFriendClassMap().get(clazz));
                    already_processed.add(clazz);
                    for (String peer : (HashSet)hashMap.get(clazz)) {
                        already_processed.add(peer);
                        if (!this.getFriendClassMap().containsKey(peer)) continue;
                        arrayList.add(this.getFriendClassMap().get(peer));
                    }
                    ret.add(arrayList);
                    continue;
                }
                if (current_bucket.size() >= this.m_bucket_size) {
                    ret.add(current_bucket);
                    current_bucket = new ArrayList();
                }
                already_processed.add(clazz);
                current_bucket.add(this.getFriendClassMap().get(clazz));
            }
            if (current_bucket.size() > 0) {
                ret.add(current_bucket);
            }
            this.m_buckets = ret;
            for (File f : this.m_stager.getUserCodeFiles()) {
                this.processVarsForClass(f);
            }
        }
        return this.m_buckets;
    }

    public void runSlicer() {
        CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("can_wafl_gen");
        try {
            this.getProgress().setStatus(new Message(1, Messages.getMessage("slicing.start", new Object[0])));
            if (this.getProxy() != null) {
                new File(this.getProxy().getScanHome(), ".slice_present").createNewFile();
            }
            new File(this.getDestinationDir(), ".slice_directory").createNewFile();
            if (IrxMinorCacheManagement.cleanupIfNeeded()) {
                this.getProgress().setStatus(new Message(1, Messages.getMessage("cache.clean", new Object[0])));
            }
            long slice_start = System.currentTimeMillis();
            this.getSlicerStats().put("slice.class.file.count", this.m_stager.getUserCodeFiles().size());
            ThreadPoolExecutorWithLimit pool = new ThreadPoolExecutorWithLimit();
            final AtomicInteger counter = new AtomicInteger();
            final int total = this.m_stager.getUserCodeFiles().size();
            final HashMap<String, HashSet<String>> new_buckets = new HashMap<String, HashSet<String>>();
            for (final List<File> chunk : this.getBuckets()) {
                pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        Bucket b = null;
                        try {
                            b = new Bucket(Slicer.this.getDestinationDir(), Slicer.this.m_bucket_size);
                            for (File file : chunk) {
                                b.addClassToBucket(new SlicerClassInfo(file), true);
                            }
                            if (b.getClassesInBucket().size() > 0) {
                                Slicer.this.m_bucket_count.incrementAndGet();
                                Slicer.this.prepareSlice(b, counter, total);
                                Slicer.this.createBucketVdb(b);
                                if (b.getClassesInBucket().size() > 1) {
                                    for (ClassInfo classInfo : b.getClassesInBucket()) {
                                        new_buckets.put(classInfo.getClassName(), new HashSet());
                                        for (ClassInfo classInfo2 : b.getClassesInBucket()) {
                                            if (classInfo2.getClassName().equals(classInfo.getClassName())) continue;
                                            ((HashSet)new_buckets.get(classInfo.getClassName())).add(classInfo2.getClassName());
                                        }
                                    }
                                }
                            } else {
                                b.deleteBucket();
                            }
                        }
                        catch (Exception e) {
                            Slicer.this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
            pool.shutDownAndWait(this.getProgress(), new Message(2, Messages.getMessage("slice.timeout", new Object[0])), 1L, TimeUnit.DAYS);
            IrxMinorCacheManagement.updatePreviousBuckets(new_buckets);
            long end = System.currentTimeMillis() - slice_start;
            this.getProgress().setStatus(new Message(1, Messages.getMessage("slicing.end.timing", end)));
            this.getSlicerStats().put("slice.total.run.time", end);
            this.getSlicerStats().put("slice.buckets", this.m_bucket_count.get());
            this.saveSliceStats();
            try {
                this.runPostSliceProcesses();
            }
            catch (Exception e) {
                this.m_proxy.getLogManager().log(e);
            }
        }
        catch (IOException e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (VDBException e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
    }

    private void prepareSlice(Bucket b, AtomicInteger counter, int total) throws JSONException {
        JSONObject bucket = new JSONObject();
        long bucket_start = System.currentTimeMillis();
        try {
            bucket.put("id", b.getId());
            if (SystemUtil.useCacheForSlicer()) {
                new TargetInfoSliceXml(b.getBucketDir(), this.getProxy(), b, this.m_stager).saveXml();
                if (IrxMinorCacheManagement.isBucketInCache(b)) {
                    this.m_bucket_cache_hits.incrementAndGet();
                    bucket.put("in.cache", true);
                } else {
                    this.m_bucket_cache_miss.incrementAndGet();
                    bucket.put("in.cache", false);
                }
            }
            AppScan appscan = new AppScan();
            appscan.prepare(b, this.getWaflGen(), this.m_stager, this.m_proxy);
            bucket.put("irgen.engine.time", appscan.getIrGenTime());
            StringBuilder classes = new StringBuilder();
            for (ClassInfo classInfo : b.getClassesInBucket()) {
                this.printProgressForSlice(classInfo.getClassName(), counter, total);
                bucket.append("classes", (Object)classInfo.getClassName());
            }
            if (classes.length() > 0) {
                classes.deleteCharAt(classes.length() - 1);
            }
            long slice_over_all_end = System.currentTimeMillis() - bucket_start;
            bucket.put("irgen.overall.time", slice_over_all_end);
            String bucketKey = IrxMinorCacheManagement.getCacheKeyForBucket(b);
            bucket.put("cacheKey", (Object)bucketKey);
            if (this.m_proxy != null) {
                this.m_proxy.getLogManager().log(new Message(1, Messages.getMessage("bucket.end.timing", b.getId(), classes.toString(), slice_over_all_end)));
            }
            this.getSlicerStats().append("buckets", (Object)bucket);
        }
        catch (IOException e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (AppScanException e) {
            e.printStackTrace();
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (TransformerException e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
    }

    private void createBucketVdb(Bucket b) throws VDBGeneralException, BadMarkupException {
        Vdb slice_user_code = new Vdb(Language.LANGUAGE.JAVA);
        for (SlicerClassInfo ci : b.getClassesInBucket()) {
            for (MethodInfo user : ci.getMethods()) {
                slice_user_code.addMethod(user.getMethod());
            }
        }
        VdbProvider.saveVdb((Vdb)slice_user_code, (File)new File(b.getBucketDir(), "slice_user.vdb"));
    }

    private void processVarsForClass(File f) throws IOException, JSONException, VDBException {
        block3: {
            try {
                SlicerClassInfo ci = new SlicerClassInfo(f);
                if (((JavaStager)this.m_stager).getStageDirectory() != null && this.m_stager.getStagedFilesMap().get(ci.getOriginalFileLocation().getAbsolutePath()) != null && new File(((JavaStager)this.m_stager).getStageDirectory(), (String)this.m_stager.getStagedFilesMap().get(ci.getOriginalFileLocation().getAbsolutePath())).exists() && JavaStager.isJsp((String)((String)this.m_stager.getStagedFilesMap().get(ci.getOriginalFileLocation().getAbsolutePath())))) {
                    ci.setJspFileLocation(new File(((JavaStager)this.m_stager).getStageDirectory(), (String)this.m_stager.getStagedFilesMap().get(ci.getOriginalFileLocation().getAbsolutePath())));
                }
                this.m_class_field_tracker.addClassInfoFieldTracking((ClassInfo)ci);
            }
            catch (Exception e) {
                if (this.getProxy() == null) break block3;
                this.getProxy().getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized HashMap<String, File> getFriendClassMap() throws IOException {
        if (this.m_friend_map == null) {
            this.m_friend_map = new HashMap();
            for (File f : this.m_stager.getUserCodeFiles()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    this.m_friend_map.put(new ClassNameVisitor((InputStream)in).getClassName(), f);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close((Closeable)in);
            }
        }
        return this.m_friend_map;
    }

    private synchronized void printProgressForSlice(String class_name, AtomicInteger counter, int total) {
        if (!this.m_completed_slices.contains(class_name)) {
            this.m_completed_slices.add(class_name);
            this.getProgress().setStatus(new Message(1, Messages.getMessage("processed.class", class_name, counter.incrementAndGet(), total)));
            if (SystemUtil.shouldShowProgress()) {
                double percentComplete = (double)counter.get() * 1.0 / (double)total;
                this.getProgress().setStatus(new Message(1, Messages.getMessage("processed.percent", (int)(100.0 * percentComplete))));
            }
        }
    }

    private synchronized WaflReader getWaflReader(IScanTargetMinProxy proxy) {
        if (this.m_wafl_reader == null) {
            File wafl_file = this.getWaflGen().getWaflFile();
            try {
                this.m_wafl_reader = new WaflReader(wafl_file, (JavaStager)this.m_stager);
                this.getSlicerStats().put("wafl.gen.time", this.getWaflGen().getWaflGenTime());
            }
            catch (ParserConfigurationException e) {
                proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
            catch (JSONException e) {
                proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
        }
        return this.m_wafl_reader;
    }

    private synchronized JavaWaflGen getWaflGen() {
        if (this.m_wafl_gen == null) {
            this.m_wafl_gen = new JavaWaflGen(this.m_stager, this.getProxy(), this.getProgress());
        }
        return this.m_wafl_gen;
    }

    private JSONObject getSlicerStats() {
        return this.m_stats;
    }

    private void saveSliceStats() {
        if (this.getDestinationDir() != null) {
            File log = Paths.get(this.getProxy() != null ? this.m_proxy.getScanHome().getAbsolutePath() : this.getDestinationDir().getParentFile().getAbsolutePath(), "logs", "slice.prepare.stats.json").toFile();
            try {
                if (log.getParentFile() != null) {
                    log.getParentFile().mkdirs();
                }
                IOUtil.write((String)this.getSlicerStats().toString(true), (File)log);
            }
            catch (IOException e) {
                this.m_proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static File getIPVA(File file) throws AppScanException {
        File[] ipva = DirectoryUtil.getFiles((File)file, (String)".ipva.xml");
        if (ipva.length == 1) {
            return ipva[0];
        }
        return null;
    }
}

