/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util;

import com.ibm.wala.util.debug.Assertions;

public class Union<T, U> {
    private boolean isFirst;
    private T first;
    private U second;

    private Union(T fst, U snd, boolean is_first_type) {
        this.first = fst;
        this.second = snd;
        this.isFirst = is_first_type;
    }

    public T getFirst() {
        if (this.isFirst) {
            return this.first;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public U getSecond() {
        if (!this.isFirst) {
            return this.second;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public boolean isFirstType() {
        return this.isFirst;
    }

    public static <T, U> Union<T, U> makeUnionFirst(T first) {
        return new Union<T, Object>(first, null, true);
    }

    public static <T, U> Union<T, U> makeUnionSecond(U second) {
        return new Union<Object, U>(null, second, false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.isFirst ? 1231 : 1237);
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Union other = (Union)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        if (this.isFirst != other.isFirst) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    public String toString() {
        return "Union [isFirst=" + this.isFirst + ", first=" + this.first + ", second=" + this.second + "]";
    }
}

