/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.impl;

import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CAstControlFlowRecorder
implements CAstControlFlowMap {
    private final CAstSourcePositionMap src;
    private final Map<CAstNode, Object> CAstToNode = new LinkedHashMap<CAstNode, Object>();
    private final Map<Object, CAstNode> nodeToCAst = new LinkedHashMap<Object, CAstNode>();
    private final Map<Key, Object> table = new LinkedHashMap<Key, Object>();
    private final Map<Object, Set<Object>> labelMap = new LinkedHashMap<Object, Set<Object>>();
    private final Map<Object, Set<Object>> sourceMap = new LinkedHashMap<Object, Set<Object>>();
    private Collection<CAstNode> cachedMappedNodes = null;

    public CAstControlFlowRecorder(CAstSourcePositionMap src) {
        this.src = src;
        this.map(EXCEPTION_TO_EXIT, EXCEPTION_TO_EXIT);
    }

    @Override
    public CAstNode getTarget(CAstNode from, Object label) {
        assert (this.CAstToNode.get(from) != null);
        Key key = new Key(label, this.CAstToNode.get(from));
        if (this.table.containsKey(key)) {
            Object target = this.table.get(key);
            assert (this.nodeToCAst.containsKey(target));
            return this.nodeToCAst.get(target);
        }
        return null;
    }

    @Override
    public Collection<Object> getTargetLabels(CAstNode from) {
        if (this.labelMap.containsKey(this.CAstToNode.get(from))) {
            return this.labelMap.get(this.CAstToNode.get(from));
        }
        return Collections.emptySet();
    }

    @Override
    public Collection getSourceNodes(CAstNode to) {
        if (this.sourceMap.containsKey(this.CAstToNode.get(to))) {
            return this.sourceMap.get(this.CAstToNode.get(to));
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Collection<CAstNode> getMappedNodes() {
        Collection<CAstNode> nodes = this.cachedMappedNodes;
        if (nodes == null) {
            nodes = new LinkedHashSet<CAstNode>();
            for (Key key : this.table.keySet()) {
                nodes.add(this.nodeToCAst.get(key.from));
                nodes.add(this.nodeToCAst.get(this.table.get(key)));
            }
            this.cachedMappedNodes = nodes;
        }
        return nodes;
    }

    public void add(Object from, Object to, Object label) {
        assert (from != null);
        assert (to != null);
        if (this.CAstToNode.containsKey(to)) {
            to = this.CAstToNode.get(to);
        }
        if (this.CAstToNode.containsKey(from)) {
            from = this.CAstToNode.get(from);
        }
        this.table.put(new Key(label, from), to);
        Set<Object> ls = this.labelMap.get(from);
        if (ls == null) {
            ls = new LinkedHashSet<Object>(2);
            this.labelMap.put(from, ls);
        }
        ls.add(label);
        Set<Object> ss = this.sourceMap.get(to);
        if (ss == null) {
            ss = new LinkedHashSet<Object>(2);
            this.sourceMap.put(to, ss);
        }
        ss.add(from);
    }

    public void map(Object node, CAstNode ast) {
        assert (node != null);
        assert (ast != null);
        assert (!this.nodeToCAst.containsKey(node) || this.nodeToCAst.get(node) == ast) : node + " already mapped:\n" + this;
        assert (!this.CAstToNode.containsKey(ast) || this.CAstToNode.get(ast) == node) : ast + " already mapped:\n" + this;
        this.nodeToCAst.put(node, ast);
        this.cachedMappedNodes = null;
        this.CAstToNode.put(ast, node);
    }

    public void addAll(CAstControlFlowMap other) {
        for (CAstNode n : other.getMappedNodes()) {
            if (!this.CAstToNode.containsKey(n)) {
                this.map(n, n);
            }
            for (Object l : other.getTargetLabels(n)) {
                CAstNode to = other.getTarget(n, l);
                this.add(n, to, l);
            }
        }
    }

    public boolean isMapped(Object node) {
        return this.nodeToCAst.containsKey(node);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("control flow map\n");
        for (Key key : this.table.keySet()) {
            sb.append(key.from);
            if (this.src != null && this.nodeToCAst.get(key.from) != null && this.src.getPosition(this.nodeToCAst.get(key.from)) != null) {
                sb.append(" (").append(this.src.getPosition(this.nodeToCAst.get(key.from))).append(") ");
            }
            sb.append(" -- ");
            sb.append(key.label);
            sb.append(" --> ");
            sb.append(this.table.get(key));
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private static class Key {
        private final Object label;
        private final Object from;

        Key(Object label, Object from) {
            assert (from != null);
            this.from = from;
            this.label = label;
        }

        public int hashCode() {
            if (this.label != null) {
                return this.from.hashCode() * this.label.hashCode();
            }
            return this.from.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Key && this.from == ((Key)o).from && (this.label == null ? ((Key)o).label == null : this.label.equals(((Key)o).label));
        }

        public String toString() {
            return "<key " + this.label + " : " + this.from + ">";
        }
    }
}

