/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.impl;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class RangePosition
extends AbstractSourcePosition
implements CAstSourcePositionMap.Position {
    private final URL url;
    private final int startLine;
    private final int endLine;
    private final int startOffset;
    private final int endOffset;

    public RangePosition(URL url, int startLine, int endLine, int startOffset, int endOffset) {
        this.url = url;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public RangePosition(URL url, int line, int startOffset, int endOffset) {
        this(url, line, -1, startOffset, endOffset);
    }

    @Override
    public int compareTo(Object o) {
        CAstSourcePositionMap.Position other = (CAstSourcePositionMap.Position)o;
        if (this.startOffset != other.getFirstOffset()) {
            return this.startOffset - other.getFirstOffset();
        }
        return this.endOffset - other.getLastOffset();
    }

    public int getFirstLine() {
        return this.startLine;
    }

    public int getLastLine() {
        return this.endLine;
    }

    public int getFirstCol() {
        return -1;
    }

    public int getLastCol() {
        return -1;
    }

    public int getFirstOffset() {
        return this.startOffset;
    }

    public int getLastOffset() {
        return this.endOffset;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.url.openStream());
    }
}

