/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.cg;

import com.ibm.wala.andromeda.cg.IEntrypointLocator;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Set;

public class EntrypointLocator
implements IEntrypointLocator {
    private final Set<IMethod> entrypoints = HashSetFactory.make();

    public static EntrypointLocator makeLocator(Predicate<IClass> classCandidates, Predicate<IMethod> methodCandidates, IClassHierarchy cha) {
        EntrypointLocator ret = new EntrypointLocator();
        for (IClass c : cha) {
            if (!classCandidates.test((Object)c)) continue;
            for (IMethod m : c.getDeclaredMethods()) {
                if (!methodCandidates.test((Object)m)) continue;
                ret.entrypoints.add(m);
            }
        }
        return ret;
    }

    @Override
    public Set<IMethod> locateEntrypoints(IClassHierarchy cha) {
        return this.entrypoints;
    }

    public static Predicate<IMethod> getDefaultMethodFilter() {
        return new Predicate<IMethod>(){

            public boolean test(IMethod m) {
                return !m.isPrivate() && !m.isNative() && !m.isAbstract();
            }
        };
    }
}

