/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BFSPathsFinder<T> {
    private final boolean DEBUG = false;
    private final Graph<T> G;
    private final Filter<T> filter;
    private final Collection<T> roots;
    private static final boolean DEFAULT_STOP_ON_MATCH = false;
    private boolean stopOnMatch = false;

    private static <Type> Map<Type, Set<List<Type>>> findPathsFromMultipleSourcesNew(Graph<Type> G, Collection<Type> seeds, Filter<Type> f, boolean stopOnMatch) {
        HashMap results = HashMapFactory.make();
        for (Type seed : seeds) {
            BFSPathsFinder<Type> finder = new BFSPathsFinder<Type>(G, Collections.singleton(seed), f, stopOnMatch);
            Map<Type, Set<List<Type>>> findings = finder.find();
            for (Map.Entry<Type, Set<List<Type>>> e : findings.entrySet()) {
                MapUtil.findOrCreateSet((Map)results, e.getKey()).addAll((Collection)e.getValue());
            }
        }
        return results;
    }

    private static <Type> Map<Type, Set<List<Type>>> findPathsFromMultipleSourcesOld(Graph<Type> G, Collection<Type> seeds, Filter<Type> f, boolean stopOnMatch) {
        BFSPathsFinder<Type> finder = new BFSPathsFinder<Type>(G, seeds, f, stopOnMatch);
        return finder.find();
    }

    public static <Type> Map<Type, Set<List<Type>>> findPathsFromMultipleSources(Graph<Type> G, Collection<Type> seeds, Filter<Type> f) {
        return BFSPathsFinder.findPathsFromMultipleSources(G, seeds, f, false);
    }

    public static <Type> Map<Type, Set<List<Type>>> findPathsFromMultipleSources(Graph<Type> G, Collection<Type> seeds, Filter<Type> f, boolean stopOnMatch) {
        return BFSPathsFinder.findPathsFromMultipleSourcesNew(G, seeds, f, stopOnMatch);
    }

    private BFSPathsFinder(Graph<T> G, Collection<T> N, Filter<T> f, boolean stopOnMatch) {
        this(G, N, f);
        this.stopOnMatch = stopOnMatch;
    }

    private BFSPathsFinder(Graph<T> G, Collection<T> N, Filter<T> f) {
        this.G = G;
        this.roots = N;
        this.filter = f;
    }

    public Map<T, Set<List<T>>> find() {
        return this.oldfind();
    }

    private Map<T, Set<List<T>>> newfind() {
        HashMap result = HashMapFactory.make();
        LinkedList<Pair> Q = new LinkedList<Pair>();
        HashMap startingHistory = HashMapFactory.make();
        for (T root : this.roots) {
            startingHistory.put(root, null);
            Q.addLast(Pair.make(root, (Object)startingHistory));
        }
        while (!Q.isEmpty()) {
            Pair qItem = (Pair)Q.removeFirst();
            Object N = qItem.fst;
            HashMap currentHistory = (HashMap)qItem.snd;
            if (this.filter.accepts(N)) {
                Set range = MapUtil.findOrCreateSet((Map)result, (Object)N);
                range.add(this.makePath(N, currentHistory));
                if (this.stopOnMatch) continue;
            }
            Iterator<Object> children = this.getConnected(N);
            while (children.hasNext()) {
                Object c = children.next();
                if (currentHistory.containsKey(c)) continue;
                HashMap newHistory = (HashMap)currentHistory.clone();
                newHistory.put(c, N);
                Q.addLast(Pair.make((Object)c, (Object)newHistory));
            }
        }
        return result;
    }

    private Map<T, Set<List<T>>> oldfind() {
        HashMap result = HashMapFactory.make();
        LinkedList<Object> Q = new LinkedList<Object>();
        HashMap history = HashMapFactory.make();
        for (T root : this.roots) {
            history.put(root, null);
            Q.addLast(root);
        }
        while (!Q.isEmpty()) {
            Object N = Q.removeFirst();
            if (this.filter.accepts(N)) {
                Set range = MapUtil.findOrCreateSet((Map)result, N);
                range.add(this.makePath(N, history));
                if (this.stopOnMatch) continue;
            }
            Iterator children = this.getConnected(N);
            while (children.hasNext()) {
                Object c = children.next();
                if (history.containsKey(c)) continue;
                history.put(c, N);
                Q.addLast(c);
            }
        }
        return result;
    }

    private List<T> makePath(T node, Map<Object, T> history) {
        ArrayList<T> result = new ArrayList<T>();
        T n = node;
        result.add(n);
        while (true) {
            T parent;
            if ((parent = history.get(n)) == null) {
                Collections.reverse(result);
                return result;
            }
            result.add(parent);
            n = parent;
        }
    }

    protected Iterator<? extends T> getConnected(T n) {
        return this.G.getSuccNodes(n);
    }
}

