/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.util.ChainedIterator;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class VariableRegistry
implements Iterable<Variable> {
    private final Map<IMethod, Set<Variable>> mapping = HashMapFactory.make();
    private int size;
    private final IClassHierarchy cha;

    public VariableRegistry(IClassHierarchy cha) {
        this.cha = cha;
    }

    public void add(Variable variable) {
        HashSet obsolete = null;
        boolean addVariable = true;
        Set image = MapUtil.findOrCreateSet(this.mapping, (Object)variable.getMethod());
        for (Variable v : image) {
            if (v.getVarID() != variable.getVarID()) continue;
            if (Variable.isSubsumedBy(v.getAccessPath(), variable.getAccessPath(), this.cha)) {
                addVariable = false;
                break;
            }
            if (!Variable.isSubsumedBy(variable.getAccessPath(), v.getAccessPath(), this.cha)) continue;
            if (obsolete == null) {
                obsolete = HashSetFactory.make();
            }
            obsolete.add(v);
        }
        if (addVariable) {
            image.add(variable);
            ++this.size;
        }
        if (obsolete != null) {
            int sizeBefore = image.size();
            image.removeAll(obsolete);
            int sizeAfter = image.size();
            this.size -= sizeBefore - sizeAfter;
        }
    }

    public void addAll(Set<Variable> setOfVariables) {
        for (Variable v : setOfVariables) {
            this.add(v);
        }
    }

    public void removeAll(VariableRegistry candidates) {
        for (Variable candidate : candidates) {
            this.remove(candidate);
        }
    }

    public void removeAll(Set<Variable> candidates) {
        for (Variable candidate : candidates) {
            this.remove(candidate);
        }
    }

    public void remove(Variable candidate) {
        Set<Variable> image = this.mapping.get(candidate.getMethod());
        if (image != null) {
            HashSet killSet = HashSetFactory.make();
            for (Variable v : image) {
                if (v.getVarID() != candidate.getVarID() || !Variable.isSubsumedBy(candidate.getAccessPath(), v.getAccessPath(), this.cha)) continue;
                killSet.add(v);
            }
            int sizeBefore = image.size();
            image.removeAll(killSet);
            int sizeAfter = image.size();
            this.size -= sizeBefore - sizeAfter;
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Variable> iterator() {
        return new ChainedIterator(this.mapping.values());
    }

    public boolean contains(Variable variable) {
        Set<Variable> image = this.mapping.get(variable.getMethod());
        if (image != null) {
            for (Variable v : image) {
                if (v.getVarID() != variable.getVarID() || !Variable.isSubsumedBy(v.getAccessPath(), variable.getAccessPath(), this.cha)) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.mapping.clear();
        this.size = 0;
    }

    public Set<Variable> getVariables(IMethod m) {
        return this.mapping.get(m);
    }
}

