/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.diagnostics;

import com.ibm.wala.andromeda.cg.util.SALogger;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Logger;

public class DebugUtil {
    private static final boolean DISABLE_GRAPH_CHECK = true;
    private static final Logger logger = SALogger.logger;
    private static int cgIndex = 0;
    private static int sdgIndex = 0;

    public static void visualizeSDG(Graph<Statement> sdg) {
        String psFileBase = "SDG" + sdgIndex++;
        String psFileExt = ".ps";
        String outputDir = "C:/temp";
        String dotExe = "c:/Progra~1/Graphviz2.22/bin/dot.exe";
        String psFile = outputDir + File.separatorChar + psFileBase + psFileExt;
        try {
            DotUtil.dotify(sdg, (NodeDecorator)DebugUtil.makeSDGNodeDecorator(), (String)"temp.dt", (String)psFile, (String)dotExe);
        }
        catch (WalaException ex) {
            System.out.println((Object)ex);
        }
    }

    public static void visualizeCallGraph(Graph<CGNode> cg, boolean disambiguateContexts) {
        String psFileBase = "CG" + cgIndex++;
        String psFileExt = ".ps";
        String outputDir = "C:/temp";
        String dotExe = "c:/Program Files/Graphviz2.22/bin/dot.exe";
        String psFile = outputDir + File.separatorChar + psFileBase + psFileExt;
        try {
            DotUtil.dotify(cg, (NodeDecorator)DebugUtil.makeCGNodeDecorator(disambiguateContexts), (String)"temp.dt", (String)psFile, (String)dotExe);
        }
        catch (WalaException ex) {
            System.out.println((Object)ex);
        }
    }

    public static void assertAndPrintOnFailure(boolean condition, String msg) {
        if (!condition) {
            System.out.println(msg);
            assert (condition);
        }
    }

    private static NodeDecorator makeSDGNodeDecorator() {
        return new NodeDecorator(){

            public String getLabel(Object o) throws WalaException {
                Statement stmt = (Statement)o;
                if (stmt == null) {
                    return "";
                }
                return stmt.getNode().getMethod().getDeclaringClass().toString() + "." + stmt.getNode().getMethod().getName().toString();
            }
        };
    }

    private static NodeDecorator makeCGNodeDecorator(final boolean disambiguateContexts) {
        return new NodeDecorator(){

            public String getLabel(Object o) throws WalaException {
                CGNode node = (CGNode)o;
                if (node == null) {
                    return "";
                }
                if (disambiguateContexts) {
                    return node.getMethod().getDeclaringClass().getName() + "\\n" + node.getMethod().getName().toString() + "\\n" + node.getContext().hashCode();
                }
                return node.getMethod().getDeclaringClass().getName() + "\\n" + node.getMethod().getName().toString();
            }
        };
    }

    public static void checkGraph(Graph<?> g) {
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static void findNodesWithMostChildren(CallGraph cg, String cond, PointerAnalysis pa) {
        logger.info((Object)(" *** Call graph size: " + cg.getNumberOfNodes()));
        logger.info((Object)" *** Analyzing call graph...");
        Comparator<Pair<Integer, CGNode>> comparator = new Comparator<Pair<Integer, CGNode>>(){

            @Override
            public int compare(Pair<Integer, CGNode> x, Pair<Integer, CGNode> y) {
                return ((Integer)x.fst).compareTo((Integer)y.fst);
            }
        };
        int HEAP_SIZE = 100;
        PriorityQueue<Pair<Integer, CGNode>> highest = new PriorityQueue<Pair<Integer, CGNode>>(100, comparator);
        CGNode condNode = null;
        HashSet<CGNode> condChildNodes = new HashSet<CGNode>();
        if (cond != null && cond.length() > 0) {
            for (CGNode node : cg) {
                String condStr = DebugUtil.getNodeDescription(node, (PointerAnalysis<InstanceKey>)pa);
                if (!condStr.contains(cond)) continue;
                condNode = node;
                DebugUtil.collectChildren(cg, condNode, condChildNodes);
                logger.info((Object)("Focusing on children of: " + DebugUtil.getNodeDescription(node, (PointerAnalysis<InstanceKey>)pa)));
                break;
            }
        }
        int count = 0;
        for (CGNode node : cg) {
            ++count;
            if (node.getMethod().toString().contains("FakeRootClass") || cond != null && cond.length() > 0 && node != condNode && !condChildNodes.contains(node)) continue;
            HashSet<CGNode> children = new HashSet<CGNode>();
            DebugUtil.collectChildren(cg, node, children);
            int weight = children.size();
            highest.offer((Pair<Integer, CGNode>)Pair.make((Object)weight, (Object)node));
            if (highest.size() <= 100) continue;
            highest.poll();
        }
        Stack<Pair<Integer, CGNode>> stack = new Stack<Pair<Integer, CGNode>>();
        while (highest.size() > 0) {
            stack.add(highest.poll());
        }
        logger.info((Object)"#              weight  node");
        count = 0;
        while (stack.size() > 0) {
            Pair pair = (Pair)stack.pop();
            int weight = (Integer)pair.fst;
            CGNode node = (CGNode)pair.snd;
            if (node.getMethod().isStatic() || node.getMethod().isInit()) continue;
            logger.info((Object)(++count + ")   (id=" + node.getGraphNodeId() + ")  " + weight + "   " + DebugUtil.getNodeDescription(node, (PointerAnalysis<InstanceKey>)pa)));
        }
    }

    private static void collectChildren(CallGraph cg, CGNode node, Set<CGNode> children) {
        if (cg.getSuccNodeCount((Object)node) <= 0) {
            return;
        }
        Iterator childIter = cg.getSuccNodes((Object)node);
        while (childIter.hasNext()) {
            CGNode child = (CGNode)childIter.next();
            if (children.contains(child)) continue;
            children.add(child);
            DebugUtil.collectChildren(cg, child, children);
        }
    }

    private static String getNodeDescription(CGNode node, PointerAnalysis<InstanceKey> pa) {
        PointerKey pk = pa.getHeapModel().getPointerKeyForLocal(node, 1);
        InstanceKey ik = pa.getPointsToSet(pk).size() > 0 ? (InstanceKey)pa.getPointsToSet(pk).iterator().next() : null;
        return node.getMethod().toString() + " :: " + (ik != null ? ik.getConcreteType().getName().toString() : "<null>");
    }

    public static String collectionToString(Iterable<? extends Object> c, int maxItems) {
        StringBuilder sb = new StringBuilder("{");
        int i = 0;
        for (Object object : c) {
            if (i > 0) {
                sb.append(", ");
            }
            if (++i > maxItems) {
                sb.append("...");
                break;
            }
            sb.append(object.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public static String toLimitedString(String string, int limit) {
        String ret = string.length() > limit ? string.substring(0, limit) + "..." : string;
        return ret;
    }
}

