/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.harness;

import com.ibm.wala.andromeda.harness.AbstractTaintRule;
import com.ibm.wala.andromeda.harness.TaintRule;
import java.util.Collection;

public class MergedRule
extends AbstractTaintRule {
    private final Collection<TaintRule> mergedRules;

    public MergedRule(Collection<TaintRule> taintRules) {
        super(taintRules.iterator().next().getClassHierarchy());
        this.mergedRules = taintRules;
        for (TaintRule tr : taintRules) {
            this.sourceRefs.addAll(tr.sourceRefs);
            this.sourceMethodResolutionMap.putAll(tr.sourceMethodResolutionMap);
            this.sinkRefs.addAll(tr.sinkRefs);
            this.sinkMethodResolutionMap.putAll(tr.sinkMethodResolutionMap);
            this.sanitizerRefs.addAll(tr.sanitizerRefs);
            this.sanitizerMethodResolutionMap.putAll(tr.sanitizerMethodResolutionMap);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cha == null ? 0 : this.cha.hashCode());
        result = 31 * result + (this.sanitizerRefs == null ? 0 : this.sanitizerRefs.hashCode());
        result = 31 * result + (this.sinkRefs == null ? 0 : this.sinkRefs.hashCode());
        result = 31 * result + (this.sourceRefs == null ? 0 : this.sourceRefs.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MERGED RULE:");
        for (TaintRule r : this.mergedRules) {
            sb.append("\n---> " + r.getDeclarativeRule().getName());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergedRule other = (MergedRule)obj;
        if (this.cha == null ? other.cha != null : !this.cha.equals(other.cha)) {
            return false;
        }
        if (this.sanitizerRefs == null ? other.sanitizerRefs != null : !this.sanitizerRefs.equals(other.sanitizerRefs)) {
            return false;
        }
        if (this.sinkRefs == null ? other.sinkRefs != null : !this.sinkRefs.equals(other.sinkRefs)) {
            return false;
        }
        return !(this.sourceRefs == null ? other.sourceRefs != null : !this.sourceRefs.equals(other.sourceRefs));
    }

    public Collection<TaintRule> getMergedRules() {
        return this.mergedRules;
    }
}

