/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.harness;

import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.BasicPropagationWitness;
import com.ibm.wala.andromeda.core.FieldPropagationWitness;
import com.ibm.wala.andromeda.core.FunctionCallPropagationWitness;
import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.SummaryPropagationWitness;
import com.ibm.wala.andromeda.core.UnknownFieldPropagationWitness;
import com.ibm.wala.andromeda.core.UnknownInvokePropagationWitness;
import com.ibm.wala.andromeda.harness.JspServices;
import com.ibm.wala.andromeda.harness.TaintRule;
import com.ibm.wala.andromeda.jsp.JSPMapping;
import com.ibm.wala.andromeda.rules.FlowStep;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.ITaintResult;
import com.ibm.wala.andromeda.rules.MethodOverwriteRule;
import com.ibm.wala.andromeda.util.InvalidFlowException;
import com.ibm.wala.andromeda.util.logging.DebugOutput;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.js.html.IncludedPosition;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptSummarizedFunction;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyRead;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyWrite;
import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaintResult
implements ITaintResult {
    public static boolean DEBUG = false;
    private static final int INCLUDED_FILE_LINE_CORRECTION = -1;
    private static final int MAX_ITER_COUNT_FOR_GET_SOURCE_AND_SINK = 10;
    private static final long serialVersionUID = 1L;
    private final String libraryCallPoint;
    private final String fileName;
    private final String source;
    private final String sink;
    private final int lineNo;
    private final List<FlowStep> flow;
    private final IRawTaintRule rule;
    private static final boolean LOG_DEBUG_HOOK = false;
    private static final Filter<List<IPropagationWitness>> LOG_DEBUG_FILTER = new Filter<List<IPropagationWitness>>(){

        public boolean accepts(List<IPropagationWitness> o) {
            IPropagationWitness w;
            return o != null && o.size() > 1 && (w = o.get(1)).toString().contains("LoginServlet");
        }
    };

    public TaintResult(List<IPropagationWitness> rawResult, IRawTaintRule rule, JspServices jspServices) throws InvalidFlowException, InvalidClassFileException {
        assert (rawResult != null);
        this.rule = rule;
        assert (rawResult.size() >= 2) : "ERROR: expected the flow to comprise at least of a source and a sink!";
        IPropagationWitness firstWitness = rawResult.get(0);
        SSAInstruction instr = firstWitness.getInstruction();
        Pair<String, String> sourceAndSink = this.getSourceAndSink(rawResult, rule, firstWitness, instr, 0);
        this.source = (String)sourceAndSink.fst;
        this.sink = (String)sourceAndSink.snd;
        this.flow = TaintResult.createFlow(rawResult, jspServices);
        IPropagationWitness libraryCallPoint = this.getLibraryCallPointPropagationWitness(rawResult);
        if (libraryCallPoint == null) {
            FlowStep lastStep = this.flow.get(this.flow.size() - 1);
            this.lineNo = lastStep.getLineNumber();
            String fullFileName = lastStep.getFileName();
            this.fileName = fullFileName.substring(fullFileName.lastIndexOf(47) + 1);
            this.libraryCallPoint = null;
        } else {
            FlowStep libCallPointStep = this.getLibraryCallPointFlowStep(this.flow);
            this.lineNo = libCallPointStep.getLineNumber();
            String fullFileName = libCallPointStep.getFileName();
            this.fileName = fullFileName.substring(fullFileName.lastIndexOf(47) + 1);
            this.libraryCallPoint = libCallPointStep.getDescriptor();
        }
    }

    protected Pair<String, String> getSourceAndSink(List<IPropagationWitness> rawResult, IRawTaintRule rule, IPropagationWitness firstWitness, SSAInstruction instr, int iterCount) {
        String sinkString;
        String sourceString;
        if (iterCount > 10) {
            Assertions.UNREACHABLE((String)("Recursion error: " + iterCount));
        }
        if (instr instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction sourceCall = (SSAAbstractInvokeInstruction)instr;
            sourceString = sourceCall.getDeclaredTarget().getName().toString();
            sinkString = this.getSinkIdentifier(rawResult);
        } else if (instr instanceof SSAGetInstruction) {
            SSAGetInstruction p = (SSAGetInstruction)instr;
            sourceString = firstWitness instanceof FieldPropagationWitness ? ((FieldPropagationWitness)firstWitness).getSamplePathsSimpleString() : "Field: " + p.getDeclaredField().getName().toString();
            sinkString = this.getSinkIdentifier(rawResult);
        } else if (instr instanceof JavaScriptPropertyRead) {
            sourceString = firstWitness instanceof UnknownFieldPropagationWitness ? ((UnknownFieldPropagationWitness)firstWitness).getSimpleString() : "Unknown field";
            sinkString = this.getSinkIdentifier(rawResult);
        } else if (instr instanceof PrototypeLookup) {
            PrototypeLookup pl = (PrototypeLookup)instr;
            IMethod sourceMethod = firstWitness.getMethod();
            Context sourceCtxt = firstWitness.getContext();
            DefUse du = TaintAnalysisCache.soleInstance().getDefUse(sourceMethod, sourceCtxt);
            int prototypeObj = pl.getUse(0);
            SSAInstruction defInstr = du.getDef(prototypeObj);
            DebugOutput.println((boolean)DEBUG, (Object)defInstr);
            DebugOutput.println((boolean)DEBUG, (String)"now what");
            Pair<String, String> sourceAndSink = this.getSourceAndSink(rawResult, rule, firstWitness, defInstr, ++iterCount);
            sourceString = (String)sourceAndSink.fst;
            sinkString = (String)sourceAndSink.snd;
        } else if (instr instanceof AstLexicalRead) {
            sourceString = "Unknown lexical access";
            sinkString = this.getSinkIdentifier(rawResult);
        } else if (rule instanceof MethodOverwriteRule) {
            MethodOverwriteRule r = (MethodOverwriteRule)rule;
            sourceString = r.getMethodSig();
            sinkString = r.getMethodSig();
        } else {
            sourceString = "UNKNOWN";
            sinkString = this.getSinkIdentifier(rawResult);
            if (DEBUG) {
                IMethod sourceMethod = firstWitness.getMethod();
                IR ir = TaintAnalysisCache.soleInstance().getIR(sourceMethod);
                System.err.println("=================================");
                System.err.println("=================================");
                System.err.println("Serious");
                System.err.println("We don't handle a flow with this type of source");
                System.err.println("instr: " + instr);
                System.err.println("method: " + sourceMethod);
                System.err.println("IR: " + ir.toString());
                System.err.println("rule: " + rule);
                System.err.println("=================================");
                System.err.println("=================================");
            }
            Assertions.UNREACHABLE((String)"Don't know what the source is for this flow");
        }
        return Pair.make((Object)sourceString, (Object)sinkString);
    }

    private String getSinkIdentifier(List<IPropagationWitness> rawResult) {
        IPropagationWitness lastWitness = rawResult.get(rawResult.size() - 1);
        if (lastWitness instanceof SummaryPropagationWitness) {
            return ((SummaryPropagationWitness)lastWitness).getTransitiveCallee().getName().toString();
        }
        SSAInstruction lastInstr = lastWitness.getInstruction();
        if (lastInstr instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction sinkCall = (SSAAbstractInvokeInstruction)lastInstr;
            if (lastWitness instanceof UnknownInvokePropagationWitness) {
                return ((UnknownInvokePropagationWitness)lastWitness).getSimpleString();
            }
            if (lastWitness instanceof FunctionCallPropagationWitness) {
                FunctionCallPropagationWitness witness = (FunctionCallPropagationWitness)lastWitness;
                return witness.getFunctionName();
            }
            if (lastWitness instanceof BasicPropagationWitness) {
                return sinkCall.getDeclaredTarget().getName().toString();
            }
            Assertions.UNREACHABLE((String)"There should be no otherpossible witnesses for this flow");
            return "ERROR";
        }
        if (lastInstr instanceof SSAPutInstruction) {
            FieldPropagationWitness fpw = (FieldPropagationWitness)lastWitness;
            return fpw.getSamplePathsSimpleString();
        }
        if (lastInstr instanceof JavaScriptPropertyWrite) {
            JavaScriptPropertyWrite jspw = (JavaScriptPropertyWrite)lastInstr;
            DebugOutput.println((boolean)DEBUG, (String)"In getSinkIdentifier make sure we handle the case where the sink is a JavaScriptPropertyWrite");
            return jspw.toString();
        }
        Assertions.UNREACHABLE((String)"We don't handle this type of sink");
        return "UNKNOWN";
    }

    private FlowStep getLibraryCallPointFlowStep(List<FlowStep> flow) {
        for (int index = flow.size() - 1; index >= 0; --index) {
            if (!flow.get(index).isUserCode()) continue;
            return flow.get(index);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flow == null ? 0 : this.flow.hashCode());
        result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaintResult other = (TaintResult)obj;
        if (this.flow == null ? other.flow != null : !this.flow.equals(other.flow)) {
            return false;
        }
        return !(this.rule == null ? other.rule != null : !this.rule.equals(other.rule));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Issue type: ");
        sb.append(this.getRule().getID());
        sb.append("\nTainted flow:\n");
        for (FlowStep fp : this.flow) {
            sb.append(fp);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toSimpleString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Issue type: ");
        sb.append(this.getRule().getID());
        sb.append("\nTainted flow:\n");
        for (FlowStep fp : this.flow) {
            sb.append(fp.toSimpleString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static Pair<MethodReference, MethodReference> getSourceAndSinkMRs(List<IPropagationWitness> rawResult) {
        IPropagationWitness sourceWitness = rawResult.get(0);
        MethodReference sourceCall = ((SSAAbstractInvokeInstruction)sourceWitness.getInstruction()).getDeclaredTarget();
        IPropagationWitness sinkWitness = rawResult.get(rawResult.size() - 1);
        MethodReference sinkCall = sinkWitness instanceof SummaryPropagationWitness ? ((SummaryPropagationWitness)sinkWitness).getTransitiveCallee().getReference() : ((SSAAbstractInvokeInstruction)sinkWitness.getInstruction()).getDeclaredTarget();
        return Pair.make((Object)sourceCall, (Object)sinkCall);
    }

    public static Collection<ITaintResult> toTaintResults(Map<List<IPropagationWitness>, Set<TaintRule>> rawResultMap, JspServices jspServices) throws InvalidFlowException {
        HashMap resultsBySourceAndSinkCalls = HashMapFactory.make();
        for (List<IPropagationWitness> rawResult : rawResultMap.keySet()) {
            Pair<MethodReference, MethodReference> sourceSinkPair = TaintResult.getSourceAndSinkMRs(rawResult);
            for (TaintRule rule : rawResultMap.get(rawResult)) {
                if (!rule.accepts((MethodReference)sourceSinkPair.fst, (MethodReference)sourceSinkPair.snd)) continue;
                try {
                    TaintResult.logDebugHook(rawResult);
                    TaintResult r = new TaintResult(rawResult, rule.getDeclarativeRule(), jspServices);
                    List<FlowStep> f = r.getFlow();
                    Set S = MapUtil.findOrCreateSet((Map)resultsBySourceAndSinkCalls, (Object)Pair.make((Object)f.get(0), (Object)f.get(f.size() - 1)));
                    S.add(r);
                }
                catch (InvalidClassFileException e) {
                    e.printStackTrace();
                }
            }
        }
        HashSet result = HashSetFactory.make();
        for (Set S : resultsBySourceAndSinkCalls.values()) {
            result.addAll(S);
        }
        return result;
    }

    private static void logDebugHook(List<IPropagationWitness> rawResult) {
    }

    private IPropagationWitness getLibraryCallPointPropagationWitness(List<IPropagationWitness> rawResult) {
        for (int index = rawResult.size() - 1; index >= 0; --index) {
            IPropagationWitness current = rawResult.get(index);
            if (current.getMethod() == null || !current.getMethod().getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) continue;
            return current;
        }
        return null;
    }

    public static List<FlowStep> createFlow(List<IPropagationWitness> rawResult, JspServices jspServices) throws InvalidClassFileException {
        ArrayList<FlowStep> result = new ArrayList<FlowStep>(rawResult.size());
        for (int index = 0; index < rawResult.size(); ++index) {
            IPropagationWitness witness = rawResult.get(index);
            SSAInstruction witnessInstr = witness.getInstruction();
            if (witnessInstr instanceof SSAPhiInstruction) {
                HashSet phiHistory = HashSetFactory.make();
                Set<FlowStep> fps = TaintResult.createFlowStepsForPhi((SSAPhiInstruction)witnessInstr, witness, jspServices, phiHistory);
                for (FlowStep f : fps) {
                    if (result.size() > 0) {
                        FlowStep previous = (FlowStep)result.get(result.size() - 1);
                        if (previous.equals(f)) continue;
                        result.add(f);
                        continue;
                    }
                    result.add(f);
                }
                continue;
            }
            CreateFlowStepRetVal createFlowStepResult = TaintResult.createFlowStep(witness.getMethod(), witness.getContext(), witnessInstr, witness.getLineNumber(), jspServices);
            if (!createFlowStepResult.flowStepCreated) continue;
            FlowStep fp = createFlowStepResult.fs;
            if (result.size() > 0) {
                FlowStep previous = (FlowStep)result.get(result.size() - 1);
                if (previous.equals(fp)) continue;
                result.add(fp);
                continue;
            }
            result.add(fp);
        }
        return result;
    }

    public static Set<FlowStep> createFlowStepsForPhi(SSAPhiInstruction phi, IPropagationWitness witness, JspServices jspServices, Set<SSAInstruction> history) {
        HashSet ret = HashSetFactory.make();
        for (int use = 0; use < phi.getNumberOfUses(); ++use) {
            IMethod witnessMethod = witness.getMethod();
            Context witnessContext = witness.getContext();
            SSAInstruction def = TaintAnalysisCache.soleInstance().getDefUse(witnessMethod, witnessContext).getDef(phi.getUse(use));
            if (def instanceof SSAPhiInstruction) {
                if (DEBUG) {
                    System.err.println("Creating flow steps for a PHI results in another PHI... Might lead to infinite recursion");
                }
                if (!history.add(def)) continue;
                ret.addAll(TaintResult.createFlowStepsForPhi((SSAPhiInstruction)def, witness, jspServices, history));
                continue;
            }
            CreateFlowStepRetVal createFlowStepResult = TaintResult.createFlowStep(witnessMethod, witnessContext, def, 1, jspServices);
            if (!createFlowStepResult.flowStepCreated) continue;
            ret.add(createFlowStepResult.fs);
        }
        return ret;
    }

    protected static boolean urlsAreEqual(URL a, URL b) {
        String aPath = a.getPath();
        String bPath = b.getPath();
        return aPath.equals(bPath);
    }

    public static CreateFlowStepRetVal createFlowStep(IMethod m, Context c, SSAInstruction witnessInstr, int witnessLineNumber, JspServices jspServices) {
        int lineNo;
        String fileName;
        CAstSourcePositionMap.Position pos;
        JSPMapping jspMapping = null;
        MethodReference mr = m.getReference();
        String descriptor = mr.getSignature();
        String className = TaintResult.computeClassName(mr.getDeclaringClass().getName().toString());
        if (m instanceof AstMethod) {
            AstMethod.DebuggingInformation debugInfo;
            IR ir = TaintAnalysisCache.soleInstance().getIR(m, c);
            SSAInstruction[] instructions = ir.getInstructions();
            int index = -1;
            for (int i = 0; i < instructions.length; ++i) {
                SSAInstruction instr = instructions[i];
                if (instr == null || !instr.equals((Object)witnessInstr)) continue;
                index = i;
                break;
            }
            AstMethod astMethod = (AstMethod)m;
            if (index == -1) {
                debugInfo = astMethod.debugInfo();
                pos = debugInfo.getCodeBodyPosition();
            } else {
                pos = astMethod.getSourcePosition(index);
                if (pos == null) {
                    debugInfo = astMethod.debugInfo();
                    pos = debugInfo.getCodeBodyPosition();
                    DebugOutput.println((boolean)DEBUG, (String)"We just did a hack to get the instruction position... fix this in the future");
                }
            }
            if (pos == null) {
                DebugOutput.println((boolean)DEBUG, (String)"We even failed in our attempt to create a line number and file name...");
                fileName = "unknown";
                lineNo = 1;
            } else {
                IncludedPosition posWithIncludePosition;
                CAstSourcePositionMap.Position includePosition;
                URL includedURL;
                int offset = 0;
                URL sourceFileURL = pos.getURL();
                if (pos instanceof IncludedPosition && TaintResult.urlsAreEqual(sourceFileURL, includedURL = (includePosition = (posWithIncludePosition = (IncludedPosition)pos).getIncludePosition()).getURL())) {
                    offset = includePosition.getFirstLine();
                    DebugOutput.println((boolean)DEBUG, (String)"We are adjusting line numbers here, this is very touchy, so if line numbers are off, look here first");
                    --offset;
                }
                URL url = sourceFileURL;
                String urlPath = url.getPath();
                try {
                    String decodedPath = URLDecoder.decode(urlPath, "utf-8");
                    File decodedPathFile = new File(decodedPath);
                    fileName = decodedPathFile.getPath();
                }
                catch (UnsupportedEncodingException e) {
                    if (DEBUG) {
                        System.err.println("Unsupportd ecoding for URL");
                        e.printStackTrace();
                    }
                    fileName = "unknown";
                }
                lineNo = pos.getFirstLine() + offset;
            }
        } else {
            if (m instanceof JavaScriptSummarizedFunction) {
                JavaScriptSummarizedFunction jssf = (JavaScriptSummarizedFunction)m;
                return new CreateFlowStepRetVal(false, null);
            }
            pos = null;
            lineNo = witnessLineNumber;
            jspMapping = TaintResult.getJSPMapping(jspServices, className, lineNo);
            fileName = className.replace('.', '/').concat(".java");
            if (jspMapping != null) {
                fileName = jspMapping.getFileName();
            }
        }
        IClassLoader classLoader = m.getDeclaringClass().getClassLoader();
        DebugOutput.println((boolean)DEBUG, (String)"WE MIGHT HAVE JUST MARKED ALL JS AS USER CODE");
        boolean isUserCode = classLoader instanceof JavaScriptLoader ? true : m.getClassHierarchy().getScope().isApplicationLoader(classLoader);
        boolean canSanitize = !mr.getReturnType().equals((Object)TypeReference.Void);
        FlowStep fs = new FlowStep(className, lineNo, pos, witnessInstr == null ? "null instruction" : witnessInstr.toString(), m.toString(), fileName, descriptor, jspMapping, isUserCode, canSanitize, null);
        return new CreateFlowStepRetVal(true, fs);
    }

    private static String computeClassName(String rawClassName) {
        int indexOfInnerClassDelimiter;
        StringBuilder sb = new StringBuilder(rawClassName);
        if (sb.charAt(0) == 'L') {
            sb.delete(0, 1);
        }
        if ((indexOfInnerClassDelimiter = sb.indexOf("$")) >= 0) {
            sb.delete(indexOfInnerClassDelimiter, sb.length());
        }
        return sb.toString().replace('/', '.');
    }

    private static JSPMapping getJSPMapping(JspServices jspServices, String className, int lineNo) {
        return jspServices.hasJspMapping(className) ? jspServices.getJspMapping(className, lineNo) : null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public List<FlowStep> getFlow() {
        return this.flow;
    }

    @Override
    public String getLibraryCallPoint() {
        return this.libraryCallPoint;
    }

    @Override
    public int getLineNo() {
        return this.lineNo;
    }

    @Override
    public IRawTaintRule getRule() {
        return this.rule;
    }

    @Override
    public String getSink() {
        return this.sink;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public static class CreateFlowStepRetVal {
        public boolean flowStepCreated;
        public FlowStep fs;

        public CreateFlowStepRetVal(boolean created, FlowStep flowStep) {
            this.flowStepCreated = created;
            this.fs = flowStep;
        }
    }
}

