/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.incremental;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ChangeSet
implements Iterable<Entry> {
    private final Set<Entry> entries = HashSetFactory.make();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CHANGE SET: { ");
        Iterator<Entry> it = this.entries.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(" , ");
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public boolean add(Entry e) {
        return this.entries.add(e);
    }

    public boolean addAll(Set<Entry> changeSetEntry) {
        return this.entries.addAll(changeSetEntry);
    }

    public static class MethodEntry
    extends Entry {
        private final MethodReference methodRef;
        private final Collection<CallSiteReference> newCallSites;
        private final Collection<CallSiteReference> deletedCallSites;

        public MethodEntry(EntryKind kind, MethodReference methodRef, EntryLevel level, Collection<CallSiteReference> newCallSites, Collection<CallSiteReference> deletedCallSites) {
            super(kind, level);
            this.methodRef = methodRef;
            this.newCallSites = newCallSites;
            this.deletedCallSites = deletedCallSites;
        }

        public MethodReference getMethod() {
            return this.methodRef;
        }

        public Collection<CallSiteReference> getNewCallSites() {
            return this.newCallSites;
        }

        public Collection<CallSiteReference> getDeletedCallSites() {
            return this.deletedCallSites;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("METHOD ENTRY: '");
            sb.append(this.methodRef.getDeclaringClass().getName().toString());
            sb.append(".");
            sb.append(this.methodRef.getName().toString());
            sb.append("' --- ");
            sb.append(super.toString());
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.newCallSites == null ? 0 : this.newCallSites.hashCode());
            result = 31 * result + (this.methodRef == null ? 0 : this.methodRef.hashCode());
            result = 31 * result + (this.deletedCallSites == null ? 0 : this.deletedCallSites.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodEntry other = (MethodEntry)obj;
            if (this.newCallSites == null ? other.newCallSites != null : !this.newCallSites.equals(other.newCallSites)) {
                return false;
            }
            if (this.methodRef == null ? other.methodRef != null : !this.methodRef.equals((Object)other.methodRef)) {
                return false;
            }
            return !(this.deletedCallSites == null ? other.deletedCallSites != null : !this.deletedCallSites.equals(other.deletedCallSites));
        }

        @Override
        public EntryType type() {
            return EntryType.METHOD;
        }
    }

    public static class TypeEntry
    extends Entry {
        private final TypeReference type;

        public TypeEntry(EntryKind kind, EntryLevel level, TypeReference type) {
            super(kind, level);
            this.type = type;
        }

        public TypeReference getType() {
            return this.type;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TYPE ENTRY: '");
            sb.append(this.type);
            sb.append("' --- ");
            sb.append(super.toString());
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeEntry other = (TypeEntry)obj;
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }

        @Override
        public EntryType type() {
            return EntryType.CLASS;
        }
    }

    public static abstract class Entry {
        private final EntryKind kind;
        private final EntryLevel level;

        protected Entry(EntryKind kind, EntryLevel level) {
            this.kind = kind;
            this.level = level;
        }

        public EntryKind getKind() {
            return this.kind;
        }

        public EntryLevel getLevel() {
            return this.level;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.kind) {
                case MODIFICATION: {
                    sb.append("modification");
                    break;
                }
                case REMOVAL: {
                    sb.append("removal");
                    break;
                }
                case ADDITION: {
                    sb.append("addition");
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                }
            }
            sb.append("/");
            switch (this.level) {
                case TAINT_ANALYSIS: {
                    sb.append("taint analysis.");
                    break;
                }
                case CALL_GRAPH: {
                    sb.append("call graph.");
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                }
            }
            return sb.toString();
        }

        public abstract EntryType type();
    }

    public static enum EntryLevel {
        CALL_GRAPH,
        TAINT_ANALYSIS;

    }

    public static enum EntryType {
        CLASS,
        METHOD;

    }

    public static enum EntryKind {
        ADDITION,
        REMOVAL,
        MODIFICATION;

    }
}

