/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.incremental;

import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.RawAnalysisResult;
import com.ibm.wala.andromeda.core.TaintGraphUtils;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.core.ViolationVariable;
import com.ibm.wala.andromeda.harness.JspServices;
import com.ibm.wala.andromeda.harness.TaintResult;
import com.ibm.wala.andromeda.harness.TaintRule;
import com.ibm.wala.andromeda.incremental.IRawTaintResult;
import com.ibm.wala.andromeda.rules.FlowStep;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.ITaintResult;
import com.ibm.wala.andromeda.util.InvalidFlowException;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class NoFlowTaintResult
implements IRawTaintResult {
    private static final long serialVersionUID = 1L;
    private final RawAnalysisResult analysisResult;
    private final Variable sourceVariable;
    private final ViolationVariable sinkVariable;
    private final TaintRule rule;
    private final List<FlowStep> flow;
    private final JspServices jspServices;

    public NoFlowTaintResult(RawAnalysisResult analysisResult, Variable sourceVariable, FlowStep callToSourceStep, ViolationVariable sinkVariable, FlowStep callToSinkStep, TaintRule rule, JspServices jspServices) {
        this.analysisResult = analysisResult;
        this.sourceVariable = sourceVariable;
        this.sinkVariable = sinkVariable;
        this.flow = new ArrayList<FlowStep>(2);
        this.flow.add(callToSourceStep);
        this.flow.add(callToSinkStep);
        this.rule = rule;
        this.jspServices = jspServices;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NO-FLOW TAINT RESULT:\n\t");
        sb.append(this.flow.get(0));
        sb.append("\n\t");
        sb.append(this.flow.get(1));
        return sb.toString();
    }

    @Override
    public String getFileName() {
        return this.flow.get(1).getFileName();
    }

    @Override
    public List<FlowStep> getFlow() {
        return this.flow;
    }

    @Override
    public String getLibraryCallPoint() {
        return this.flow.get(1).getDescriptor();
    }

    @Override
    public int getLineNo() {
        return this.flow.get(1).getLineNumber();
    }

    @Override
    public IRawTaintRule getRule() {
        return this.rule.getDeclarativeRule();
    }

    @Override
    public String getSink() {
        return this.flow.get(1).getDescriptor();
    }

    @Override
    public String getSource() {
        return this.flow.get(0).getDescriptor();
    }

    @Override
    public Collection<ITaintResult> refine() {
        Set<List<IPropagationWitness>> witnesses = TaintGraphUtils.processWithLCPs(this.analysisResult, Collections.singleton(this.rule), Collections.singleton(this.sourceVariable), Collections.singleton(this.sinkVariable));
        HashMap M = HashMapFactory.make();
        Set<TaintRule> ruleSingleton = Collections.singleton(this.rule);
        for (List<IPropagationWitness> witness : witnesses) {
            M.put(witness, ruleSingleton);
        }
        try {
            Collection<ITaintResult> taintResults = TaintResult.toTaintResults(M, this.jspServices);
            return taintResults;
        }
        catch (InvalidFlowException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public String toSimpleString() {
        return this.toString();
    }
}

