/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.models;

import com.ibm.wala.andromeda.cg.util.UserLog;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.core.ViolationVariable;
import com.ibm.wala.andromeda.core.WildcardVariable;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.models.IOfflineSpecification;
import com.ibm.wala.andromeda.modular.FlowAnalyzer;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.andromeda.util.io.TaintFileProvider;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.tables.StringTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class OfflineSpecification
implements IOfflineSpecification {
    private final Map<Selector, Set<IClass>> terminatingMethods = HashMapFactory.make();
    private final Map<String, Set<RawSummary>> rawSummaries = HashMapFactory.make();
    private final Map<IMethod, Set<Variable>> method2seeds = HashMapFactory.make();
    private final Map<Selector, Map<Variable, Set<Variable>>> variableSummary = HashMapFactory.make();
    private final Map<Selector, Set<IClass>> summarizedMethods = HashMapFactory.make();
    private final Map<IMethod, Map<Variable, Set<Variable>>> partiallySummarizedMethods = HashMapFactory.make();
    private final Map<Variable, Set<Variable>> sideEffectsRegister = HashMapFactory.make();
    private final IClassHierarchy cha;
    private final Language language;
    private final ILanguageSpecificServicesForFastanalysis langServices;
    private final Set<IMethod> exclusions = HashSetFactory.make();

    public OfflineSpecification(IClassHierarchy cha, Language language, ILanguageSpecificServicesForFastanalysis lang_services) {
        this.cha = cha;
        this.language = language;
        this.langServices = lang_services;
    }

    @Override
    public boolean createsSideEffectsOnTarget(Variable cause, Variable target) {
        Set<Variable> compatibleSummarizedVariable = this.findCompatibleVariables(cause);
        for (Variable v : compatibleSummarizedVariable) {
            Set<Variable> image = this.sideEffectsRegister.get(v);
            if (image == null || !image.contains(target)) continue;
            return true;
        }
        return false;
    }

    private Set<Variable> findCompatibleVariables(Variable variable) {
        HashSet result = HashSetFactory.make();
        IMethod m = variable.getMethod();
        Map<Variable, Set<Variable>> relevantMap = this.variableSummary.get(m.getSelector());
        if (relevantMap != null) {
            IClass varClass = m.getDeclaringClass();
            for (Variable maybeMatch : relevantMap.keySet()) {
                IClass maybeMatchClass;
                if (!(maybeMatch instanceof WildcardVariable) && maybeMatch.getVarID() != variable.getVarID() || !this.cha.isAssignableFrom(maybeMatchClass = maybeMatch.getMethod().getDeclaringClass(), varClass) || !Variable.areAccessPathsCompatible(variable.getAccessPath(), maybeMatch.getAccessPath(), this.cha)) continue;
                result.add(maybeMatch);
            }
        }
        return result;
    }

    @Override
    public Set<Variable> getSummary(Variable variable, ILanguageSpecificServicesForFastanalysis langServices) {
        Set<Variable> seeds;
        HashSet result;
        if (langServices.isParameter(variable)) {
            Map<Variable, Set<Variable>> partialSummary = this.partiallySummarizedMethods.get(variable.getMethod());
            if (partialSummary != null) {
                result = partialSummary.get(variable);
            } else {
                Selector selector = variable.getMethod().getSelector();
                Set<Variable> compatibleSummarizedVariables = this.findCompatibleVariables(variable);
                HashSet S = HashSetFactory.make();
                for (Variable v : compatibleSummarizedVariables) {
                    Set<Variable> image = this.variableSummary.get(selector).get(v);
                    assert (image != null) : "ERROR: expected summarized variables to have a non-null effect!";
                    S.addAll(image);
                }
                result = S.isEmpty() ? null : S;
            }
        } else {
            result = null;
        }
        if (result != null && (seeds = this.method2seeds.get(variable.getMethod())) != null) {
            for (Variable seed : seeds) {
                result.addAll(this.getSummary(seed, langServices));
            }
        }
        return result;
    }

    @Override
    public boolean hasSpecForMethod(IMethod m) {
        boolean result = false;
        if (m != null) {
            Set<IClass> classes = null;
            try {
                classes = this.getClassesForMethod(m);
            }
            catch (Exception e) {
                UserLog.logger.warn((Object)"Exception in hasSpecForMethod()!");
            }
            if (classes != null) {
                if (m.isInit()) {
                    result = classes.contains(m.getDeclaringClass());
                    return result;
                }
                for (IClass c : classes) {
                    if (!this.cha.isAssignableFrom(c, m.getDeclaringClass())) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private Set<IClass> getClassesForMethod(IMethod m) throws Exception {
        try {
            Set<IClass> classes = m.isInit() ? this.summarizedMethods.get(m.getSignature()) : this.summarizedMethods.get(m.getSelector());
            if (classes == null) {
                this.materializeRawSummaries(m);
                classes = this.summarizedMethods.get(m.getSelector());
            }
            return classes;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void reduceNumberOfCachedSummaries() {
        if (this.summarizedMethods.size() >= 500) {
            while (this.summarizedMethods.values().size() > 250) {
                Selector toRemove = this.summarizedMethods.keySet().iterator().next();
                this.summarizedMethods.remove(toRemove);
            }
        }
    }

    private void materializeRawSummaries(IMethod m) {
        String key = m.isInit() ? m.getSignature() : m.getName().toString();
        Set<RawSummary> rr = this.rawSummaries.get(key);
        if (rr != null) {
            for (RawSummary r : rr) {
                r.materialize();
            }
        }
        this.rawSummaries.remove(key);
    }

    public static OfflineSpecification loadDefaultSpec(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fastLangServices) {
        String offlineSpecFile = langServices.getOfflineSpecificationFile();
        try {
            File f = TaintFileProvider.getFile((String)offlineSpecFile);
            File autoSummariesFile = new File(FlowAnalyzer.AUTO_SUMMARIES_FILE_NAME);
            return OfflineSpecification.load(f, autoSummariesFile, cha, langServices.getLanguage(), fastLangServices);
        }
        catch (IOException e) {
            System.err.println("Failed to load offline specification " + offlineSpecFile + ": " + e);
            return null;
        }
    }

    public static OfflineSpecification load(File f, File autoSummariesFile, IClassHierarchy cha, Language l, ILanguageSpecificServicesForFastanalysis lang_services) throws FileNotFoundException, IOException {
        OfflineSpecification result = new OfflineSpecification(cha, l, lang_services);
        OfflineSpecification.processSummaryFile(lang_services, result, f);
        if (autoSummariesFile.exists()) {
            OfflineSpecification.processSummaryFile(lang_services, result, autoSummariesFile);
        }
        return result;
    }

    private static void processSummaryFile(ILanguageSpecificServicesForFastanalysis lang_services, OfflineSpecification result, File f) throws FileNotFoundException, IOException {
        StringTable t = StringTable.readFromTextFile((File)f, (Character)Character.valueOf('#'));
        for (int i = 0; i < t.getNumberOfRows(); ++i) {
            Set rs;
            Map row = t.row2Map(i);
            String methodSignature = (String)row.get("METHOD");
            String methodName = OfflineSpecification.getMethodName(methodSignature);
            if (methodName.equals("<init>")) {
                assert (methodSignature.contains(")")) : "ERROR: cannot handle partial signature in the case of '<init>'!";
                rs = MapUtil.findOrCreateSet(result.rawSummaries, (Object)methodSignature);
            } else {
                rs = MapUtil.findOrCreateSet(result.rawSummaries, (Object)methodName);
            }
            OfflineSpecification offlineSpecification = result;
            offlineSpecification.getClass();
            rs.add(offlineSpecification.new RawSummary(row, lang_services));
        }
    }

    private static String getMethodName(String qualifiedMethodSignature) {
        int indexOfDotDot;
        String result = qualifiedMethodSignature;
        int indexOfBrackets = result.indexOf(40);
        if (indexOfBrackets > -1) {
            result = result.substring(0, indexOfBrackets);
        }
        result = (indexOfDotDot = result.indexOf("..")) > -1 ? result.substring(result.lastIndexOf("..") + 1) : result.substring(result.lastIndexOf(46) + 1);
        return result;
    }

    private void addConditionalSummary(Variable cause, Variable effect) {
        Map taintRelations = MapUtil.findOrCreateMap(this.variableSummary, (Object)cause.getMethod().getSelector());
        Set taintedVars = MapUtil.findOrCreateSet((Map)taintRelations, (Object)cause);
        taintedVars.add(effect);
    }

    @Override
    public void addPartialSummary(Variable cause, Set<Variable> conditionalEffects) {
        IMethod M = cause.getMethod();
        Map summarized = MapUtil.findOrCreateMap(this.partiallySummarizedMethods, (Object)M);
        summarized.put(cause, conditionalEffects);
        for (Variable effect : conditionalEffects) {
            TypeReference tr;
            this.addConditionalSummary(cause, effect);
            if (effect.getVarID() == -1 || (tr = Variable.getVariableType(effect, this.langServices)) == null || !tr.isReferenceType() || this.language.isStringType(tr)) continue;
            Set image = MapUtil.findOrCreateSet(this.sideEffectsRegister, (Object)cause);
            image.add(effect);
        }
    }

    private static IMethod parseMethod(String methodSig, IClassHierarchy cha, Language l) {
        assert (!SignatureUtil.isPartialSig((String)methodSig)) : "ERROR: expected full method signature, but got: " + methodSig + ".";
        String type = OfflineSpecification.getTypeName(methodSig);
        String selector = methodSig.substring(type.length());
        IClass klass = SignatureUtil.getDeclaringClass((String)methodSig, (IClassHierarchy)cha);
        if (klass != null) {
            return OfflineSpecification.findMethod(klass, selector, l);
        }
        return null;
    }

    private static String getTypeName(String methodSig) {
        int paren = methodSig.indexOf(40);
        String typeAndName = methodSig.substring(0, paren);
        int typeEnd = typeAndName.lastIndexOf("..") == -1 ? typeAndName.lastIndexOf(46) : typeAndName.lastIndexOf("..");
        String type = methodSig.substring(0, typeEnd);
        return "L" + type.replace('.', '/');
    }

    private static IMethod findMethod(IClass klass, String selector, Language l) {
        Selector s = OfflineSpecification.toSelector(selector, l);
        IMethod m = klass.getMethod(s);
        if (m != null) {
            return m;
        }
        Collection allMethods = klass.getAllMethods();
        for (IMethod im : allMethods) {
            if (!im.getSelector().toString().equals(selector)) continue;
            return im;
        }
        return null;
    }

    public static Selector toSelector(String s, Language l) {
        String name = s.substring(0, s.indexOf(40));
        String desc = s.substring(s.indexOf(40));
        Descriptor d = Descriptor.findOrCreateUTF8((Language)l, (String)desc);
        return new Selector(Atom.findOrCreateUnicodeAtom((String)name), d);
    }

    private static Boolean parseSideEffectValue(String path) {
        if (path == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        String token = tokenizer.nextToken();
        assert (token.startsWith("T") || token.startsWith("F"));
        return token.startsWith("T");
    }

    private static Pair<Integer, List<FieldReference>> parsePath(String path, IMethod m) {
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        String token = tokenizer.nextToken();
        if (token.startsWith("v") || token.startsWith("ret")) {
            String varIDStr;
            int varID = token.startsWith("v") ? ((varIDStr = token.substring(1)).startsWith("?") ? Integer.MAX_VALUE : Integer.parseInt(varIDStr)) : -1;
            ArrayList<FieldReference> accessPath = null;
            if (path.endsWith("*")) {
                accessPath = new ArrayList<FieldReference>();
                accessPath.add(Variable.DOT_STAR);
            }
            return Pair.make((Object)varID, accessPath);
        }
        return null;
    }

    private static boolean isUnconditionalEntry(String entry) {
        return entry.matches("\\[.*:v[0-9]+.*\\]") || entry.matches("\\[.*:ret.*\\]") || entry.matches("\\[v[0-9]+.*:.*\\]");
    }

    @Override
    public boolean hasPartialSpec(IMethod m, Variable variable) {
        Map<Variable, Set<Variable>> partialSummary = this.partiallySummarizedMethods.get(variable.getMethod());
        if (partialSummary != null) {
            return partialSummary.containsKey(variable);
        }
        return false;
    }

    public void addTerminatingMethods(Collection<IMethod> methods) {
        for (IMethod m : methods) {
            Set classes = MapUtil.findOrCreateSet(this.terminatingMethods, (Object)m.getSelector());
            classes.add(m.getDeclaringClass());
        }
    }

    public boolean isTerminatingMethod(IMethod m) {
        Set<IClass> s = this.terminatingMethods.get(m.getSelector());
        if (s != null) {
            for (IClass c : s) {
                if (!this.cha.isAssignableFrom(c, m.getDeclaringClass())) continue;
                return true;
            }
        }
        return false;
    }

    public void addExclusion(IMethod m) {
        this.exclusions.add(m);
    }

    public boolean isExcluded(IMethod m) {
        return this.exclusions.contains(m);
    }

    private class RawSummary {
        private final Map<String, String> summaryStrings;
        private final ILanguageSpecificServicesForFastanalysis langServices;

        public RawSummary(Map<String, String> summaryStrings, ILanguageSpecificServicesForFastanalysis lang_services) {
            this.summaryStrings = summaryStrings;
            this.langServices = lang_services;
        }

        public void materialize() {
            Set<IMethod> methods = this.resolveSignature(this.summaryStrings.get("METHOD"));
            for (IMethod method : methods) {
                Set classes = MapUtil.findOrCreateSet((Map)OfflineSpecification.this.summarizedMethods, (Object)method.getSelector());
                classes.add(method.getDeclaringClass());
                Variable entryVar = this.createSummaryVariable(method, this.summaryStrings.get("ENTRY"), true);
                Variable exitVar = this.createSummaryVariable(method, this.summaryStrings.get("EXIT"), false);
                if (entryVar == null || exitVar == null) continue;
                Map relevantMapping = MapUtil.findOrCreateMap((Map)OfflineSpecification.this.variableSummary, (Object)entryVar.getMethod().getSelector());
                Set mappedVars = MapUtil.findOrCreateSet((Map)relevantMapping, (Object)entryVar);
                mappedVars.add(exitVar);
                this.accountForSideEffects(entryVar, exitVar);
            }
        }

        private void accountForSideEffects(Variable entryVar, Variable exitVar) {
            TypeReference tr;
            Boolean hasSideEffect = OfflineSpecification.parseSideEffectValue(this.summaryStrings.get("SIDE_EFFECTS"));
            if (hasSideEffect == null && exitVar.getVarID() != -1 && (tr = Variable.getVariableType(exitVar, this.langServices)) != null && tr.isReferenceType() && !OfflineSpecification.this.language.isStringType(tr)) {
                hasSideEffect = true;
            }
            if (hasSideEffect == null) {
                hasSideEffect = false;
            }
            if (hasSideEffect.booleanValue()) {
                Set image = MapUtil.findOrCreateSet((Map)OfflineSpecification.this.sideEffectsRegister, (Object)entryVar);
                image.add(exitVar);
            }
        }

        private Set<IMethod> resolveSignature(String signature) {
            HashSet result = HashSetFactory.make();
            if (SignatureUtil.isPartialSig((String)signature)) {
                IClass klass = SignatureUtil.getDeclaringClass((String)signature, (IClassHierarchy)OfflineSpecification.this.cha);
                String methodName = signature.lastIndexOf("..") > 0 ? signature.substring(signature.lastIndexOf("..") + 1) : signature.substring(signature.lastIndexOf(46) + 1);
                for (IMethod m : klass.getAllMethods()) {
                    if (!m.getName().toString().equals(methodName)) continue;
                    result.add(m);
                }
            } else {
                IMethod m = OfflineSpecification.parseMethod(signature, OfflineSpecification.this.cha, OfflineSpecification.this.language);
                if (m != null) {
                    result.add(m);
                }
            }
            return result;
        }

        private Variable createSummaryVariable(IMethod summarizedMethod, String path, boolean isEntry) {
            if (OfflineSpecification.isUnconditionalEntry(path)) {
                String signature = path.substring(path.indexOf(91) + 1, path.indexOf(58));
                Set<IMethod> methods = this.resolveSignature(signature);
                assert (methods.size() <= 1) : "ERROR: expected full signature for unconditional entry/exit path!";
                if (methods.isEmpty()) {
                    return null;
                }
                IMethod scopeOfUnconditionalConstraint = methods.iterator().next();
                Pair P = OfflineSpecification.parsePath(path.substring(path.indexOf(58) + 1, path.indexOf(93)), scopeOfUnconditionalConstraint);
                if (isEntry) {
                    Set seeds = MapUtil.findOrCreateSet((Map)OfflineSpecification.this.method2seeds, (Object)summarizedMethod);
                    Variable seed = Variable.failOrCreate(scopeOfUnconditionalConstraint, (Integer)P.fst, (List)P.snd, this.langServices);
                    seeds.add(seed);
                    return seed;
                }
                return ViolationVariable.failOrCreate((Object)ViolationVariable.Cause.UNCONDITIONAL, scopeOfUnconditionalConstraint, null, (Integer)P.fst, (List)P.snd);
            }
            Pair P = OfflineSpecification.parsePath(path, summarizedMethod);
            if (P == null) {
                return null;
            }
            int varID = (Integer)P.fst;
            Variable result = varID == Integer.MAX_VALUE ? WildcardVariable.failOrCreate(summarizedMethod, (List)P.snd) : Variable.failOrCreate(summarizedMethod, varID, (List)P.snd, this.langServices);
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.summaryStrings == null ? 0 : this.summaryStrings.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RawSummary other = (RawSummary)obj;
            assert (this.getOuterType().equals(other.getOuterType()));
            return !(this.summaryStrings == null ? other.summaryStrings != null : !this.summaryStrings.equals(other.summaryStrings));
        }

        private OfflineSpecification getOuterType() {
            return OfflineSpecification.this;
        }
    }
}

