/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.progress;

import com.ibm.wala.util.PlatformUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JavaProcessLauncher {
    protected File workingDir = null;
    protected Map<String, String> env = null;
    private byte[] input = null;
    private String programArgs;
    private final String mainClass;
    private final boolean inheritClasspath;
    protected boolean enableAssertions;
    private final List<String> xtraClasspath = new ArrayList<String>();
    protected String javaExe;
    protected Process process;
    protected int memory;
    protected String vmArgs;

    public static JavaProcessLauncher make(String programArgs, String mainClass, List<String> classpathEntries, int memory) {
        return new JavaProcessLauncher(programArgs, "", mainClass, true, classpathEntries, memory);
    }

    public static JavaProcessLauncher make(String programArgs, String vmArgs, String mainClass, List<String> classpathEntries, int memory) {
        return new JavaProcessLauncher(programArgs, vmArgs, mainClass, true, classpathEntries, memory);
    }

    protected JavaProcessLauncher(String programArgs, String vmArgs, String mainClass, boolean inheritClasspath, List<String> xtraClasspath, int memory_) {
        this.programArgs = programArgs;
        this.vmArgs = vmArgs;
        this.mainClass = mainClass;
        this.inheritClasspath = inheritClasspath;
        if (xtraClasspath != null) {
            this.xtraClasspath.addAll(xtraClasspath);
        }
        this.javaExe = JavaProcessLauncher.defaultJavaExe();
        this.process = null;
        this.memory = memory_;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File newWorkingDir) {
        this.workingDir = newWorkingDir;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> newEnv) {
        this.env = newEnv;
    }

    protected Process spawnProcess(String cmd) throws IllegalArgumentException, IOException {
        if (cmd == null) {
            throw new IllegalArgumentException("cmd cannot be null");
        }
        String[] ev = this.getEnv() == null ? null : this.buildEnv(this.getEnv());
        Process p = Runtime.getRuntime().exec(cmd, ev, this.getWorkingDir());
        return p;
    }

    private String[] buildEnv(Map<String, String> ev) {
        String[] result = new String[ev.size()];
        int i = 0;
        for (Map.Entry<String, String> e : ev.entrySet()) {
            result[i++] = e.getKey() + "=" + e.getValue();
        }
        return result;
    }

    public byte[] getInput() {
        return this.input;
    }

    public void setInput(byte[] input) {
        this.input = input;
    }

    public String getJavaExe() {
        return this.javaExe;
    }

    public void setJavaExe(String javaExe) {
        this.javaExe = javaExe;
    }

    public void setProgramArgs(String s) {
        this.programArgs = s;
    }

    public String getProgramArgs() {
        return this.programArgs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<String> getXtraClassPath() {
        return this.xtraClasspath;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (programArgs: ");
        result.append(this.programArgs);
        result.append(", mainClass: ");
        result.append(this.mainClass);
        result.append(", xtraClasspath: ");
        result.append(this.xtraClasspath);
        result.append(')');
        return result.toString();
    }

    public static String defaultJavaExe() {
        String java = "\"" + System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java\"";
        return java;
    }

    public Process start() throws IllegalArgumentException, IOException {
        String cp = this.makeClasspath();
        String heap = " -Xmx" + this.memory + "M ";
        String signalParam = PlatformUtil.onMacOSX() ? " -Xrs " : "";
        String ea = this.enableAssertions ? " -ea " : "";
        String cmd = this.javaExe + heap + signalParam + this.vmArgs + cp + " " + ea + this.getMainClass() + " " + this.getProgramArgs();
        this.process = this.spawnProcess(cmd);
        return this.process;
    }

    public void join() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
            throw new InternalError("Internal error in JavaLauncher.join()");
        }
    }

    protected String makeClasspath() throws IOException {
        String cp;
        String string = cp = this.inheritClasspath ? System.getProperty("java.class.path") : "";
        if (this.getXtraClassPath() == null || this.getXtraClassPath().isEmpty()) {
            return " -classpath " + this.quoteStringIfNeeded(cp);
        }
        for (String cpElem : this.getXtraClassPath()) {
            cp = cp + File.pathSeparatorChar;
            cp = cp + cpElem;
        }
        return " -classpath " + this.quoteStringIfNeeded(cp);
    }

    private String quoteStringIfNeeded(String s) {
        if ((s = s.trim()).indexOf(32) == -1) {
            return s;
        }
        if (s.charAt(s.length() - 1) == '\\' && s.charAt(s.length() - 2) != '\\') {
            s = s + '\\';
        }
        return '\"' + s + '\"';
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }
}

