/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.rules;

import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.management.CodePatternGroup;
import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.andromeda.rules.management.RuleContext;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Set;

public abstract class AbstractRawTaintRule
implements IRawTaintRule {
    protected static final boolean NEW_MERGE_ALGORITHM = true;
    protected final Collection<String> sourceSignatures = HashSetFactory.make();
    protected final Collection<String> sinkSignatures = HashSetFactory.make();
    protected final Collection<String> sanitizerSignatures = HashSetFactory.make();
    protected final Collection<IMember> sources = HashSetFactory.make();
    protected final Collection<IMember> sinks = HashSetFactory.make();
    protected final Collection<IMember> sanitizers = HashSetFactory.make();
    protected final Collection<CodePatternGroup> sourceGroups = HashSetFactory.make();
    protected final Collection<CodePatternGroup> sinkGroups = HashSetFactory.make();
    protected final Collection<CodePatternGroup> sanitizerGroups = HashSetFactory.make();
    protected final Set<String> illegalPatterns = HashSetFactory.make();
    protected RuleContext context = null;
    protected Collection<IRawTaintRule> originalRules;
    protected String name = "";

    public String toString() {
        StringBuffer result = new StringBuffer(this.getName());
        result.append("\n----\n");
        result.append("sources:\n");
        for (IMember s : this.getSources()) {
            result.append("  ").append(s).append("\n");
        }
        result.append("sinks:\n");
        for (IMember s : this.getSinks()) {
            result.append("  ").append(s).append("\n");
        }
        result.append("sanitizers:\n");
        for (IMember s : this.getSanitizers()) {
            result.append("  ").append(s).append("\n");
        }
        return result.toString();
    }

    private boolean includesTaintModels(Collection<IClass> classes) {
        for (IClass c : classes) {
            if (!c.getName().toString().startsWith("Lcom/ibm/wala/model/taint")) continue;
            return true;
        }
        return false;
    }

    public boolean hasConcreteSink(Collection<IClass> concreteTypes, MethodReference mr, Language l) {
        if (SignatureUtil.containsCompatibleSignature(this.sinkSignatures, concreteTypes, (MethodReference)mr)) {
            return true;
        }
        assert (concreteTypes.size() > 0);
        IClassHierarchy cha = concreteTypes.iterator().next().getClassHierarchy();
        IMethod m = cha.resolveMethod(mr);
        return this.includesTaintModels(concreteTypes) && SignatureUtil.isCompatibleWithAny((IMethod)m, this.getSinkSignatures(), (Language)l);
    }

    public boolean hasConcreteSource(Collection<IClass> concreteTypes, MethodReference mr, Language l) {
        for (IClass c : concreteTypes) {
            if (!this.hasAllowedSpecialOrigin(c)) continue;
            return true;
        }
        if (SignatureUtil.containsCompatibleSignature(this.sourceSignatures, concreteTypes, (MethodReference)mr)) {
            return true;
        }
        assert (concreteTypes.size() > 0);
        IClassHierarchy cha = concreteTypes.iterator().next().getClassHierarchy();
        IMethod m = cha.resolveMethod(mr);
        return this.includesTaintModels(concreteTypes) && this.isCompliantWithSource(m, l);
    }

    protected boolean isCompliantWithEndpoints(IMethod src, IMethod sink, Language l) {
        if (SignatureUtil.isCompatibleWithAny((IMethod)sink, this.getSinkSignatures(), (Language)l)) {
            return this.isCompliantWithSource(src, l);
        }
        return false;
    }

    protected boolean isCompliantWithSource(IMethod src, Language l) {
        if (this.getContext().useServlet() && SignatureUtil.isCompatibleWithAny((IMethod)src, this.getSourceSignatures(), (Language)l)) {
            return true;
        }
        return this.hasAllowedSpecialOrigin(src.getDeclaringClass());
    }

    private boolean hasAllowedSpecialOrigin(IClass c) {
        return this.getContext().useStruts() && this.isStruts(c);
    }

    private boolean isStruts(IClass C) {
        for (IClass modifiableC = C; modifiableC != null; modifiableC = modifiableC.getSuperclass()) {
            if (!modifiableC.getName().toString().startsWith("Lorg/apache/struts")) continue;
            return true;
        }
        return false;
    }
}

