/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.rules;

import com.ibm.wala.andromeda.rules.AbstractRawTaintRule;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.management.CodePatternGroup;
import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.andromeda.rules.management.Method;
import com.ibm.wala.andromeda.rules.management.RuleContext;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class RawTaintRule
extends AbstractRawTaintRule
implements Serializable {
    private static final long serialVersionUID = -3256390509849384321L;
    private final int exploitability;
    private final String issueID;
    private final String ruleID;
    private final String descriptionID;
    private final String advisory;
    private final int severity;
    private final int hashCode;

    public RawTaintRule(String ruleID, RuleContext context, String name, String description, String advisory, Collection<CodePatternGroup> sourceCodePatternGroups, Collection<CodePatternGroup> sinkCodePatternGroups, Collection<CodePatternGroup> sanitizerCodePatternGroups, int exploitability, String issueID, Set<String> illegalPatterns, int severity) {
        this.ruleID = ruleID;
        this.name = name;
        this.context = context;
        this.exploitability = exploitability;
        this.issueID = issueID;
        this.descriptionID = description;
        this.advisory = advisory;
        this.severity = severity;
        this.sourceGroups.addAll(sourceCodePatternGroups);
        this.sinkGroups.addAll(sinkCodePatternGroups);
        this.sanitizerGroups.addAll(sanitizerCodePatternGroups);
        this.initMethodAndSignatureContainers(this.sourceGroups, this.sources, this.sourceSignatures);
        this.initMethodAndSignatureContainers(this.sinkGroups, this.sinks, this.sinkSignatures);
        this.initMethodAndSignatureContainers(this.sanitizerGroups, this.sanitizers, this.sanitizerSignatures);
        this.illegalPatterns.addAll(illegalPatterns);
        this.hashCode = this.computeHashCode();
    }

    public RawTaintRule(String name, Collection<String> sources, Collection<String> sinks, Collection<String> sanitizers, RuleContext context, Set<String> illegalPatterns) {
        this(name, sources, sinks, sanitizers, context);
        this.name = name;
        this.illegalPatterns.addAll(illegalPatterns);
    }

    public RawTaintRule(String ruleID, Collection<String> sourceSignatures, Collection<String> sinkSignatures, Collection<String> sanitizerSignatures, RuleContext context) {
        this(ruleID, sourceSignatures, sinkSignatures, sanitizerSignatures, context, (String)null);
    }

    public RawTaintRule(String ruleName, String ruleID, Collection<String> sourceSignatures, Collection<String> sinkSignatures, Collection<String> sanitizerSignatures, RuleContext context, String issueID) {
        this.name = ruleName;
        this.ruleID = ruleID;
        this.initializeSourcesSinksAndSanitizers(sourceSignatures, sinkSignatures, sanitizerSignatures);
        this.sourceSignatures.addAll(sourceSignatures);
        this.sinkSignatures.addAll(sinkSignatures);
        this.sanitizerSignatures.addAll(sanitizerSignatures);
        this.advisory = null;
        this.context = context;
        this.descriptionID = null;
        this.severity = -1;
        this.exploitability = -1;
        this.issueID = issueID;
        this.hashCode = this.computeHashCode();
    }

    public RawTaintRule(String ruleID, Collection<String> sourceSignatures, Collection<String> sinkSignatures, Collection<String> sanitizerSignatures, RuleContext context, String issueID) {
        this.ruleID = ruleID;
        this.initializeSourcesSinksAndSanitizers(sourceSignatures, sinkSignatures, sanitizerSignatures);
        this.sourceSignatures.addAll(sourceSignatures);
        this.sinkSignatures.addAll(sinkSignatures);
        this.sanitizerSignatures.addAll(sanitizerSignatures);
        this.context = context;
        this.descriptionID = null;
        this.advisory = null;
        this.severity = -1;
        this.exploitability = -1;
        this.issueID = issueID;
        this.hashCode = this.computeHashCode();
    }

    private void initializeSourcesSinksAndSanitizers(Collection<String> sourceSignatures, Collection<String> sinkSignatures, Collection<String> sanitizers) {
        for (String source : sourceSignatures) {
            this.sources.add(new Method(null, source, null));
        }
        for (String sink : sinkSignatures) {
            this.sinks.add(new Method(null, sink, null));
        }
        for (String sanitizer : sanitizers) {
            this.sanitizers.add(new Method(null, sanitizer, null));
        }
    }

    private void initMethodAndSignatureContainers(Collection<CodePatternGroup> methodGroups, Collection<IMember> codePatternContainer, Collection<String> patternContainer) {
        for (CodePatternGroup cpg : methodGroups) {
            codePatternContainer.addAll(cpg.getCodePatterns());
            for (IMember cp : cpg.getCodePatterns()) {
                patternContainer.add(cp.getPattern());
            }
            Collection<CodePatternGroup> subGroups = cpg.getSubGroups();
            if (subGroups == null) continue;
            this.initMethodAndSignatureContainers(subGroups, codePatternContainer, patternContainer);
        }
    }

    public Collection<IRawTaintRule> unwrap(IMethod sourceMethod, IMethod sinkMethod, Language l) {
        if (this.isCompliantWithEndpoints(sourceMethod, sinkMethod, l)) {
            return Collections.singleton(this);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasDescriptionID() {
        return this.descriptionID != null;
    }

    @Override
    public String getDescriptionID() {
        assert (this.hasDescriptionID());
        return this.descriptionID;
    }

    @Override
    public String getAdvisory() {
        assert (this.hasAdvisory());
        return this.advisory;
    }

    @Override
    public boolean hasAdvisory() {
        return this.advisory != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getID() {
        return this.ruleID;
    }

    @Override
    public String getIssueID() {
        return this.issueID;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.descriptionID == null ? 0 : this.descriptionID.hashCode());
        result = 31 * result + this.exploitability;
        result = 31 * result + (this.illegalPatterns == null ? 0 : this.illegalPatterns.hashCode());
        result = 31 * result + (this.issueID == null ? 0 : this.issueID.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ruleID == null ? 0 : this.ruleID.hashCode());
        result = 31 * result + (this.sanitizerGroups == null ? 0 : this.sanitizerGroups.hashCode());
        result = 31 * result + (this.sanitizers == null ? 0 : this.sanitizers.hashCode());
        result = 31 * result + (this.sinkGroups == null ? 0 : this.sinkGroups.hashCode());
        result = 31 * result + (this.sinks == null ? 0 : this.sinks.hashCode());
        result = 31 * result + (this.sourceGroups == null ? 0 : this.sourceGroups.hashCode());
        result = 31 * result + (this.sources == null ? 0 : this.sources.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawTaintRule other = (RawTaintRule)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.descriptionID == null ? other.descriptionID != null : !this.descriptionID.equals(other.descriptionID)) {
            return false;
        }
        if (this.exploitability != other.exploitability) {
            return false;
        }
        if (this.illegalPatterns == null ? other.illegalPatterns != null : !this.illegalPatterns.equals(other.illegalPatterns)) {
            return false;
        }
        if (this.issueID == null ? other.issueID != null : !this.issueID.equals(other.issueID)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.ruleID == null ? other.ruleID != null : !this.ruleID.equals(other.ruleID)) {
            return false;
        }
        if (this.sanitizerGroups == null ? other.sanitizerGroups != null : !this.sanitizerGroups.equals(other.sanitizerGroups)) {
            return false;
        }
        if (this.sanitizers == null ? other.sanitizers != null : !this.sanitizers.equals(other.sanitizers)) {
            return false;
        }
        if (this.sinkGroups == null ? other.sinkGroups != null : !this.sinkGroups.equals(other.sinkGroups)) {
            return false;
        }
        if (this.sinks == null ? other.sinks != null : !this.sinks.equals(other.sinks)) {
            return false;
        }
        if (this.sourceGroups == null ? other.sourceGroups != null : !this.sourceGroups.equals(other.sourceGroups)) {
            return false;
        }
        return !(this.sources == null ? other.sources != null : !this.sources.equals(other.sources));
    }

    @Override
    public int getExploitabilityLevel() {
        return this.exploitability;
    }

    @Override
    public RuleContext getContext() {
        return this.context;
    }

    @Override
    public Collection<CodePatternGroup> getSourceGroups() {
        if (this.sourceGroups != null) {
            return Collections.unmodifiableCollection(this.sourceGroups);
        }
        return null;
    }

    @Override
    public Collection<CodePatternGroup> getSinkGroups() {
        if (this.sinkGroups != null) {
            return Collections.unmodifiableCollection(this.sinkGroups);
        }
        return null;
    }

    @Override
    public Collection<CodePatternGroup> getSanitizerGroups() {
        if (this.sanitizerGroups != null) {
            return Collections.unmodifiableCollection(this.sanitizerGroups);
        }
        return this.sanitizerGroups;
    }

    @Override
    public Collection<IMember> getSources() {
        return Collections.unmodifiableCollection(this.sources);
    }

    @Override
    public Collection<IMember> getSinks() {
        return Collections.unmodifiableCollection(this.sinks);
    }

    @Override
    public Collection<IMember> getSanitizers() {
        return Collections.unmodifiableCollection(this.sanitizers);
    }

    @Override
    public Collection<String> getSanitizerSignatures() {
        return Collections.unmodifiableCollection(this.sanitizerSignatures);
    }

    @Override
    public Collection<String> getSinkSignatures() {
        return Collections.unmodifiableCollection(this.sinkSignatures);
    }

    @Override
    public Collection<String> getSourceSignatures() {
        return Collections.unmodifiableCollection(this.sourceSignatures);
    }

    @Override
    public Set<String> getIllegalPatterns() {
        return Collections.unmodifiableSet(this.illegalPatterns);
    }

    @Override
    public IRawTaintRule getTaintRule() {
        return this;
    }
}

