/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.rules.management;

import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.util.collections.Pair;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public class Method
implements Serializable,
IMember {
    private static final long serialVersionUID = -3256390509887654351L;
    private final String id;
    private final String signature;
    private final Set<Integer> interestingParameters;
    private final boolean isUserDefined;
    private final Set<String> unTaintedFields;

    public Method(String id, String signature, Pair<Set<String>, Set<Integer>> params) {
        this(id, signature, params, false);
    }

    public Method(String id, String signature, Pair<Set<String>, Set<Integer>> params, boolean isUserDefined) {
        this.id = id;
        this.signature = signature;
        this.isUserDefined = isUserDefined;
        if (params == null) {
            this.unTaintedFields = null;
            this.interestingParameters = null;
        } else {
            this.unTaintedFields = (Set)params.fst;
            this.interestingParameters = (Set)params.snd;
        }
    }

    public String getID() {
        return this.id;
    }

    public String getSignature() {
        return this.signature;
    }

    public Set<Integer> getInterestingParameters() {
        if (null == this.interestingParameters) {
            return null;
        }
        return Collections.unmodifiableSet(this.interestingParameters);
    }

    public String toString() {
        return this.signature + "@" + this.interestingParameters;
    }

    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.interestingParameters == null ? 0 : this.interestingParameters.hashCode());
        result = 31 * result + (this.isUserDefined ? 1231 : 1237);
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        result = 31 * result + (this.unTaintedFields == null ? 0 : this.unTaintedFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Method other = (Method)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.interestingParameters == null ? other.interestingParameters != null : !this.interestingParameters.equals(other.interestingParameters)) {
            return false;
        }
        if (this.isUserDefined != other.isUserDefined) {
            return false;
        }
        if (this.signature == null ? other.signature != null : !this.signature.equals(other.signature)) {
            return false;
        }
        return !(this.unTaintedFields == null ? other.unTaintedFields != null : !this.unTaintedFields.equals(other.unTaintedFields));
    }

    @Override
    public String getPattern() {
        return this.signature;
    }
}

