/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.rules.management;

import com.ibm.wala.andromeda.rules.management.TaintEntrypointType;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class RuleContext
implements Serializable {
    private static final long serialVersionUID = -3256390509887654371L;
    public static final RuleContext RegressionContext = new RuleContext();
    private Map<String, Object> attributes = HashMapFactory.make();
    public static final String CGI_ATT = "cgi";
    public static final String STRUTS_ATT = "struts";
    public static final String SPRING_ATT = "spring";
    public static final String SERVLET_ATT = "servlet";
    public static final String WEB_SERVICES_SOURCES_ATT = "webServicesSources";
    public static final String WEB_SERVICES_SINKS_ATT = "webServicesSinks";
    public static final String EXTERNAL_INTERFACES_SOURCES_ATT = "externalInterfacesSources";
    public static final String EXTERNAL_INTERFACES_SINKS_ATT = "externalInterfacesSinks";

    public boolean acceptsAny(Collection<TaintEntrypointType> entrypointTypes) {
        boolean result = false;
        for (TaintEntrypointType entrypointType : entrypointTypes) {
            if (entrypointType.equals((Object)TaintEntrypointType.CGI)) {
                result |= this.useCGI();
            } else if (entrypointType.equals((Object)TaintEntrypointType.Servlet)) {
                result |= this.useServlet();
            } else if (entrypointType.equals((Object)TaintEntrypointType.Struts)) {
                result |= this.useStruts();
            } else if (entrypointType.equals((Object)TaintEntrypointType.Spring)) {
                result |= this.useSpring();
            } else {
                throw new IllegalArgumentException();
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    public boolean acceptsAll(Collection<TaintEntrypointType> entrypointTypes) {
        boolean result = true;
        for (TaintEntrypointType entrypointType : entrypointTypes) {
            if (entrypointType.equals((Object)TaintEntrypointType.CGI)) {
                result &= this.useCGI();
            } else if (entrypointType.equals((Object)TaintEntrypointType.Servlet)) {
                result &= this.useServlet();
            } else if (entrypointType.equals((Object)TaintEntrypointType.Struts)) {
                result &= this.useStruts();
            } else if (entrypointType.equals((Object)TaintEntrypointType.Spring)) {
                result &= this.useSpring();
            } else {
                throw new IllegalArgumentException();
            }
            if (result) continue;
            break;
        }
        return result;
    }

    public void addAttribute(String attName, Object attValue) {
        assert (!this.attributes.containsKey(attName));
        this.attributes.put(attName, attValue);
    }

    public Object getAttribute(String attName) {
        if (this.attributes.containsKey(attName)) {
            return this.attributes.get(attName);
        }
        return null;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean hasAttribute(String attName) {
        return this.attributes.containsKey(attName);
    }

    public boolean useCGI() {
        return this.attributes.containsKey(CGI_ATT) && (Boolean)this.attributes.get(CGI_ATT) != false;
    }

    public boolean useStruts() {
        return this.attributes.containsKey(STRUTS_ATT) && (Boolean)this.attributes.get(STRUTS_ATT) != false;
    }

    public boolean useSpring() {
        return true;
    }

    public boolean useServlet() {
        return this.attributes.containsKey(SERVLET_ATT) && (Boolean)this.attributes.get(SERVLET_ATT) != false;
    }

    public boolean useWebServicesSources() {
        return this.attributes.containsKey(WEB_SERVICES_SOURCES_ATT) && (Boolean)this.attributes.get(WEB_SERVICES_SOURCES_ATT) != false;
    }

    public boolean useWebServicesSinks() {
        return this.attributes.containsKey(WEB_SERVICES_SINKS_ATT) && (Boolean)this.attributes.get(WEB_SERVICES_SINKS_ATT) != false;
    }

    public boolean useCallbackMethodsSources() {
        return this.attributes.containsKey(EXTERNAL_INTERFACES_SOURCES_ATT) && (Boolean)this.attributes.get(EXTERNAL_INTERFACES_SOURCES_ATT) != false;
    }

    public boolean useCallbackMethodsSinks() {
        return this.attributes.containsKey(EXTERNAL_INTERFACES_SINKS_ATT) && (Boolean)this.attributes.get(EXTERNAL_INTERFACES_SINKS_ATT) != false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleContext other = (RuleContext)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    static {
        RegressionContext.addAttribute(CGI_ATT, true);
        RegressionContext.addAttribute(STRUTS_ATT, true);
        RegressionContext.addAttribute(SPRING_ATT, true);
        RegressionContext.addAttribute(SERVLET_ATT, true);
    }
}

