/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ifa.tfidf;

import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.ifa.tfidf.TestType;
import com.ibm.appscan.ifa.tfidf.TfidfDictionary;
import com.ibm.appscan.ifa.tfidf.TfidfException;
import com.ibm.appscan.tokenizer.BaseMethodTokenizer;
import com.ibm.appscan.tokenizer.MethodAllTokenizer;
import com.ibm.appscan.tokenizer.MethodArgTokenizer;
import com.ibm.appscan.tokenizer.MethodClassTokenizer;
import com.ibm.appscan.tokenizer.MethodNameTokenizer;
import com.ibm.appscan.tokenizer.MethodReturnTokenizer;
import com.ibm.appscan.tokenizer.TokenizerException;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DictionaryWriter {
    public static void writeSuperDictionaries(List<File> files, int maxDictionarySize, boolean evenDictionaries, TestType type, File outputFile, String prefix, boolean overwrite) throws TokenizerException, VDBException, TfidfException {
        HashMap<String, List<String>> dictionaryLists = DictionaryWriter.getPreparedHashMap(type);
        try {
            if (!overwrite && DictionaryWriter.dictionariesAlreadyBuilt(dictionaryLists, outputFile, prefix)) {
                return;
            }
        }
        catch (IOException e) {
            throw new TfidfException(e);
        }
        for (File f : files) {
            Vdb v = VdbProvider.getVdb((File)f);
            for (Method m : v.getMethods()) {
                ArrayList<Object> tokenizers = new ArrayList<Object>();
                tokenizers.add(new MethodAllTokenizer());
                tokenizers.add(new MethodArgTokenizer());
                tokenizers.add(new MethodClassTokenizer());
                tokenizers.add(new MethodNameTokenizer());
                tokenizers.add(new MethodReturnTokenizer());
                for (BaseMethodTokenizer baseMethodTokenizer : tokenizers) {
                    dictionaryLists.get(DictionaryWriter.getDictionaryFile(type, m, baseMethodTokenizer)).add(baseMethodTokenizer.getTokenSentence((Object)m));
                }
            }
        }
        dictionaryLists = DictionaryWriter.cleanDictionaryLists(dictionaryLists, maxDictionarySize, evenDictionaries);
        try {
            DictionaryWriter.saveDictionaries(dictionaryLists, outputFile, prefix);
        }
        catch (IOException e) {
            throw new TfidfException(e);
        }
    }

    public static void writeDictionaries(File file, int maxDictionarySize, boolean evenDictionaries, TestType type, File outputFile, boolean overwrite) throws TfidfException, TokenizerException, VDBException {
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        String prefix = file.toString().substring(file.toString().lastIndexOf(File.separator) + 1, file.toString().length());
        DictionaryWriter.writeSuperDictionaries(files, maxDictionarySize, evenDictionaries, type, outputFile, prefix, overwrite);
    }

    private static boolean dictionariesAlreadyBuilt(HashMap<String, List<String>> dictionaryLists, File outputFile, String prefix) throws IOException {
        for (String s : dictionaryLists.keySet()) {
            if (PathUtil.getSanitizedFile((String)outputFile.toString(), (String)(prefix + s)).exists()) continue;
            return false;
        }
        return true;
    }

    private static void saveDictionaries(HashMap<String, List<String>> dictionaryLists, File outputFile, String prefix) throws TfidfException, IOException {
        for (String s : dictionaryLists.keySet()) {
            TfidfDictionary sourceDictionary = new TfidfDictionary(dictionaryLists.get(s));
            sourceDictionary.save(PathUtil.getSanitizedFile((String)outputFile.toString(), (String)(prefix + s)));
        }
    }

    private static HashMap<String, List<String>> cleanDictionaryLists(HashMap<String, List<String>> dictionaryLists, int maxDictionarySize, boolean evenDictionaries) {
        if (evenDictionaries) {
            int smallestSize = dictionaryLists.get(dictionaryLists.keySet().toArray()[0]).size();
            for (List<String> list : dictionaryLists.values()) {
                if (list.size() >= smallestSize) continue;
                smallestSize = list.size();
            }
            for (List<String> list : dictionaryLists.values()) {
                while (list.size() > smallestSize && list.size() > maxDictionarySize) {
                    list.remove(list.size() - 1);
                }
            }
        } else {
            for (List<String> list : dictionaryLists.values()) {
                while (list.size() > maxDictionarySize) {
                    list.remove(list.size() - 1);
                }
            }
        }
        return dictionaryLists;
    }

    private static String getDictionaryFile(TestType type, Method m, BaseMethodTokenizer tokenizer) {
        switch (type) {
            case SOURCE_YES_NO_TFIDF_AVG: {
                return DictionaryWriter.getDictionaryFilesSourceYesNo(m, tokenizer);
            }
            case SOURCE_YES_NO_COS_SIM_AVG: {
                return DictionaryWriter.getDictionaryFilesSourceYesNo(m, tokenizer);
            }
            case SOURCE_YES_NO_COS_SIM_BEST: {
                return DictionaryWriter.getDictionaryFilesSourceYesNo(m, tokenizer);
            }
        }
        return null;
    }

    private static String getDictionaryFilesSourceYesNo(Method m, BaseMethodTokenizer tokenizer) {
        if (DictionaryWriter.getDecisionSourceYesNo(m)) {
            if (tokenizer instanceof MethodAllTokenizer) {
                return "allsourceyes.dict";
            }
            if (tokenizer instanceof MethodArgTokenizer) {
                return "argsourceyes.dict";
            }
            if (tokenizer instanceof MethodClassTokenizer) {
                return "classsourceyes.dict";
            }
            if (tokenizer instanceof MethodNameTokenizer) {
                return "namesourceyes.dict";
            }
            if (tokenizer instanceof MethodReturnTokenizer) {
                return "returnsourceyes.dict";
            }
        } else {
            if (tokenizer instanceof MethodAllTokenizer) {
                return "allsourceno.dict";
            }
            if (tokenizer instanceof MethodArgTokenizer) {
                return "argsourceno.dict";
            }
            if (tokenizer instanceof MethodClassTokenizer) {
                return "classsourceno.dict";
            }
            if (tokenizer instanceof MethodNameTokenizer) {
                return "namesourceno.dict";
            }
            if (tokenizer instanceof MethodReturnTokenizer) {
                return "returnsourceno.dict";
            }
        }
        return null;
    }

    private static boolean getDecisionSourceYesNo(Method m) {
        return m.getSources().size() > 0;
    }

    private static HashMap<String, List<String>> getPreparedHashMap(TestType type) {
        switch (type) {
            case SOURCE_YES_NO_TFIDF_AVG: {
                return DictionaryWriter.getPreparedHashMapYesNo();
            }
            case SOURCE_YES_NO_COS_SIM_AVG: {
                return DictionaryWriter.getPreparedHashMapYesNo();
            }
            case SOURCE_YES_NO_COS_SIM_BEST: {
                return DictionaryWriter.getPreparedHashMapYesNo();
            }
        }
        return null;
    }

    private static HashMap<String, List<String>> getPreparedHashMapYesNo() {
        HashMap<String, List<String>> dictionaryLists = new HashMap<String, List<String>>();
        dictionaryLists.put("allsourceyes.dict", new ArrayList());
        dictionaryLists.put("allsourceno.dict", new ArrayList());
        dictionaryLists.put("argsourceyes.dict", new ArrayList());
        dictionaryLists.put("argsourceno.dict", new ArrayList());
        dictionaryLists.put("classsourceyes.dict", new ArrayList());
        dictionaryLists.put("classsourceno.dict", new ArrayList());
        dictionaryLists.put("namesourceyes.dict", new ArrayList());
        dictionaryLists.put("namesourceno.dict", new ArrayList());
        dictionaryLists.put("returnsourceyes.dict", new ArrayList());
        dictionaryLists.put("returnsourceno.dict", new ArrayList());
        return dictionaryLists;
    }
}

