/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ifa.tfidf;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.ifa.tfidf.DictionaryWriter;
import com.ibm.appscan.ifa.tfidf.TestType;
import com.ibm.appscan.ifa.tfidf.TfidfCalculator;
import com.ibm.appscan.ifa.tfidf.TfidfDictionary;
import com.ibm.appscan.ifa.tfidf.TfidfException;
import com.ibm.appscan.ifa.tfidf.TrainingAndTestSetWriter;
import com.ibm.appscan.tokenizer.MethodAllTokenizer;
import com.ibm.appscan.tokenizer.TokenizerException;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class TfidfMarkupRunner {
    private static String m_trainingSetPath = CommonCore.getDirectoryLocator().getMl() + "/tfidf/testsets/";
    private static String m_dictionariesPath = CommonCore.getDirectoryLocator().getMl() + "/tfidf/dictionaries/";
    private static String m_testSetsPath = CommonCore.getDirectoryLocator().getMl() + "/tfidf/testsets/";

    public static void main(String[] arg) throws TokenizerException, VDBException, TfidfException {
        try {
            TfidfMarkupRunner.writeSuperDictionaries();
        }
        catch (IOException e) {
            throw new TfidfException(e);
        }
    }

    public static void runSuperDictionaryTest() throws TokenizerException, VDBException, TfidfException {
        try {
            TfidfMarkupRunner.writeSuperDictionaries();
        }
        catch (IOException e) {
            throw new TfidfException(e);
        }
    }

    public static void runYesNoTest(File originalVdbFile, TestType type) throws TokenizerException, VDBException, TfidfException, IOException {
        System.out.println("---");
        System.out.println("Running " + (Object)((Object)type) + " test on: " + originalVdbFile);
        File trainingSetPath = TfidfMarkupRunner.getTrainingSetPath(originalVdbFile);
        File testSetPath = TfidfMarkupRunner.getTestSetPath(originalVdbFile);
        File dictionaryPath = TfidfMarkupRunner.getDictionaryPath(trainingSetPath);
        String prefix = trainingSetPath.toString().substring(trainingSetPath.toString().lastIndexOf(File.separator) + 1, trainingSetPath.toString().length());
        TrainingAndTestSetWriter.writeTrainingAndTestSet(originalVdbFile);
        System.out.println("Training Set Size: " + VdbProvider.getVdb((File)trainingSetPath).getMethods().size());
        System.out.println("Test Set Size: " + VdbProvider.getVdb((File)testSetPath).getMethods().size());
        DictionaryWriter.writeDictionaries(trainingSetPath, 100, false, type, dictionaryPath, false);
        for (TOKENIZER_TYPE tokenizerType : TOKENIZER_TYPE.values()) {
            System.out.println("METHOD_" + (Object)((Object)tokenizerType) + "_SOURCE_YES");
            File sourceYesPath = TfidfMarkupRunner.getSourceYesPath(dictionaryPath, prefix, tokenizerType);
            File sourceNoPath = TfidfMarkupRunner.getSourceNoPath(dictionaryPath, prefix, tokenizerType);
            TfidfDictionary yesDictionary = new TfidfDictionary(sourceYesPath);
            TfidfDictionary noDictionary = new TfidfDictionary(sourceNoPath);
            System.out.println("Yes Dictionary Size: " + yesDictionary.getNumDocuments());
            System.out.println("No Dictionary Size: " + noDictionary.getNumDocuments());
            Vdb v = VdbProvider.getVdb((File)testSetPath);
            TfidfCalculator yesCalc = new TfidfCalculator(yesDictionary);
            TfidfCalculator noCalc = new TfidfCalculator(noDictionary);
            int good = 0;
            int bad = 0;
            int truePositive = 0;
            int falsePositive = 0;
            int trueNegative = 0;
            int falseNegative = 0;
            Iterator iterator = v.getMethods().iterator();
            while (iterator.hasNext()) {
                MethodAllTokenizer t = new MethodAllTokenizer();
                Method m = (Method)iterator.next();
                String token = t.getTokenSentence((Object)m);
                boolean prediction = TfidfMarkupRunner.getCalculation(yesCalc, token, type) > TfidfMarkupRunner.getCalculation(noCalc, token, type);
                boolean actual = TfidfMarkupRunner.getActualYesNo(m, type);
                if (prediction) {
                    if (actual) {
                        ++truePositive;
                        ++good;
                        continue;
                    }
                    ++falsePositive;
                    ++bad;
                    continue;
                }
                if (actual) {
                    ++falseNegative;
                    ++bad;
                    continue;
                }
                ++trueNegative;
                ++good;
            }
            System.out.println("good: " + good);
            System.out.println("bad: " + bad);
            System.out.println("True Positive: " + truePositive);
            System.out.println("False Positive: " + falsePositive);
            System.out.println("True Negative: " + trueNegative);
            System.out.println("False Negative: " + falseNegative);
            System.out.println("---");
        }
    }

    private static File getSourceYesPath(File dictionaryPath, String prefix, TOKENIZER_TYPE tokenizerType) throws IOException {
        switch (tokenizerType) {
            case ALL: {
                return TfidfMarkupRunner.getMethodAllSourceYesPath(dictionaryPath, prefix);
            }
            case ARG: {
                return TfidfMarkupRunner.getMethodArgSourceYesPath(dictionaryPath, prefix);
            }
            case CLASS: {
                return TfidfMarkupRunner.getMethodClassSourceYesPath(dictionaryPath, prefix);
            }
            case NAME: {
                return TfidfMarkupRunner.getMethodNameSourceYesPath(dictionaryPath, prefix);
            }
            case RETURN: {
                return TfidfMarkupRunner.getMethodReturnSourceYesPath(dictionaryPath, prefix);
            }
        }
        return null;
    }

    private static File getSourceNoPath(File dictionaryPath, String prefix, TOKENIZER_TYPE tokenizerType) throws IOException {
        switch (tokenizerType) {
            case ALL: {
                return TfidfMarkupRunner.getMethodAllSourceNoPath(dictionaryPath, prefix);
            }
            case ARG: {
                return TfidfMarkupRunner.getMethodArgSourceNoPath(dictionaryPath, prefix);
            }
            case CLASS: {
                return TfidfMarkupRunner.getMethodClassSourceNoPath(dictionaryPath, prefix);
            }
            case NAME: {
                return TfidfMarkupRunner.getMethodNameSourceNoPath(dictionaryPath, prefix);
            }
            case RETURN: {
                return TfidfMarkupRunner.getMethodReturnSourceNoPath(dictionaryPath, prefix);
            }
        }
        return null;
    }

    public static boolean getActualYesNo(Method m, TestType type) {
        switch (type) {
            case SOURCE_YES_NO_TFIDF_AVG: {
                return TfidfMarkupRunner.getActualYesNoSourceYesNo(m, type);
            }
            case SOURCE_YES_NO_COS_SIM_AVG: {
                return TfidfMarkupRunner.getActualYesNoSourceYesNo(m, type);
            }
            case SOURCE_YES_NO_COS_SIM_BEST: {
                return TfidfMarkupRunner.getActualYesNoSourceYesNo(m, type);
            }
        }
        return false;
    }

    public static boolean getActualYesNoSourceYesNo(Method m, TestType type) {
        return m.getSources().size() > 0;
    }

    public static double getCalculation(TfidfCalculator calc, String token, TestType type) {
        switch (type) {
            case SOURCE_YES_NO_TFIDF_AVG: {
                return calc.calcAverageTFIDF(token);
            }
            case SOURCE_YES_NO_COS_SIM_AVG: {
                return calc.calcAverageCosineSimilarity(token);
            }
            case SOURCE_YES_NO_COS_SIM_BEST: {
                return calc.calcHighestCosineSimilarity(token);
            }
        }
        return 0.0;
    }

    private static File getTrainingSetPath(File originalVdbFile) throws IOException {
        String intermediatePath = originalVdbFile.getParentFile().getAbsolutePath().substring(CommonCore.getDirectoryLocator().getVdb().length() - 1) + File.separator;
        String trainingSetFileName = originalVdbFile.getName().substring(0, originalVdbFile.getName().lastIndexOf(46)) + "90.vdb";
        return PathUtil.getSanitizedFile((String)(m_testSetsPath + intermediatePath), (String)trainingSetFileName);
    }

    private static File getTestSetPath(File originalVdbFile) throws IOException {
        String intermediatePath = originalVdbFile.getParentFile().getAbsolutePath().substring(CommonCore.getDirectoryLocator().getVdb().length() - 1) + File.separator;
        String testSetFileName = originalVdbFile.getName().substring(0, originalVdbFile.getName().lastIndexOf(46)) + "10.vdb";
        return PathUtil.getSanitizedFile((String)(m_testSetsPath + intermediatePath), (String)testSetFileName);
    }

    @SuppressSecurityTrace
    private static File getDictionaryPath(File trainingVdbFile) {
        return new File(m_dictionariesPath + trainingVdbFile.getParentFile().getAbsolutePath().substring(m_trainingSetPath.length() - 1) + File.separator);
    }

    private static void writeSuperDictionaries() throws TokenizerException, VDBException, TfidfException, IOException {
        ArrayList<File> vdbFiles = new ArrayList<File>();
        vdbFiles.add(PathUtil.getSanitizedFile((String)(CommonCore.getDirectoryLocator().getVdb() + File.separator + "factory" + File.separator + "java" + File.separator + "java" + File.separator + "util" + File.separator), (String)"java.util.vdb"));
        vdbFiles.add(PathUtil.getSanitizedFile((String)(CommonCore.getDirectoryLocator().getVdb() + File.separator + "factory" + File.separator + "java" + File.separator + "java" + File.separator + "lang"), (String)"java.lang.vdb"));
        vdbFiles.add(PathUtil.getSanitizedFile((String)(CommonCore.getDirectoryLocator().getVdb() + File.separator + "factory" + File.separator + "java" + File.separator + "java" + File.separator + "io" + File.separator), (String)"java.io.vdb"));
        File outputFile = new File(m_dictionariesPath + "/super/");
        String prefix = "super";
        DictionaryWriter.writeSuperDictionaries(vdbFiles, 100, false, TestType.SOURCE_YES_NO_COS_SIM_BEST, outputFile, prefix, false);
    }

    private static File getMethodAllSourceYesPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "allsourceyes.dict"));
    }

    private static File getMethodAllSourceNoPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "allsourceno.dict"));
    }

    private static File getMethodArgSourceYesPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "argsourceyes.dict"));
    }

    private static File getMethodArgSourceNoPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "argsourceno.dict"));
    }

    private static File getMethodClassSourceYesPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "classsourceyes.dict"));
    }

    private static File getMethodClassSourceNoPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "classsourceno.dict"));
    }

    private static File getMethodNameSourceYesPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "classsourceyes.dict"));
    }

    private static File getMethodNameSourceNoPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "namesourceno.dict"));
    }

    private static File getMethodReturnSourceYesPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "namesourceyes.dict"));
    }

    private static File getMethodReturnSourceNoPath(File outputPath, String prefix) throws IOException {
        return PathUtil.getSanitizedFile((String)outputPath.toString(), (String)(prefix + "namesourceno.dict"));
    }

    private static enum TOKENIZER_TYPE {
        ALL,
        ARG,
        CLASS,
        NAME,
        RETURN;

    }
}

