/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.eclipse;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.discovery.eclipse.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class EclipseRunner {
    private ProcessRunner m_builder;

    public EclipseRunner(File workspace) {
        this(workspace, null);
    }

    public EclipseRunner(File workspace, String project) {
        if (workspace != null && this.getEclipse() != null) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.getEclipse());
            args.add("-nosplash");
            args.add("-application");
            args.add("com.ibm.appscan.discovery.eclipse.reader.application");
            args.add("-data");
            args.add(workspace.getAbsolutePath());
            if (project != null) {
                args.add(project);
            }
            this.m_builder = new ProcessRunner(args);
        } else {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("workspace.invalid.error", workspace)));
        }
    }

    public Properties run() throws AppScanException {
        try {
            final Properties props = new Properties();
            this.m_builder.run(new ProcessRunner.StreamHandler(){

                protected boolean handle(BufferedReader reader) throws IOException {
                    props.load(reader);
                    return super.handle(reader);
                }
            }, new ProcessRunner.StreamHandler(){

                protected boolean handle(BufferedReader reader) throws IOException {
                    props.load(reader);
                    return super.handle(reader);
                }
            });
            return props;
        }
        catch (IOException e) {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("error.eclipse.runner", e.getLocalizedMessage())));
            throw new AppScanException((Throwable)e);
        }
    }

    private String getEclipse() {
        Properties props = new Properties();
        try {
            props.load(new FileReader(CommonCore.getDirectoryLocator().getConfig() + "eclipse.properties"));
        }
        catch (Exception e) {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("file.read.error", CommonCore.getDirectoryLocator().getConfig() + "eclipse.properties")));
        }
        return props.getProperty("eclipse");
    }
}

