/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.ruby.gem;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.discovery.ruby.IRubyConstants;
import com.ibm.appscan.discovery.ruby.Messages;
import java.io.File;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;

public class GemStrategy
extends CrawlingStrategy
implements IRubyConstants {
    private File m_gem;
    private File m_crawlRoot;
    protected static final String UNPACK_DIR = "unpack";

    public GemStrategy() {
    }

    GemStrategy(File gem) {
        this.m_gem = gem;
        this.init(gem, null);
    }

    public boolean stageScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        this.m_crawlRoot = new File(proxy.getWorkingDirectory(), UNPACK_DIR);
        ScriptingContainer container = new ScriptingContainer(LocalVariableBehavior.PERSISTENT);
        container.setCurrentDirectory(this.m_crawlRoot.getAbsolutePath());
        container.put("gemfile", (Object)this.m_gem.getAbsolutePath());
        container.runScriptlet("require 'rubygems/commands/unpack_command'");
        container.runScriptlet("Gem::Commands::UnpackCommand.new.invoke gemfile");
        container.terminate();
        if (this.m_crawlRoot.list().length <= 0) {
            proxy.getErrorManager().reportError(Messages.getMessage("error.unpacking.gem", this.m_gem.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public String getName() {
        return this.m_gem.getName();
    }

    public String getType() {
        return "ruby_gem";
    }

    public String getLanguageType() {
        return "ruby";
    }

    protected String[] getCategories(IBuildInfo buildInfo) {
        return new String[]{"category.ruby"};
    }

    public String getPath() {
        return this.m_gem.getAbsolutePath();
    }

    public File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.m_crawlRoot;
    }
}

