/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.internal.Parser;

public class OrderedJSONObject
extends JSONObject {
    private static final long serialVersionUID = -3269263069889337299L;
    private ArrayList order = new ArrayList();

    public OrderedJSONObject() {
    }

    public OrderedJSONObject(String string) throws JSONException {
        StringReader stringReader = new StringReader(string);
        new Parser(stringReader).parse(true, this);
    }

    public OrderedJSONObject(String string, boolean bl) throws JSONException {
        StringReader stringReader = new StringReader(string);
        new Parser(stringReader, bl).parse(true, this);
    }

    public OrderedJSONObject(Reader reader) throws JSONException {
        new Parser(reader).parse(true, this);
    }

    public OrderedJSONObject(Reader reader, boolean bl) throws JSONException {
        new Parser(reader, bl).parse(true, this);
    }

    public OrderedJSONObject(InputStream inputStream) throws JSONException {
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (Exception exception) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
        } else {
            throw new JSONException("Inputstream cannot be null");
        }
        new Parser(inputStreamReader).parse(true, this);
    }

    public OrderedJSONObject(InputStream inputStream, boolean bl) throws JSONException {
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (Exception exception) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
        } else {
            throw new JSONException("Inputstream cannot be null");
        }
        new Parser(inputStreamReader, bl).parse(true, this);
    }

    public OrderedJSONObject(Map map) throws JSONException {
        Iterator iterator;
        Set set = map.keySet();
        if (set != null && (iterator = set.iterator()) != null) {
            while (iterator.hasNext()) {
                Object k = iterator.next();
                String string = k.toString();
                this.put(string, map.get(k));
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (null == object) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!OrderedJSONObject.isValidObject(object2)) {
            if (object2 != null) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + object2.getClass().getName() + "] with value: [" + object2.toString() + "]");
            }
            throw new IllegalArgumentException("Invalid type of value.");
        }
        if (!this.containsKey(object)) {
            this.order.add(object);
        }
        return super.put(object, object2);
    }

    public Object remove(Object object) {
        Object var2_2 = null;
        if (null == object) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.containsKey(object)) {
            var2_2 = super.remove(object);
            for (int i = 0; i < this.order.size(); ++i) {
                Object e = this.order.get(i);
                if (!e.equals(object)) continue;
                this.order.remove(i);
                break;
            }
        }
        return var2_2;
    }

    public void clear() {
        super.clear();
        this.order.clear();
    }

    public Object clone() {
        OrderedJSONObject orderedJSONObject = (OrderedJSONObject)super.clone();
        Iterator iterator = orderedJSONObject.getOrder();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
            orderedJSONObject.order = arrayList;
        }
        return orderedJSONObject;
    }

    public Iterator getOrder() {
        return this.order.iterator();
    }
}

