/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.dotnet.translator;

import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSALoadIndirectInstruction;
import com.ibm.wala.ssa.SSAStoreIndirectInstruction;
import com.ibm.wala.stringAnalysis.dotnet.ssa.SADotnetInstructionVisitor;
import com.ibm.wala.stringAnalysis.grammar.GRule;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.ssa.SAInstructionVisitor;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.SSA2Rule;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DotnetSSA2Rule<T>
extends SSA2Rule<T> {
    public DotnetSSA2Rule(ISymbolFactory<T> symbolFactory, boolean ignoreField) {
        super(symbolFactory, ignoreField);
    }

    public DotnetSSA2Rule(ISymbolFactory<T> symbolFactory) {
        super(symbolFactory);
    }

    protected SAInstructionVisitor createTranslatorVisitor(TranslationContext ctx, Collection<GRule> rules) {
        return new SADotnetInstructionVisitor(new DotnetTranslatingProcessor(ctx, rules));
    }

    protected void translateInvokeInstruction(SSAAbstractInvokeInstruction instruction, TranslationContext ctx, Collection<GRule> rules) {
        MethodReference mref = instruction.getDeclaredTarget();
        TypeReference typeRef = mref.getDeclaringClass();
        if (typeRef.getClassLoader().equals((Object)ClassLoaderReference.Primordial)) {
            return;
        }
        Collection<GRule> rs = this.translateSubstringIndexPair(instruction, ctx);
        if (rs == null) {
            super.translateInvokeInstruction(instruction, ctx, rules);
        } else {
            rules.addAll(rs);
        }
    }

    private Collection<GRule> translateSubstringIndexPair(SSAAbstractInvokeInstruction instruction, TranslationContext ctx) {
        HashSet<GRule> rs = new HashSet<GRule>();
        ISymbolFactory sf = this.getSymbolFactory();
        ITranslatorRepository repository = sf.getRepository();
        Set sigs = repository.getSignature(instruction, ctx);
        for (String sig : sigs) {
            if (sig.equals("java.lang.String.substring(II)Ljava/lang/String;")) {
                SSAInstruction idxInst = ctx.getDefUse().getDef(instruction.getUse(2));
                if (idxInst instanceof SSAAbstractInvokeInstruction) {
                    SSAAbstractInvokeInstruction invokeInst = (SSAAbstractInvokeInstruction)idxInst;
                    Set sigs2 = repository.getSignature(invokeInst, ctx);
                    for (String sig2 : sigs2) {
                        if (sig2.equals("java.lang.String.indexOf(Ljava/lang/String;)I")) {
                            int i;
                            Collection lv = sf.createCDVariable(instruction.getDef(), ctx);
                            String signature = sig + sig2;
                            int[] params1 = repository.getParams(instruction, ctx);
                            int[] params2 = repository.getParams(invokeInst, ctx);
                            int[] params3 = new int[params1.length + params2.length];
                            int n = 0;
                            for (i = 0; i < params1.length; ++i) {
                                params3[n] = params1[i];
                                ++n;
                            }
                            for (i = 0; i < params2.length; ++i) {
                                params3[n] = params2[i];
                                ++n;
                            }
                            HashSet invokeSymbol = new HashSet(sf.createInvocationSymbol(new SignatureSymbol(signature), instruction.getReceiver(), params3, (SSAInstruction)instruction, ctx));
                            ArrayList rparams = new ArrayList();
                            rparams.add(invokeSymbol);
                            rs.addAll(this.createRules(ctx.getIR(), (SSAInstruction)instruction, lv, rparams));
                            continue;
                        }
                        return null;
                    }
                    continue;
                }
                return null;
            }
            return null;
        }
        return rs;
    }

    protected class DotnetTranslatingProcessor
    extends SSA2Rule.BaseTranslatingProcessor
    implements SADotnetInstructionVisitor.Processor {
        public DotnetTranslatingProcessor(TranslationContext ctx, Collection<GRule> rules) {
            super((SSA2Rule)DotnetSSA2Rule.this, ctx, rules);
        }

        @Override
        public void onAddressOf(SSAAddressOfInstruction instruction) {
        }

        @Override
        public void onLoadIndirect(SSALoadIndirectInstruction instruction) {
        }

        @Override
        public void onStoreIndirect(SSAStoreIndirectInstruction instruction) {
        }
    }
}

