/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.rust;

import com.hcl.appscan.discovery.rust.IRustConstants;
import com.hcl.appscan.internal.discovery.rust.RustStrategy;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RustCollector
extends BaseCustomCollector
implements IRustConstants {
    private static final List<String> m_excludedDirectories = Arrays.asList("test", "tests", "example", "examples");
    private static final List<String> m_excludedFiles = Arrays.asList("package.json", "package-lock.json", "composer.json");
    private static final List<String> m_tauriConfigFiles = Arrays.asList("tauri.conf.json", "tauri.conf.json5", "tauri.windows.conf.json", "tauri.macos.conf.json", "tauri.linux.conf.json");
    private static final String TAURI_PATTERN = "\"tauri\"\\s*:\\s*\\{";

    public RustCollector(File crawlRoot, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(crawlRoot, includes, excludes);
    }

    public String getType() {
        return "RustCollector";
    }

    protected String getFileExtensionSetName() {
        return "rust";
    }

    protected boolean acceptFile(File file) {
        String[] subDirs = file.toString().toLowerCase().split(Pattern.quote(File.separator));
        if (!Collections.disjoint(m_excludedDirectories, Arrays.asList(subDirs))) {
            return false;
        }
        if (m_excludedFiles.contains(file.getName().toLowerCase()) || file.getName().toLowerCase().endsWith(".deps.json")) {
            return false;
        }
        String extension = FileUtil.getFileExtension((File)file);
        if ((extension.equalsIgnoreCase("json") || extension.equalsIgnoreCase("json5")) && !this.isTauriConfigFile(file)) {
            return false;
        }
        return super.acceptFile(file);
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        return new RustStrategy(this.getCrawlRoot(), this.getScanFiles());
    }

    private boolean isTauriConfigFile(File file) {
        if (m_tauriConfigFiles.contains(file.getName().toLowerCase())) {
            return true;
        }
        try {
            String fileContents = IOUtil.readFileIntoString((File)file);
            Matcher matcher = Pattern.compile(TAURI_PATTERN).matcher(fileContents);
            return matcher.find();
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
            return false;
        }
    }
}

