/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.analysis.typeInference.TypeVariable;
import com.ibm.wala.cast.analysis.typeInference.AstTypeInference;
import com.ibm.wala.cast.js.ssa.JSInstructionVisitor;
import com.ibm.wala.cast.js.ssa.JavaScriptCheckReference;
import com.ibm.wala.cast.js.ssa.JavaScriptInstanceOf;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyRead;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyWrite;
import com.ibm.wala.cast.js.ssa.JavaScriptTypeOfInstruction;
import com.ibm.wala.cast.js.ssa.JavaScriptWithRegion;
import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.cast.js.ssa.SetPrototype;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.dataflow.ssa.SSAInference;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public class JSTypeInference
extends AstTypeInference {
    public JSTypeInference(IR ir, IClassHierarchy cha) {
        super(ir, cha, (TypeAbstraction)new PointType(cha.lookupClass(JavaScriptTypes.Boolean)), true);
    }

    protected void initialize() {
        class JSTypeVarFactory
        extends TypeInference.TypeVarFactory {
            JSTypeVarFactory() {
                super((TypeInference)JSTypeInference.this);
            }

            private TypeAbstraction make(TypeReference typeRef) {
                return new PointType(JSTypeInference.this.cha.lookupClass(typeRef));
            }

            public IVariable makeVariable(int vn) {
                if (JSTypeInference.this.ir.getSymbolTable().isStringConstant(vn)) {
                    return new TypeVariable(this.make(JavaScriptTypes.String));
                }
                if (JSTypeInference.this.ir.getSymbolTable().isBooleanConstant(vn)) {
                    return new TypeVariable(this.make(JavaScriptTypes.Boolean));
                }
                if (JSTypeInference.this.ir.getSymbolTable().isNullConstant(vn)) {
                    return new TypeVariable(this.make(JavaScriptTypes.Null));
                }
                if (JSTypeInference.this.ir.getSymbolTable().isNumberConstant(vn)) {
                    return new TypeVariable(this.make(JavaScriptTypes.Number));
                }
                return super.makeVariable(vn);
            }
        }
        class JSTypeOperatorFactory
        extends AstTypeInference.AstTypeOperatorFactory
        implements JSInstructionVisitor {
            JSTypeOperatorFactory() {
                super((AstTypeInference)JSTypeInference.this);
            }

            @Override
            public void visitJavaScriptInvoke(JavaScriptInvoke inst) {
                this.result = new TypeInference.DeclaredTypeOperator((TypeAbstraction)new ConeType(JSTypeInference.this.cha.getRootClass()));
            }

            @Override
            public void visitJavaScriptPropertyRead(JavaScriptPropertyRead inst) {
                this.result = new TypeInference.DeclaredTypeOperator((TypeAbstraction)new ConeType(JSTypeInference.this.cha.getRootClass()));
            }

            @Override
            public void visitTypeOf(JavaScriptTypeOfInstruction inst) {
                this.result = new TypeInference.DeclaredTypeOperator((TypeAbstraction)new PointType(JSTypeInference.this.cha.lookupClass(JavaScriptTypes.String)));
            }

            @Override
            public void visitJavaScriptInstanceOf(JavaScriptInstanceOf inst) {
                this.result = new TypeInference.DeclaredTypeOperator((TypeAbstraction)new PointType(JSTypeInference.this.cha.lookupClass(JavaScriptTypes.Boolean)));
            }

            @Override
            public void visitJavaScriptPropertyWrite(JavaScriptPropertyWrite inst) {
            }

            @Override
            public void visitCheckRef(JavaScriptCheckReference instruction) {
            }

            @Override
            public void visitWithRegion(JavaScriptWithRegion instruction) {
            }

            @Override
            public void visitSetPrototype(SetPrototype instruction) {
            }

            @Override
            public void visitPrototypeLookup(PrototypeLookup instruction) {
                this.result = new TypeInference.DeclaredTypeOperator((TypeAbstraction)new ConeType(JSTypeInference.this.cha.getRootClass()));
            }
        }
        this.init(this.ir, (SSAInference.VariableFactory)new JSTypeVarFactory(), (SSAInference.OperatorFactory)new JSTypeOperatorFactory());
    }

    public TypeAbstraction getConstantType(int valueNumber) {
        SymbolTable st = this.ir.getSymbolTable();
        if (st.isStringConstant(valueNumber)) {
            return new PointType(this.cha.lookupClass(JavaScriptTypes.String));
        }
        if (st.isBooleanConstant(valueNumber)) {
            return new PointType(this.cha.lookupClass(JavaScriptTypes.Boolean));
        }
        if (st.isNullConstant(valueNumber)) {
            return new PointType(this.cha.lookupClass(JavaScriptTypes.Null));
        }
        return new PointType(this.cha.lookupClass(JavaScriptTypes.Number));
    }
}

