/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices;

import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.ArgVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.CallVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.CreationSiteVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.FuncVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.GlobalVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.LexicalVarVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.ParamVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.PropVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.RetVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.UnknownVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VarVertex;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.Map;

public class VertexFactory {
    private final Map<Pair<FuncVertex, CallSiteReference>, CallVertex> callVertexCache = HashMapFactory.make();
    private final Map<IClass, FuncVertex> funcVertexCache = HashMapFactory.make();
    private final Map<Pair<FuncVertex, Integer>, ParamVertex> paramVertexCache = HashMapFactory.make();
    private final Map<String, PropVertex> propVertexCache = HashMapFactory.make();
    private final Map<FuncVertex, RetVertex> retVertexCache = HashMapFactory.make();
    private final Map<FuncVertex, ArgVertex> argVertexCache = HashMapFactory.make();
    private final Map<Pair<FuncVertex, Integer>, VarVertex> varVertexCache = HashMapFactory.make();
    private final Map<Pair<String, String>, LexicalVarVertex> lexicalAccessVertexCache = HashMapFactory.make();
    private final Map<Pair<IMethod, Integer>, CreationSiteVertex> creationSites = HashMapFactory.make();
    private GlobalVertex global = GlobalVertex.instance();

    public CallVertex makeCallVertex(FuncVertex func, JavaScriptInvoke invk) {
        CallSiteReference site = invk.getCallSite();
        Pair key = Pair.make((Object)func, (Object)site);
        CallVertex value = this.callVertexCache.get(key);
        if (value == null) {
            value = new CallVertex(func, site, invk);
            this.callVertexCache.put((Pair<FuncVertex, CallSiteReference>)key, value);
        }
        return value;
    }

    public Iterable<CallVertex> getCallVertices() {
        return this.callVertexCache.values();
    }

    public CreationSiteVertex makeCreationSiteVertex(IMethod method, int instruction, TypeReference createdType) {
        Pair key = Pair.make((Object)method, (Object)instruction);
        CreationSiteVertex value = this.creationSites.get(key);
        if (value == null) {
            value = new CreationSiteVertex(method, instruction, createdType);
            this.creationSites.put((Pair<IMethod, Integer>)key, value);
        }
        return value;
    }

    public Collection<CreationSiteVertex> creationSites() {
        return this.creationSites.values();
    }

    public FuncVertex makeFuncVertex(IClass klass) {
        FuncVertex value = this.funcVertexCache.get(klass);
        if (value == null) {
            value = new FuncVertex(klass);
            this.funcVertexCache.put(klass, value);
        }
        return value;
    }

    public Collection<FuncVertex> getFuncVertices() {
        return this.funcVertexCache.values();
    }

    public ParamVertex makeParamVertex(FuncVertex func, int index) {
        Pair key = Pair.make((Object)func, (Object)index);
        ParamVertex value = this.paramVertexCache.get(key);
        if (value == null) {
            value = new ParamVertex(func, index);
            this.paramVertexCache.put((Pair<FuncVertex, Integer>)key, value);
        }
        return value;
    }

    public PropVertex makePropVertex(String name) {
        PropVertex value = this.propVertexCache.get(name);
        if (value == null) {
            value = new PropVertex(name);
            this.propVertexCache.put(name, value);
        }
        return value;
    }

    public Iterable<PropVertex> getPropVertices() {
        return this.propVertexCache.values();
    }

    public RetVertex makeRetVertex(FuncVertex func) {
        RetVertex value = this.retVertexCache.get(func);
        if (value == null) {
            value = new RetVertex(func);
            this.retVertexCache.put(func, value);
        }
        return value;
    }

    public Iterable<RetVertex> getRetVertices() {
        return this.retVertexCache.values();
    }

    public ArgVertex makeArgVertex(FuncVertex func) {
        ArgVertex value = this.argVertexCache.get(func);
        if (value == null) {
            value = new ArgVertex(func);
            this.argVertexCache.put(func, value);
        }
        return value;
    }

    public Iterable<ArgVertex> getArgVertices() {
        return this.argVertexCache.values();
    }

    public UnknownVertex makeUnknownVertex() {
        return UnknownVertex.INSTANCE;
    }

    public VarVertex makeVarVertex(FuncVertex func, int valueNumber) {
        Pair key = Pair.make((Object)func, (Object)valueNumber);
        VarVertex value = this.varVertexCache.get(key);
        if (value == null) {
            value = new VarVertex(func, valueNumber);
            this.varVertexCache.put((Pair<FuncVertex, Integer>)key, value);
        }
        return value;
    }

    public Iterable<VarVertex> getVarVertices() {
        return this.varVertexCache.values();
    }

    public LexicalVarVertex makeLexicalAccessVertex(String definer, String name) {
        Pair key = Pair.make((Object)definer, (Object)name);
        LexicalVarVertex value = this.lexicalAccessVertexCache.get(key);
        if (value == null) {
            value = new LexicalVarVertex(definer, name);
            this.lexicalAccessVertexCache.put((Pair<String, String>)key, value);
        }
        return value;
    }

    public GlobalVertex global() {
        return this.global;
    }
}

