/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html;

import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.js.html.DefaultSourceExtractor;
import com.ibm.wala.cast.js.html.DomLessSourceExtractor;
import com.ibm.wala.cast.js.html.IHtmlParser;
import com.ibm.wala.cast.js.html.IHtmlParserFactory;
import com.ibm.wala.cast.js.html.IdentityUrlResolver;
import com.ibm.wala.cast.js.html.JSSourceExtractor;
import com.ibm.wala.cast.js.html.MappedSourceModule;
import com.ibm.wala.cast.js.html.jericho.JerichoHtmlParser;
import com.ibm.wala.cast.js.html.jericho.JerichoTag;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.functions.Function;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;

public class WebUtil {
    public static final String preamble = "preamble.js";
    public static final boolean DEBUG = false;
    private static IHtmlParserFactory factory = new IHtmlParserFactory(){

        @Override
        public IHtmlParser getParser() {
            return new JerichoHtmlParser();
        }
    };

    public static void setFactory(IHtmlParserFactory factory) {
        WebUtil.factory = factory;
    }

    public static Pair<Set<MappedSourceModule>, File> extractScriptFromHTML(URL url, Function<Void, JSSourceExtractor> fSourceExtractor) throws TranslatorToCAst.Error {
        try {
            JSSourceExtractor extractor = (JSSourceExtractor)fSourceExtractor.apply(null);
            Set<MappedSourceModule> sources = extractor.extractSources(url, factory.getParser(), new IdentityUrlResolver());
            return Pair.make(sources, (Object)extractor.getTempFile());
        }
        catch (IOException e) {
            throw new RuntimeException("trouble with " + url, e);
        }
    }

    public static ArrayList<URI> extractScriptURIFromHTML(URL entrypointUrl) throws IOException, URISyntaxException {
        try {
            ArrayList<URI> jsURIs = new ArrayList<URI>();
            jsURIs.add(entrypointUrl.toURI());
            Reader inputStreamReader = WebUtil.getStream(entrypointUrl);
            Source src = new Source(inputStreamReader);
            List childElements = src.getChildElements();
            for (Element e : childElements) {
                WebUtil.parse(jsURIs, e, entrypointUrl);
            }
            return jsURIs;
        }
        catch (IOException e) {
            throw new RuntimeException("trouble with " + entrypointUrl, e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("trouble with " + entrypointUrl.toURI(), e);
        }
    }

    private static void parse(ArrayList<URI> jsURIs, Element element, URL entrypointUrl) throws MalformedURLException, URISyntaxException {
        JerichoTag tag = new JerichoTag(element, entrypointUrl.getFile());
        if (tag.getName().equalsIgnoreCase("script")) {
            Pair<String, CAstSourcePositionMap.Position> content = tag.getAttributeByName("src");
            try {
                if (content != null) {
                    URL scriptSrcURL = new URL(entrypointUrl, (String)content.fst);
                    jsURIs.add(scriptSrcURL.toURI());
                }
            }
            catch (Exception e) {
                return;
            }
        }
        List childElements = element.getChildElements();
        for (Element child : childElements) {
            WebUtil.parse(jsURIs, child, entrypointUrl);
        }
    }

    public static void main(String[] args) throws MalformedURLException, TranslatorToCAst.Error {
        System.err.println(WebUtil.extractScriptFromHTML(new URL(args[0]), Boolean.parseBoolean(args[1]) ? DefaultSourceExtractor.factory : DomLessSourceExtractor.factory));
    }

    public static Reader getStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setDefaultUseCaches(false);
        conn.setUseCaches(false);
        return new InputStreamReader(conn.getInputStream());
    }
}

