/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.AstContextInsensitiveSSAContextInterpreter;
import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.translator.JSAstTranslator;
import com.ibm.wala.cast.js.translator.JSConstantFoldingRewriter;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.cast.tree.rewrite.CAstBasicRewriter;
import com.ibm.wala.cast.util.CAstPattern;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.Map;

public class ArgumentSpecialization {

    public static class ArgumentCountIRFactory
    extends AstIRFactory.AstDefaultIRFactory {
        private static final CAstPattern directAccessPattern = CAstPattern.parse((String)"|(ARRAY_REF(VAR(\"arguments\"),<value>*)||OBJECT_REF(VAR(\"arguments\"),<value>*))|");
        private static final CAstPattern destructuredAccessPattern = CAstPattern.parse((String)"BLOCK_EXPR(ASSIGN(VAR(/[$][$]destructure[$]rcvr[0-9]+/),VAR(\"arguments\")),ASSIGN(VAR(<name>/[$][$]destructure[$]elt[0-9]+/),<value>*))");
        private static final CAstPattern destructuredCallPattern = CAstPattern.parse((String)"CALL(VAR(<name>/[$][$]destructure[$]elt[0-9]+/),\"dispatch\",VAR(<thisptr>/[$][$]destructure[$]rcvr[0-9]+/),<args>**)");
        private final SSAOptions defaultOptions;

        public ArgumentCountIRFactory(SSAOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
        }

        public boolean contextIsIrrelevant(IMethod method) {
            return method instanceof AstMethod.Retranslatable ? false : super.contextIsIrrelevant(method);
        }

        public IR makeIR(final IMethod method, Context context, SSAOptions options) {
            if (method instanceof AstMethod.Retranslatable) {
                final ContextItem.Value v = (ContextItem.Value)context.get(ArgumentCountContext.ARGUMENT_COUNT);
                final AstMethod.Retranslatable m = (AstMethod.Retranslatable)method;
                if (v != null) {
                    final JavaScriptLoader myloader = (JavaScriptLoader)method.getDeclaringClass().getClassLoader();
                    class FixedArgumentsRewriter
                    extends CAstBasicRewriter {
                        private final CAstEntity e;
                        private final Map<String, CAstNode> argRefs;

                        public FixedArgumentsRewriter(CAst Ast) {
                            super(Ast, false);
                            this.argRefs = HashMapFactory.make();
                            this.e = m.getEntity();
                            for (CAstPattern.Segments s : CAstPattern.findAll((CAstPattern)destructuredAccessPattern, (CAstEntity)m.getEntity())) {
                                this.argRefs.put(s.getSingle("name").getValue().toString(), s.getSingle("value"));
                            }
                        }

                        private CAstNode handleArgumentRef(CAstNode n) {
                            Object x = n.getValue();
                            if (x != null) {
                                if (x instanceof Number && ((Number)x).intValue() < (Integer)v.getValue() - 2) {
                                    int arg = ((Number)x).intValue() + 2;
                                    if (arg < this.e.getArgumentCount()) {
                                        return this.Ast.makeNode(111, this.Ast.makeConstant((Object)this.e.getArgumentNames()[arg]));
                                    }
                                    return this.Ast.makeNode(111, this.Ast.makeConstant((Object)("$arg" + arg)));
                                }
                                if (x instanceof String && "length".equals(x)) {
                                    return this.Ast.makeConstant(v.getValue());
                                }
                            }
                            return null;
                        }

                        protected CAstNode copyNodes(CAstNode root, CAstControlFlowMap cfg, CAstBasicRewriter.NonCopyingContext context, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
                            CAstNode result = null;
                            CAstPattern.Segments s = CAstPattern.match((CAstPattern)directAccessPattern, (CAstNode)root);
                            if (s != null) {
                                result = this.handleArgumentRef(s.getSingle("value"));
                            } else {
                                s = CAstPattern.match((CAstPattern)destructuredCallPattern, (CAstNode)root);
                                if (s != null) {
                                    if (this.argRefs.containsKey(s.getSingle("name").getValue().toString())) {
                                        ArrayList<CAstNode> x = new ArrayList<CAstNode>();
                                        CAstNode ref = this.handleArgumentRef(this.argRefs.get(s.getSingle("name").getValue().toString()));
                                        if (ref != null) {
                                            x.add(ref);
                                            x.add(this.Ast.makeConstant((Object)"do"));
                                            x.add(this.Ast.makeNode(111, this.Ast.makeConstant((Object)"arguments")));
                                            for (CAstNode c : s.getMultiple("args")) {
                                                x.add(this.copyNodes(c, cfg, context, nodeMap));
                                            }
                                            result = this.Ast.makeNode(102, x.toArray(new CAstNode[x.size()]));
                                        }
                                    }
                                } else if (root.getKind() == 300) {
                                    result = this.Ast.makeConstant(root.getValue());
                                } else if (root.getKind() == 301) {
                                    result = root;
                                }
                            }
                            if (result == null) {
                                CAstNode copy;
                                CAstNode[] children = new CAstNode[root.getChildCount()];
                                for (int i = 0; i < children.length; ++i) {
                                    children[i] = this.copyNodes(root.getChild(i), cfg, context, nodeMap);
                                }
                                for (Object label : cfg.getTargetLabels(root)) {
                                    if (!(label instanceof CAstNode)) continue;
                                    this.copyNodes((CAstNode)label, cfg, context, nodeMap);
                                }
                                result = copy = this.Ast.makeNode(root.getKind(), children);
                            }
                            nodeMap.put((Pair<CAstNode, CAstBasicRewriter.NoKey>)Pair.make((Object)root, (Object)context.key()), result);
                            return result;
                        }
                    }
                    final FixedArgumentsRewriter args = new FixedArgumentsRewriter((CAst)new CAstImpl());
                    final JSConstantFoldingRewriter fold = new JSConstantFoldingRewriter((CAst)new CAstImpl());
                    class ArgumentativeTranslator
                    extends JSAstTranslator {
                        private CAstEntity codeBodyEntity;
                        private IMethod specializedCode;

                        public ArgumentativeTranslator(JavaScriptLoader loader) {
                            super(loader);
                        }

                        protected int getArgumentCount(CAstEntity f) {
                            return Math.max(super.getArgumentCount(f), (Integer)v.getValue());
                        }

                        protected String[] getArgumentNames(CAstEntity f) {
                            if (super.getArgumentCount(f) >= (Integer)v.getValue()) {
                                return super.getArgumentNames(f);
                            }
                            String[] argNames = new String[((Integer)v.getValue()).intValue()];
                            System.arraycopy(super.getArgumentNames(f), 0, argNames, 0, super.getArgumentCount(f));
                            for (int i = super.getArgumentCount(f); i < argNames.length; ++i) {
                                argNames[i] = "$arg" + i;
                            }
                            return argNames;
                        }

                        @Override
                        protected String composeEntityName(AstTranslator.WalkContext parent, CAstEntity f) {
                            if (f == this.codeBodyEntity) {
                                return super.composeEntityName(parent, f) + "_" + (Integer)v.getValue();
                            }
                            return super.composeEntityName(parent, f);
                        }

                        @Override
                        protected void defineFunction(CAstEntity N, AstTranslator.WalkContext definingContext, AbstractCFG cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation LI, AstMethod.DebuggingInformation debugInfo) {
                            if (N == this.codeBodyEntity) {
                                this.specializedCode = myloader.makeCodeBodyCode(cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, LI, debugInfo, method.getDeclaringClass());
                            } else {
                                super.defineFunction(N, definingContext, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, LI, debugInfo);
                            }
                        }

                        public void translate(CAstEntity N, AstTranslator.WalkContext context) {
                            if (N == m.getEntity()) {
                                this.codeBodyEntity = fold.rewrite(args.rewrite(N));
                                super.translate(this.codeBodyEntity, context);
                            } else {
                                super.translate(N, context);
                            }
                        }
                    }
                    ArgumentativeTranslator a = new ArgumentativeTranslator(myloader);
                    m.retranslate((AstTranslator)a);
                    return super.makeIR(a.specializedCode, context, options);
                }
            }
            return super.makeIR(method, context, options);
        }

        public ControlFlowGraph makeCFG(IMethod method, Context context) {
            return this.makeIR(method, context, this.defaultOptions).getControlFlowGraph();
        }
    }

    public static class ArgumentCountContextSelector
    implements ContextSelector,
    ContextKey {
        private final ContextSelector base;

        public ArgumentCountContextSelector(ContextSelector base) {
            this.base = base;
        }

        public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] actualParameters) {
            Context baseContext = this.base.getCalleeTarget(caller, site, callee, actualParameters);
            if (caller.getMethod() instanceof AstMethod.Retranslatable) {
                int v = -1;
                for (SSAAbstractInvokeInstruction x : caller.getIR().getCalls(site)) {
                    if (v == -1) {
                        v = x.getNumberOfParameters();
                        continue;
                    }
                    if (v == x.getNumberOfParameters()) continue;
                    return baseContext;
                }
                return new ArgumentCountContext(v, baseContext);
            }
            return baseContext;
        }

        public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
            return this.base.getRelevantParameters(caller, site);
        }
    }

    public static class ArgumentCountContext
    implements Context {
        private final Context base;
        private final int argumentCount;
        public static ContextKey ARGUMENT_COUNT = new ContextKey(){

            public String toString() {
                return "argument count key";
            }
        };

        public int hashCode() {
            return this.base.hashCode() + this.argumentCount * 4073;
        }

        public boolean equals(Object o) {
            return o.getClass() == this.getClass() && this.base.equals(((ArgumentCountContext)o).base) && this.argumentCount == ((ArgumentCountContext)o).argumentCount;
        }

        public ArgumentCountContext(int argumentCount, Context base) {
            this.argumentCount = argumentCount;
            this.base = base;
        }

        public ContextItem get(ContextKey name) {
            return name == ARGUMENT_COUNT ? ContextItem.Value.make((Object)this.argumentCount) : this.base.get(name);
        }

        public String toString() {
            return this.base.toString() + "(nargs:" + this.argumentCount + ")";
        }
    }

    public static class ArgumentSpecializationContextIntepreter
    extends AstContextInsensitiveSSAContextInterpreter {
        public ArgumentSpecializationContextIntepreter(AnalysisOptions options, AnalysisCache cache) {
            super(options, cache);
        }

        public IR getIR(CGNode node) {
            if (node.getMethod() instanceof AstMethod.Retranslatable) {
                return this.getAnalysisCache().getSSACache().findOrCreateIR(node.getMethod(), node.getContext(), this.options.getSSAOptions());
            }
            return super.getIR(node);
        }

        public DefUse getDU(CGNode node) {
            if (node.getMethod() instanceof AstMethod.Retranslatable) {
                return this.getAnalysisCache().getSSACache().findOrCreateDU(node.getMethod(), node.getContext(), this.options.getSSAOptions());
            }
            return super.getDU(node);
        }
    }
}

