/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.cast.js.ipa.summaries.JavaScriptConstructorFunctions;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.MethodReference;

public class JavaScriptConstructTargetSelector
implements MethodTargetSelector {
    private final MethodTargetSelector base;
    private final JavaScriptConstructorFunctions constructors;

    public JavaScriptConstructTargetSelector(IClassHierarchy cha, MethodTargetSelector base) {
        this.constructors = new JavaScriptConstructorFunctions(cha);
        this.base = base;
    }

    public JavaScriptConstructTargetSelector(JavaScriptConstructorFunctions constructors, MethodTargetSelector base) {
        this.constructors = constructors;
        this.base = base;
    }

    public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass receiver) {
        if (site.getDeclaredTarget().equals((Object)JavaScriptMethods.ctorReference)) {
            IR callerIR = caller.getIR();
            SSAAbstractInvokeInstruction[] callStmts = callerIR.getCalls(site);
            assert (callStmts.length == 1);
            int nargs = callStmts[0].getNumberOfParameters();
            return this.constructors.findOrCreateConstructorMethod(callerIR, callStmts[0], receiver, nargs - 1);
        }
        return this.base.getCalleeTarget(caller, site, receiver);
    }

    public boolean mightReturnSyntheticMethod(CGNode caller, CallSiteReference site) {
        return true;
    }

    public boolean mightReturnSyntheticMethod(MethodReference declaredTarget) {
        return true;
    }
}

