/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.AstContextInsensitiveSSAContextInterpreter;
import com.ibm.wala.cast.js.ipa.callgraph.JavaScriptFunctionApplyContextSelector;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptSummarizedFunction;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptSummary;
import com.ibm.wala.cast.js.loader.JSCallSiteReference;
import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;

public class JavaScriptFunctionApplyContextInterpreter
extends AstContextInsensitiveSSAContextInterpreter {
    private static final TypeName APPLY_TYPE_NAME = TypeName.findOrCreate((String)"Lprologue.js/Function_prototype_apply");

    public JavaScriptFunctionApplyContextInterpreter(AnalysisOptions options, AnalysisCache cache) {
        super(options, cache);
    }

    public boolean understands(CGNode node) {
        return node.getMethod().getDeclaringClass().getName().equals((Object)APPLY_TYPE_NAME);
    }

    public IR getIR(CGNode node) {
        assert (this.understands(node));
        ContextItem.Value isNonNullArray = (ContextItem.Value)node.getContext().get(JavaScriptFunctionApplyContextSelector.APPLY_NON_NULL_ARGS);
        if (isNonNullArray == null || ((Boolean)isNonNullArray.getValue()).booleanValue()) {
            return this.makeIRForArgList(node);
        }
        return this.makeIRForNoArgList(node);
    }

    private IR makeIRForArgList(CGNode node) {
        MethodReference ref = node.getMethod().getReference();
        IClass declaringClass = node.getMethod().getDeclaringClass();
        JSInstructionFactory insts = (JSInstructionFactory)declaringClass.getClassLoader().getInstructionFactory();
        int nargs = 4;
        JavaScriptSummary S = new JavaScriptSummary(ref, nargs);
        int numParamsToPass = 10;
        int[] paramsToPassToInvoked = new int[numParamsToPass + 1];
        paramsToPassToInvoked[0] = 3;
        int curValNum = this.passActualPropertyValsAsParams(insts, nargs, S, paramsToPassToInvoked);
        JSCallSiteReference cs = new JSCallSiteReference(S.getNextProgramCounter());
        int resultVal = curValNum++;
        int excVal = curValNum++;
        S.addStatement((SSAInstruction)insts.Invoke(S.getNumberOfStatements(), 2, resultVal, paramsToPassToInvoked, excVal, (CallSiteReference)cs));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), resultVal, false));
        S.getNextProgramCounter();
        JavaScriptSummarizedFunction t = new JavaScriptSummarizedFunction(ref, S, declaringClass);
        return t.makeIR(node.getContext(), null);
    }

    private int passArbitraryPropertyValAsParams(JSInstructionFactory insts, int nargs, JavaScriptSummary S, int[] paramsToPassToInvoked) {
        int curValNum = nargs + 2;
        int eachElementGetResult = curValNum++;
        int nullPredVn = curValNum++;
        S.addConstant(nullPredVn, new ConstantValue(null));
        S.addStatement((SSAInstruction)insts.EachElementGetInstruction(S.getNumberOfStatements(), eachElementGetResult, 4, nullPredVn));
        S.getNextProgramCounter();
        int propertyReadResult = curValNum++;
        S.addStatement((SSAInstruction)insts.PropertyRead(S.getNumberOfStatements(), propertyReadResult, 4, eachElementGetResult));
        S.getNextProgramCounter();
        for (int i = 1; i < paramsToPassToInvoked.length; ++i) {
            paramsToPassToInvoked[i] = propertyReadResult;
        }
        return curValNum;
    }

    private int passActualPropertyValsAsParams(JSInstructionFactory insts, int nargs, JavaScriptSummary S, int[] paramsToPassToInvoked) {
        int curValNum = nargs + 2;
        for (int i = 1; i < paramsToPassToInvoked.length; ++i) {
            int constVN = curValNum++;
            S.addConstant(constVN, new ConstantValue(i - 1));
            int propertyReadResult = curValNum++;
            S.addStatement((SSAInstruction)insts.PropertyRead(S.getNumberOfStatements(), propertyReadResult, 4, constVN));
            S.getNextProgramCounter();
            paramsToPassToInvoked[i] = propertyReadResult;
        }
        return curValNum;
    }

    private IR makeIRForNoArgList(CGNode node) {
        MethodReference ref = node.getMethod().getReference();
        IClass declaringClass = node.getMethod().getDeclaringClass();
        JSInstructionFactory insts = (JSInstructionFactory)declaringClass.getClassLoader().getInstructionFactory();
        int nargs = 4;
        JavaScriptSummary S = new JavaScriptSummary(ref, nargs);
        int resultVal = nargs + 2;
        JSCallSiteReference cs = new JSCallSiteReference(S.getNextProgramCounter());
        int[] params = new int[]{3};
        S.addStatement((SSAInstruction)insts.Invoke(S.getNumberOfStatements(), 2, resultVal, params, resultVal + 1, (CallSiteReference)cs));
        S.getNextProgramCounter();
        S.addStatement((SSAInstruction)insts.ReturnInstruction(S.getNumberOfStatements(), resultVal, false));
        S.getNextProgramCounter();
        JavaScriptSummarizedFunction t = new JavaScriptSummarizedFunction(ref, S, declaringClass);
        return t.makeIR(node.getContext(), null);
    }

    public DefUse getDU(CGNode node) {
        assert (this.understands(node));
        return new DefUse(this.getIR(node));
    }
}

