/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction;

import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionPos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.NodePos;
import com.ibm.wala.cast.tree.CAstAnnotation;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstNodeTypeMap;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.rewrite.CAstRewriter;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

class ExtractedFunction
implements CAstEntity {
    private final String name;
    private String[] parms;
    private final ExtractionPos pos;
    private CAstRewriter.Rewrite r;
    private CAstNode root;
    private CAstControlFlowMap cfg;
    private CAstSourcePositionMap posmap;
    private CAstNodeTypeMap types;
    private Map<CAstNode, Collection<CAstEntity>> scopedEntities;

    public ExtractedFunction(String name, ExtractionPos pos) {
        this.name = name;
        this.pos = pos;
    }

    public void setRewrite(CAstRewriter.Rewrite r) {
        assert (this.r == null) : "Rewrite shouldn't be set more than once.";
        this.r = r;
        this.root = r.newRoot();
        this.cfg = r.newCfg();
        this.posmap = r.newPos();
        this.types = r.newTypes();
    }

    public int getKind() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return null;
    }

    public String[] getArgumentNames() {
        this.computeParms();
        return this.parms;
    }

    public CAstNode[] getArgumentDefaults() {
        return new CAstNode[0];
    }

    public int getArgumentCount() {
        this.computeParms();
        return this.parms.length;
    }

    private void computeParms() {
        if (this.parms == null) {
            ArrayList<String> parms = new ArrayList<String>();
            parms.add(this.name);
            parms.add("this");
            parms.addAll(this.pos.getParameters());
            if (this.pos.containsThis()) {
                parms.add(this.pos.getThisParmName());
            }
            this.parms = parms.toArray(new String[0]);
        }
    }

    public Map<CAstNode, Collection<CAstEntity>> getAllScopedEntities() {
        if (this.scopedEntities == null) {
            this.scopedEntities = HashMapFactory.make();
            for (Map.Entry e : this.r.newChildren().entrySet()) {
                if (!NodePos.inSubtree((CAstNode)e.getKey(), this.root)) continue;
                HashSet c = this.scopedEntities.get(e.getKey());
                if (c == null) {
                    c = HashSetFactory.make();
                    this.scopedEntities.put((CAstNode)e.getKey(), c);
                }
                c.addAll((Collection)e.getValue());
            }
            Iterator<ExtractionPos> iter = this.pos.getNestedLoops();
            while (iter.hasNext()) {
                ExtractionPos nested_loop = iter.next();
                CAstNode callsite = nested_loop.getCallSite();
                CAstEntity scoped_entity = nested_loop.getExtractedEntity();
                HashSet c = this.scopedEntities.get(callsite);
                if (c == null) {
                    c = HashSetFactory.make();
                    this.scopedEntities.put(callsite, c);
                }
                c.add((CAstEntity)scoped_entity);
            }
        }
        return this.scopedEntities;
    }

    public Iterator<CAstEntity> getScopedEntities(CAstNode construct) {
        if (this.getAllScopedEntities().containsKey(construct)) {
            return this.getAllScopedEntities().get(construct).iterator();
        }
        return EmptyIterator.instance();
    }

    public CAstNode getAST() {
        return this.root;
    }

    public CAstControlFlowMap getControlFlow() {
        return this.cfg;
    }

    public CAstSourcePositionMap getSourceMap() {
        return this.posmap;
    }

    public CAstSourcePositionMap.Position getPosition() {
        return this.getSourceMap().getPosition(this.root);
    }

    public CAstNodeTypeMap getNodeTypeMap() {
        return this.types;
    }

    public Collection<CAstQualifier> getQualifiers() {
        return null;
    }

    public CAstType getType() {
        return null;
    }

    public Collection<CAstAnnotation> getAnnotations() {
        return null;
    }

    public String toString() {
        return "<JS function " + this.name + ">";
    }
}

