/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.loader;

import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.ir.translator.TranslatorToIR;
import com.ibm.wala.cast.js.analysis.typeInference.JSPrimitiveType;
import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.ssa.JavaScriptCheckReference;
import com.ibm.wala.cast.js.ssa.JavaScriptInstanceOf;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyRead;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyWrite;
import com.ibm.wala.cast.js.ssa.JavaScriptTypeOfInstruction;
import com.ibm.wala.cast.js.ssa.JavaScriptWithRegion;
import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.cast.js.ssa.SetPrototype;
import com.ibm.wala.cast.js.translator.JSAstTranslator;
import com.ibm.wala.cast.js.translator.JavaScriptTranslatorFactory;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.loader.AstClass;
import com.ibm.wala.cast.loader.AstDynamicPropertyClass;
import com.ibm.wala.cast.loader.AstFunctionClass;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.loader.CAstAbstractModuleLoader;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.rewrite.CAstRewriterFactory;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.LanguageImpl;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAAbstractBinaryInstruction;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadIndirectInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAStoreIndirectInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class JavaScriptLoader
extends CAstAbstractModuleLoader {
    public static final Language JS = new LanguageImpl(){
        {
            JSPrimitiveType.init();
        }

        public Atom getName() {
            return Atom.findOrCreateUnicodeAtom((String)"JavaScript");
        }

        public TypeReference getRootType() {
            return JavaScriptTypes.Root;
        }

        public TypeReference getThrowableType() {
            return JavaScriptTypes.Root;
        }

        public TypeReference getConstantType(Object o) {
            if (o == null) {
                return JavaScriptTypes.Null;
            }
            Class<?> c = o.getClass();
            if (c == Boolean.class) {
                return JavaScriptTypes.Boolean;
            }
            if (c == String.class) {
                return JavaScriptTypes.String;
            }
            if (c == Integer.class) {
                return JavaScriptTypes.Number;
            }
            if (c == Float.class) {
                return JavaScriptTypes.Number;
            }
            if (c == Double.class) {
                return JavaScriptTypes.Number;
            }
            assert (false) : "cannot determine type for " + o + " of class " + c;
            return null;
        }

        public boolean isNullType(TypeReference type) {
            return type.equals((Object)JavaScriptTypes.Undefined) || type.equals((Object)JavaScriptTypes.Null);
        }

        public TypeReference[] getArrayInterfaces() {
            return new TypeReference[0];
        }

        public TypeName lookupPrimitiveType(String name) {
            if ("Boolean".equals(name)) {
                return JavaScriptTypes.Boolean.getName();
            }
            if ("Number".equals(name)) {
                return JavaScriptTypes.Number.getName();
            }
            if ("String".equals(name)) {
                return JavaScriptTypes.String.getName();
            }
            if ("Date".equals(name)) {
                return JavaScriptTypes.Date.getName();
            }
            assert ("RegExp".equals(name));
            return JavaScriptTypes.RegExp.getName();
        }

        public Collection<TypeReference> inferInvokeExceptions(MethodReference target, IClassHierarchy cha) throws InvalidClassFileException {
            return Collections.singleton(JavaScriptTypes.Root);
        }

        public Object getMetadataToken(Object value) {
            assert (false);
            return null;
        }

        public TypeReference getPointerType(TypeReference pointee) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("JavaScript does not permit explicit pointers");
        }

        public JSInstructionFactory instructionFactory() {
            return new JSInstructionFactory(){

                @Override
                public JavaScriptCheckReference CheckReference(int iindex, int ref) {
                    return new JavaScriptCheckReference(iindex, ref);
                }

                @Override
                public SSAGetInstruction GetInstruction(int iindex, int result, int ref, String field) {
                    return this.GetInstruction(iindex, result, ref, FieldReference.findOrCreate((TypeReference)JavaScriptTypes.Root, (Atom)Atom.findOrCreateUnicodeAtom((String)field), (TypeReference)JavaScriptTypes.Root));
                }

                @Override
                public JavaScriptInstanceOf InstanceOf(int iindex, int result, int objVal, int typeVal) {
                    return new JavaScriptInstanceOf(iindex, result, objVal, typeVal);
                }

                @Override
                public JavaScriptInvoke Invoke(int iindex, int function, int[] results, int[] params, int exception, CallSiteReference site) {
                    return new JavaScriptInvoke(iindex, function, results, params, exception, site);
                }

                @Override
                public JavaScriptInvoke Invoke(int iindex, int function, int result, int[] params, int exception, CallSiteReference site) {
                    return new JavaScriptInvoke(iindex, function, result, params, exception, site);
                }

                @Override
                public JavaScriptInvoke Invoke(int iindex, int function, int[] params, int exception, CallSiteReference site) {
                    return new JavaScriptInvoke(iindex, function, params, exception, site);
                }

                @Override
                public JavaScriptPropertyRead PropertyRead(int iindex, int result, int objectRef, int memberRef) {
                    return new JavaScriptPropertyRead(iindex, result, objectRef, memberRef);
                }

                @Override
                public JavaScriptPropertyWrite PropertyWrite(int iindex, int objectRef, int memberRef, int value) {
                    return new JavaScriptPropertyWrite(iindex, objectRef, memberRef, value);
                }

                @Override
                public SSAPutInstruction PutInstruction(int iindex, int ref, int value, String field) {
                    try {
                        byte[] utf8 = field.getBytes("UTF-8");
                        return this.PutInstruction(iindex, ref, value, FieldReference.findOrCreate((TypeReference)JavaScriptTypes.Root, (Atom)Atom.findOrCreate((byte[])utf8, (int)0, (int)utf8.length), (TypeReference)JavaScriptTypes.Root));
                    }
                    catch (UnsupportedEncodingException e) {
                        Assertions.UNREACHABLE();
                        return null;
                    }
                }

                @Override
                public JavaScriptTypeOfInstruction TypeOfInstruction(int iindex, int lval, int object) {
                    return new JavaScriptTypeOfInstruction(iindex, lval, object);
                }

                @Override
                public JavaScriptWithRegion WithRegion(int iindex, int expr, boolean isEnter) {
                    return new JavaScriptWithRegion(iindex, expr, isEnter);
                }

                public AstAssertInstruction AssertInstruction(int iindex, int value, boolean fromSpecification) {
                    return new AstAssertInstruction(iindex, value, fromSpecification);
                }

                public AssignInstruction AssignInstruction(int iindex, int result, int val) {
                    return new AssignInstruction(iindex, result, val);
                }

                public EachElementGetInstruction EachElementGetInstruction(int iindex, int value, int objectRef, int prevProp) {
                    return new EachElementGetInstruction(iindex, value, objectRef, prevProp);
                }

                public EachElementHasNextInstruction EachElementHasNextInstruction(int iindex, int value, int objectRef, int prop) {
                    return new EachElementHasNextInstruction(iindex, value, objectRef, prop);
                }

                public AstEchoInstruction EchoInstruction(int iindex, int[] rvals) {
                    return new AstEchoInstruction(iindex, rvals);
                }

                public AstGlobalRead GlobalRead(int iindex, int lhs, FieldReference global) {
                    return new AstGlobalRead(iindex, lhs, global);
                }

                public AstGlobalWrite GlobalWrite(int iindex, FieldReference global, int rhs) {
                    return new AstGlobalWrite(iindex, global, rhs);
                }

                public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, int fieldVal, FieldReference fieldRef) {
                    return new AstIsDefinedInstruction(iindex, lval, rval, fieldVal, fieldRef);
                }

                public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, FieldReference fieldRef) {
                    return new AstIsDefinedInstruction(iindex, lval, rval, fieldRef);
                }

                public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, int fieldVal) {
                    return new AstIsDefinedInstruction(iindex, lval, rval, fieldVal);
                }

                public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval) {
                    return new AstIsDefinedInstruction(iindex, lval, rval);
                }

                public AstLexicalRead LexicalRead(int iindex, AstLexicalAccess.Access[] accesses) {
                    return new AstLexicalRead(iindex, accesses);
                }

                public AstLexicalRead LexicalRead(int iindex, AstLexicalAccess.Access access) {
                    return new AstLexicalRead(iindex, access);
                }

                public AstLexicalRead LexicalRead(int iindex, int lhs, String definer, String globalName, TypeReference type) {
                    return new AstLexicalRead(iindex, lhs, definer, globalName, type);
                }

                public AstLexicalWrite LexicalWrite(int iindex, AstLexicalAccess.Access[] accesses) {
                    return new AstLexicalWrite(iindex, accesses);
                }

                public AstLexicalWrite LexicalWrite(int iindex, AstLexicalAccess.Access access) {
                    return new AstLexicalWrite(iindex, access);
                }

                public AstLexicalWrite LexicalWrite(int iindex, String definer, String globalName, TypeReference type, int rhs) {
                    return new AstLexicalWrite(iindex, definer, globalName, type, rhs);
                }

                public SSAArrayLengthInstruction ArrayLengthInstruction(int iindex, int result, int arrayref) {
                    throw new UnsupportedOperationException();
                }

                public SSAArrayLoadInstruction ArrayLoadInstruction(int iindex, int result, int arrayref, int index, TypeReference declaredType) {
                    throw new UnsupportedOperationException();
                }

                public SSAArrayStoreInstruction ArrayStoreInstruction(int iindex, int arrayref, int index, int value, TypeReference declaredType) {
                    throw new UnsupportedOperationException();
                }

                public SSAAbstractBinaryInstruction BinaryOpInstruction(int iindex, IBinaryOpInstruction.IOperator operator, boolean overflow, boolean unsigned, int result, int val1, int val2, boolean mayBeInteger) {
                    return new SSABinaryOpInstruction(iindex, operator, result, val1, val2, mayBeInteger){

                        public boolean isPEI() {
                            return false;
                        }

                        public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
                            return insts.BinaryOpInstruction(this.iindex, this.getOperator(), false, false, defs == null || defs.length == 0 ? this.getDef(0) : defs[0], uses == null ? this.getUse(0) : uses[0], uses == null ? this.getUse(1) : uses[1], this.mayBeIntegerOp());
                        }
                    };
                }

                public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, TypeReference[] types, boolean isPEI) {
                    throw new UnsupportedOperationException();
                }

                public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, int[] typeValues, boolean isPEI) {
                    throw new UnsupportedOperationException();
                }

                public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, int typeValue, boolean isPEI) {
                    assert (isPEI);
                    return this.CheckCastInstruction(iindex, result, val, new int[]{typeValue}, true);
                }

                public SSACheckCastInstruction CheckCastInstruction(int iindex, int result, int val, TypeReference type, boolean isPEI) {
                    assert (isPEI);
                    return this.CheckCastInstruction(iindex, result, val, new TypeReference[]{type}, true);
                }

                public SSAComparisonInstruction ComparisonInstruction(int iindex, IComparisonInstruction.Operator operator, int result, int val1, int val2) {
                    return new SSAComparisonInstruction(iindex, operator, result, val1, val2);
                }

                public SSAConditionalBranchInstruction ConditionalBranchInstruction(int iindex, IConditionalBranchInstruction.IOperator operator, TypeReference type, int val1, int val2, int target) {
                    return new SSAConditionalBranchInstruction(iindex, operator, type, val1, val2, target);
                }

                public SSAConversionInstruction ConversionInstruction(int iindex, int result, int val, TypeReference fromType, TypeReference toType, boolean overflow) {
                    assert (!overflow);
                    return new SSAConversionInstruction(iindex, result, val, fromType, toType){

                        public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
                            if (uses != null && uses.length == 0) {
                                throw new IllegalArgumentException("(uses != null) and (uses.length == 0)");
                            }
                            return insts.ConversionInstruction(this.iindex, defs == null || defs.length == 0 ? this.getDef(0) : defs[0], uses == null ? this.getUse(0) : uses[0], this.getFromType(), this.getToType(), false);
                        }
                    };
                }

                public SSAGetCaughtExceptionInstruction GetCaughtExceptionInstruction(int iindex, int bbNumber, int exceptionValueNumber) {
                    return new SSAGetCaughtExceptionInstruction(iindex, bbNumber, exceptionValueNumber);
                }

                public SSAGetInstruction GetInstruction(int iindex, int result, FieldReference field) {
                    throw new UnsupportedOperationException();
                }

                public SSAGetInstruction GetInstruction(int iindex, int result, int ref, FieldReference field) {
                    return new SSAGetInstruction(iindex, result, ref, field){

                        public boolean isPEI() {
                            return false;
                        }
                    };
                }

                public SSAGotoInstruction GotoInstruction(int iindex, int target) {
                    return new SSAGotoInstruction(iindex, target);
                }

                public SSAInstanceofInstruction InstanceofInstruction(int iindex, int result, int ref, TypeReference checkedType) {
                    throw new UnsupportedOperationException();
                }

                public SSAInvokeInstruction InvokeInstruction(int iindex, int result, int[] params, int exception, CallSiteReference site, BootstrapMethodsReader.BootstrapMethod bootstrap) {
                    throw new UnsupportedOperationException();
                }

                public SSAInvokeInstruction InvokeInstruction(int iindex, int[] params, int exception, CallSiteReference site, BootstrapMethodsReader.BootstrapMethod bootstrap) {
                    throw new UnsupportedOperationException();
                }

                public SSALoadMetadataInstruction LoadMetadataInstruction(int iindex, int lval, TypeReference entityType, Object token) {
                    throw new UnsupportedOperationException();
                }

                public SSAMonitorInstruction MonitorInstruction(int iindex, int ref, boolean isEnter) {
                    throw new UnsupportedOperationException();
                }

                public SSANewInstruction NewInstruction(int iindex, int result, NewSiteReference site) {
                    return new SSANewInstruction(iindex, result, site){

                        public boolean isPEI() {
                            return true;
                        }

                        public Collection<TypeReference> getExceptionTypes() {
                            return Collections.singleton(JavaScriptTypes.TypeError);
                        }
                    };
                }

                public SSANewInstruction NewInstruction(int iindex, int result, NewSiteReference site, int[] params) {
                    throw new UnsupportedOperationException();
                }

                public SSAPhiInstruction PhiInstruction(int iindex, int result, int[] params) {
                    return new SSAPhiInstruction(iindex, result, params);
                }

                public SSAPiInstruction PiInstruction(int iindex, int result, int val, int piBlock, int successorBlock, SSAInstruction cause) {
                    return new SSAPiInstruction(iindex, result, val, piBlock, successorBlock, cause);
                }

                public SSAPutInstruction PutInstruction(int iindex, int ref, int value, FieldReference field) {
                    return new SSAPutInstruction(iindex, ref, value, field){

                        public boolean isPEI() {
                            return false;
                        }
                    };
                }

                public SSAPutInstruction PutInstruction(int iindex, int value, FieldReference field) {
                    throw new UnsupportedOperationException();
                }

                public SSAReturnInstruction ReturnInstruction(int iindex) {
                    return new SSAReturnInstruction(iindex);
                }

                public SSAReturnInstruction ReturnInstruction(int iindex, int result, boolean isPrimitive) {
                    return new SSAReturnInstruction(iindex, result, isPrimitive);
                }

                public SSASwitchInstruction SwitchInstruction(int iindex, int val, int defaultLabel, int[] casesAndLabels) {
                    return new SSASwitchInstruction(iindex, val, defaultLabel, casesAndLabels);
                }

                public SSAThrowInstruction ThrowInstruction(int iindex, int exception) {
                    return new SSAThrowInstruction(iindex, exception){

                        public boolean isPEI() {
                            return true;
                        }

                        public Collection<TypeReference> getExceptionTypes() {
                            return Collections.emptySet();
                        }
                    };
                }

                public SSAUnaryOpInstruction UnaryOpInstruction(int iindex, IUnaryOpInstruction.IOperator operator, int result, int val) {
                    return new SSAUnaryOpInstruction(iindex, operator, result, val);
                }

                public SSAAddressOfInstruction AddressOfInstruction(int iindex, int lval, int local, TypeReference pointeeType) {
                    throw new UnsupportedOperationException();
                }

                public SSAAddressOfInstruction AddressOfInstruction(int iindex, int lval, int local, int indexVal, TypeReference pointeeType) {
                    throw new UnsupportedOperationException();
                }

                public SSAAddressOfInstruction AddressOfInstruction(int iindex, int lval, int local, FieldReference field, TypeReference pointeeType) {
                    throw new UnsupportedOperationException();
                }

                public SSALoadIndirectInstruction LoadIndirectInstruction(int iindex, int lval, TypeReference t, int addressVal) {
                    throw new UnsupportedOperationException();
                }

                public SSAStoreIndirectInstruction StoreIndirectInstruction(int iindex, int addressVal, int rval, TypeReference t) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public PrototypeLookup PrototypeLookup(int iindex, int lval, int object) {
                    return new PrototypeLookup(iindex, lval, object);
                }

                @Override
                public SetPrototype SetPrototype(int iindex, int object, int prototype) {
                    return new SetPrototype(iindex, object, prototype);
                }
            };
        }

        public boolean isDoubleType(TypeReference type) {
            return type == JavaScriptTypes.Number || type == JavaScriptTypes.NumberObject;
        }

        public boolean isFloatType(TypeReference type) {
            return false;
        }

        public boolean isIntType(TypeReference type) {
            return false;
        }

        public boolean isLongType(TypeReference type) {
            return false;
        }

        public boolean isMetadataType(TypeReference type) {
            return false;
        }

        public boolean isStringType(TypeReference type) {
            return type == JavaScriptTypes.String || type == JavaScriptTypes.StringObject;
        }

        public boolean isVoidType(TypeReference type) {
            return false;
        }

        public TypeReference getStringType() {
            return JavaScriptTypes.String;
        }

        public PrimitiveType getPrimitive(TypeReference reference) {
            return PrimitiveType.getPrimitive((TypeReference)reference);
        }

        public boolean isBooleanType(TypeReference type) {
            return JavaScriptTypes.Boolean.equals((Object)type);
        }

        public boolean isCharType(TypeReference type) {
            return false;
        }
    };
    private static final Map<Selector, IMethod> emptyMap1 = Collections.emptyMap();
    private static final Map<Atom, IField> emptyMap2 = Collections.emptyMap();
    private final JavaScriptTranslatorFactory translatorFactory;
    private final CAstRewriterFactory preprocessor;
    private static final Set<CAstQualifier> functionQualifiers = HashSetFactory.make();
    final JavaScriptRootClass ROOT = new JavaScriptRootClass((IClassLoader)this, null);
    final JavaScriptClass UNDEFINED = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Undefined, JavaScriptTypes.Root, null);
    final JavaScriptClass PRIMITIVES = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Primitives, JavaScriptTypes.Root, null);
    final JavaScriptClass FAKEROOT = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.FakeRoot, JavaScriptTypes.Root, null);
    final JavaScriptClass STRING = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.String, JavaScriptTypes.Root, null);
    final JavaScriptClass NULL = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Null, JavaScriptTypes.Root, null);
    final JavaScriptClass ARRAY = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Array, JavaScriptTypes.Root, null);
    final JavaScriptClass OBJECT = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Object, JavaScriptTypes.Root, null);
    final JavaScriptClass TYPE_ERROR = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.TypeError, JavaScriptTypes.Root, null);
    final JavaScriptClass CODE_BODY = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.CodeBody, JavaScriptTypes.Root, null);
    final JavaScriptClass FUNCTION = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Function, JavaScriptTypes.CodeBody, null);
    final JavaScriptClass SCRIPT = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Script, JavaScriptTypes.CodeBody, null);
    final JavaScriptClass BOOLEAN = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Boolean, JavaScriptTypes.Root, null);
    final JavaScriptClass NUMBER = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Number, JavaScriptTypes.Root, null);
    final JavaScriptClass DATE = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.Date, JavaScriptTypes.Root, null);
    final JavaScriptClass REGEXP = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.RegExp, JavaScriptTypes.Root, null);
    final JavaScriptClass BOOLEAN_OBJECT = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.BooleanObject, JavaScriptTypes.Object, null);
    final JavaScriptClass NUMBER_OBJECT = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.NumberObject, JavaScriptTypes.Object, null);
    final JavaScriptClass DATE_OBJECT = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.DateObject, JavaScriptTypes.Object, null);
    final JavaScriptClass REGEXP_OBJECT = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.RegExpObject, JavaScriptTypes.Object, null);
    final JavaScriptClass STRING_OBJECT = new JavaScriptClass((IClassLoader)this, JavaScriptTypes.StringObject, JavaScriptTypes.Object, null);
    public static final Set<String> bootstrapFileNames;
    private static String prologueFileName;

    public JavaScriptLoader(IClassHierarchy cha, JavaScriptTranslatorFactory translatorFactory) {
        this(cha, translatorFactory, null);
    }

    public JavaScriptLoader(IClassHierarchy cha, JavaScriptTranslatorFactory translatorFactory, CAstRewriterFactory preprocessor) {
        super(cha);
        this.translatorFactory = translatorFactory;
        this.preprocessor = preprocessor;
    }

    public IClass makeCodeBodyType(String name, TypeReference P, CAstSourcePositionMap.Position sourcePosition, CAstEntity entity, AstTranslator.WalkContext context) {
        return new JavaScriptCodeBody(TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (TypeName)TypeName.string2TypeName((String)name)), P, (IClassLoader)this, sourcePosition, entity, context);
    }

    public IClass defineFunctionType(String name, CAstSourcePositionMap.Position pos, CAstEntity entity, AstTranslator.WalkContext context) {
        return this.makeCodeBodyType(name, JavaScriptTypes.Function, pos, entity, context);
    }

    public IClass defineScriptType(String name, CAstSourcePositionMap.Position pos, CAstEntity entity, AstTranslator.WalkContext context) {
        return this.makeCodeBodyType(name, JavaScriptTypes.Script, pos, entity, context);
    }

    public IMethod defineCodeBodyCode(String clsName, AbstractCFG cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
        JavaScriptCodeBody C = (JavaScriptCodeBody)this.lookupClass(clsName, this.cha);
        assert (C != null) : clsName;
        return C.setCodeBody(this.makeCodeBodyCode(cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo, (IClass)C));
    }

    public JavaScriptMethodObject makeCodeBodyCode(AbstractCFG cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo, IClass C) {
        return new JavaScriptMethodObject(C, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo);
    }

    public Language getLanguage() {
        return JS;
    }

    public ClassLoaderReference getReference() {
        return JavaScriptTypes.jsLoader;
    }

    public SSAInstructionFactory getInstructionFactory() {
        return JS.instructionFactory();
    }

    public static void resetPrologueFile() {
        prologueFileName = "prologue.js";
    }

    public static void setPrologueFile(String name) {
        prologueFileName = name;
    }

    public static void addBootstrapFile(String fileName) {
        bootstrapFileNames.add(fileName);
    }

    protected TranslatorToCAst getTranslatorToCAst(CAst ast, SourceModule module) {
        TranslatorToCAst translator = this.translatorFactory.make(ast, module);
        if (this.preprocessor != null) {
            translator.addRewriter(this.preprocessor, true);
        }
        return translator;
    }

    protected TranslatorToIR initTranslator() {
        return new JSAstTranslator(this);
    }

    protected boolean shouldTranslate(CAstEntity entity) {
        return true;
    }

    static {
        functionQualifiers.add(CAstQualifier.PUBLIC);
        functionQualifiers.add(CAstQualifier.FINAL);
        prologueFileName = "prologue.js";
        bootstrapFileNames = HashSetFactory.make();
        bootstrapFileNames.add(prologueFileName);
    }

    public class JavaScriptMethodObject
    extends AstMethod
    implements AstMethod.Retranslatable {
        private AstTranslator.WalkContext translationContext;
        private CAstEntity entity;

        JavaScriptMethodObject(IClass cls, AbstractCFG cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
            super(cls, (Collection)functionQualifiers, cfg, symtab, AstMethodReference.fnReference((TypeReference)cls.getReference()), hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo, null);
            symtab.getNullConstant();
        }

        public CAstEntity getEntity() {
            return this.entity;
        }

        public void retranslate(AstTranslator xlator) {
            xlator.translate(this.entity, this.translationContext);
        }

        public IClassHierarchy getClassHierarchy() {
            return JavaScriptLoader.this.cha;
        }

        public String toString() {
            return "<Code body of " + this.cls + ">";
        }

        public TypeReference[] getDeclaredExceptions() {
            return null;
        }

        public AstMethod.LexicalParent[] getParents() {
            if (this.lexicalInfo() == null) {
                return new AstMethod.LexicalParent[0];
            }
            final String[] parents = this.lexicalInfo().getScopingParents();
            if (parents == null) {
                return new AstMethod.LexicalParent[0];
            }
            AstMethod.LexicalParent[] result = new AstMethod.LexicalParent[parents.length];
            for (int i = 0; i < parents.length; ++i) {
                final int hack = i;
                final AstMethod method = (AstMethod)JavaScriptLoader.this.lookupClass(parents[i], JavaScriptLoader.this.cha).getMethod(AstMethodReference.fnSelector);
                result[i] = new AstMethod.LexicalParent(){

                    public String getName() {
                        return parents[hack];
                    }

                    public AstMethod getMethod() {
                        return method;
                    }
                };
            }
            return result;
        }

        public String getLocalVariableName(int bcIndex, int localNumber) {
            return null;
        }

        public boolean hasLocalVariableTable() {
            return false;
        }

        public int getMaxLocals() {
            Assertions.UNREACHABLE();
            return -1;
        }

        public int getMaxStackHeight() {
            Assertions.UNREACHABLE();
            return -1;
        }

        public TypeReference getParameterType(int i) {
            if (i == 0) {
                return this.getDeclaringClass().getReference();
            }
            return JavaScriptTypes.Root;
        }
    }

    class JavaScriptCodeBody
    extends AstFunctionClass {
        private final AstTranslator.WalkContext translationContext;
        private final CAstEntity entity;

        public JavaScriptCodeBody(TypeReference codeName, TypeReference parent, IClassLoader loader, CAstSourcePositionMap.Position sourcePosition, CAstEntity entity, AstTranslator.WalkContext context) {
            super(codeName, parent, loader, sourcePosition);
            JavaScriptLoader.this.types.put(codeName.getName(), this);
            this.translationContext = context;
            this.entity = entity;
        }

        public IClassHierarchy getClassHierarchy() {
            return JavaScriptLoader.this.cha;
        }

        private IMethod setCodeBody(JavaScriptMethodObject codeBody) {
            this.functionBody = codeBody;
            codeBody.entity = this.entity;
            codeBody.translationContext = this.translationContext;
            return codeBody;
        }

        public Collection<Annotation> getAnnotations() {
            return Collections.emptySet();
        }
    }

    class JavaScriptRootClass
    extends AstDynamicPropertyClass {
        private JavaScriptRootClass(IClassLoader loader, CAstSourcePositionMap.Position sourcePosition) {
            super(sourcePosition, JavaScriptTypes.Root.getName(), loader, (short)0, emptyMap1, JavaScriptTypes.Root);
            JavaScriptLoader.this.types.put(JavaScriptTypes.Root.getName(), this);
        }

        public IClassHierarchy getClassHierarchy() {
            return JavaScriptLoader.this.cha;
        }

        public String toString() {
            return "JS Root:" + this.getReference().toString();
        }

        public Collection<IClass> getDirectInterfaces() {
            return Collections.emptySet();
        }

        public IClass getSuperclass() {
            return null;
        }

        public Collection<Annotation> getAnnotations() {
            return Collections.emptySet();
        }
    }

    class JavaScriptClass
    extends AstClass {
        private IClass superClass;

        private JavaScriptClass(IClassLoader loader, TypeReference classRef, TypeReference superRef, CAstSourcePositionMap.Position sourcePosition) {
            super(sourcePosition, classRef.getName(), loader, (short)0, emptyMap2, emptyMap1);
            JavaScriptLoader.this.types.put(classRef.getName(), this);
            this.superClass = superRef == null ? null : loader.lookupClass(superRef.getName());
        }

        public IClassHierarchy getClassHierarchy() {
            return JavaScriptLoader.this.cha;
        }

        public String toString() {
            return "JS:" + this.getReference().toString();
        }

        public Collection<IClass> getDirectInterfaces() {
            return Collections.emptySet();
        }

        public IClass getSuperclass() {
            return this.superClass;
        }

        public Collection<Annotation> getAnnotations() {
            return Collections.emptySet();
        }
    }
}

