/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ssa;

import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.ssa.JSInstructionVisitor;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.Collections;

public class JavaScriptCheckReference
extends SSAInstruction {
    private final int ref;

    public JavaScriptCheckReference(int iindex, int ref) {
        super(iindex);
        this.ref = ref;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return ((JSInstructionFactory)insts).CheckReference(this.iindex, uses == null ? this.ref : uses[0]);
    }

    public Collection<TypeReference> getExceptionTypes() {
        return Collections.singleton(JavaScriptTypes.ReferenceError);
    }

    public int hashCode() {
        return 87621 * this.ref;
    }

    public boolean isFallThrough() {
        return true;
    }

    public String toString(SymbolTable symbolTable) {
        return "check " + this.getValueString(symbolTable, this.ref);
    }

    public void visit(SSAInstruction.IVisitor v) {
        ((JSInstructionVisitor)v).visitCheckRef(this);
    }

    public boolean isPEI() {
        return true;
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int i) {
        assert (i == 0);
        return this.ref;
    }
}

